/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.adyen.model.marketpay.ErrorFieldType;
import com.adyen.util.Util;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;

public class ApiError {
    @SerializedName(value="status")
    private int status;
    @SerializedName(value="errorCode")
    private String errorCode = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="errorType")
    private String errorType = null;
    @SerializedName(value="pspReference")
    private String pspReference = null;
    @SerializedName(value="invalidFields")
    private List<ErrorFieldType> invalidFields = null;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public static ApiError fromJson(String jsonString) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(ApiError.class, (Object)new ApiErrorAdapter()).create();
        return (ApiError)gson.fromJson(jsonString, ApiError.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiError {\n");
        sb.append("    status: ").append(Util.toIndentedString(this.status)).append("\n");
        sb.append("    errorCode: ").append(Util.toIndentedString(this.errorCode)).append("\n");
        sb.append("    message: ").append(Util.toIndentedString(this.message)).append("\n");
        sb.append("    errorType: ").append(Util.toIndentedString(this.errorType)).append("\n");
        sb.append("    pspReference: ").append(Util.toIndentedString(this.pspReference)).append("\n");
        sb.append("    invalidFields: ").append(Util.toIndentedString(this.invalidFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    static class ApiErrorAdapter
    extends TypeAdapter<ApiError> {
        private final Gson gson = new Gson();

        ApiErrorAdapter() {
        }

        public void write(JsonWriter out, ApiError value) throws IOException {
        }

        public ApiError read(JsonReader jsonReader) throws IOException {
            ApiError apiError;
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(jsonReader, JsonObject.class);
            JsonElement typeJsonElement = jsonObject.get("type");
            if (typeJsonElement != null) {
                apiError = new ApiError();
                apiError.errorType = this.getStringValue(jsonObject, "type");
                apiError.status = this.getIntValue(jsonObject, "status");
                apiError.message = this.getStringValue(jsonObject, "detail");
                apiError.invalidFields = this.getListValue(jsonObject, "invalidFields");
                apiError.errorCode = this.getStringValue(jsonObject, "errorCode");
            } else {
                apiError = (ApiError)this.gson.fromJson((JsonElement)jsonObject, ApiError.class);
            }
            return apiError;
        }

        String getStringValue(JsonObject jsonObject, String field) {
            return jsonObject.get(field) != null ? jsonObject.get(field).getAsString() : null;
        }

        Integer getIntValue(JsonObject jsonObject, String field) {
            return jsonObject.get(field) != null ? Integer.valueOf(jsonObject.get(field).getAsInt()) : null;
        }

        List getListValue(JsonObject jsonObject, String field) {
            return jsonObject.get(field) != null ? jsonObject.get(field).getAsJsonArray().asList() : null;
        }
    }
}

