/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.adyen.model.FraudCheckResult;
import com.adyen.model.FraudCheckResultContainer;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FraudResult {
    @SerializedName(value="accountScore")
    private Integer accountScore = null;
    @SerializedName(value="results")
    private List<FraudCheckResultContainer> results = new ArrayList<FraudCheckResultContainer>();

    public FraudResult accountScore(Integer accountScore) {
        this.accountScore = accountScore;
        return this;
    }

    public Integer getAccountScore() {
        return this.accountScore;
    }

    public void setAccountScore(Integer accountScore) {
        this.accountScore = accountScore;
    }

    public FraudResult results(List<FraudCheckResultContainer> results) {
        this.results = results;
        return this;
    }

    public List<FraudCheckResultContainer> getResults() {
        return this.results;
    }

    public void setResults(List<FraudCheckResultContainer> results) {
        this.results = results;
    }

    public List<FraudCheckResult> getFraudCheckResults() {
        ArrayList<FraudCheckResult> fraudCheckResults = new ArrayList<FraudCheckResult>();
        for (FraudCheckResultContainer fraudCheckResultContainer : this.results) {
            fraudCheckResults.add(fraudCheckResultContainer.getFraudCheckResult());
        }
        return fraudCheckResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FraudResult fraudResult = (FraudResult)o;
        return Objects.equals(this.accountScore, fraudResult.accountScore) && Objects.equals(this.results, fraudResult.results);
    }

    public int hashCode() {
        return Objects.hash(this.accountScore, this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FraudResult {\n");
        sb.append("    accountScore: ").append(this.toIndentedString(this.accountScore)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

