/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.model.RequestOptions;
import com.adyen.model.payments.AdjustAuthorisationRequest;
import com.adyen.model.payments.ApplicationInfo;
import com.adyen.model.payments.AuthenticationResultRequest;
import com.adyen.model.payments.AuthenticationResultResponse;
import com.adyen.model.payments.CancelOrRefundRequest;
import com.adyen.model.payments.CancelRequest;
import com.adyen.model.payments.CaptureRequest;
import com.adyen.model.payments.CommonField;
import com.adyen.model.payments.DonationRequest;
import com.adyen.model.payments.JSON;
import com.adyen.model.payments.ModificationResult;
import com.adyen.model.payments.PaymentRequest;
import com.adyen.model.payments.PaymentRequest3d;
import com.adyen.model.payments.PaymentRequest3ds2;
import com.adyen.model.payments.PaymentResult;
import com.adyen.model.payments.RefundRequest;
import com.adyen.model.payments.TechnicalCancelRequest;
import com.adyen.model.payments.ThreeDS2ResultRequest;
import com.adyen.model.payments.ThreeDS2ResultResponse;
import com.adyen.model.payments.VoidPendingRefundRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.PaymentResource;
import java.io.IOException;
import java.util.Optional;

public class Payment
extends Service {
    private final PaymentResource authorise = new PaymentResource(this, "/authorise");
    private final PaymentResource authorise3D = new PaymentResource(this, "/authorise3d");
    private final PaymentResource authorise3DS2 = new PaymentResource(this, "/authorise3ds2");
    private final PaymentResource retrieve3DS2Result = new PaymentResource(this, "/retrieve3ds2Result");
    private final PaymentResource getAuthenticationResult = new PaymentResource(this, "/getAuthenticationResult");
    private final PaymentResource capture = new PaymentResource(this, "/capture");
    private final PaymentResource cancel = new PaymentResource(this, "/cancel");
    private final PaymentResource refund = new PaymentResource(this, "/refund");
    private final PaymentResource cancelOrRefund = new PaymentResource(this, "/cancelOrRefund");
    private final PaymentResource technicalCancel = new PaymentResource(this, "/technicalCancel");
    private final PaymentResource adjustAuthorisation = new PaymentResource(this, "/adjustAuthorisation");
    private final PaymentResource donate = new PaymentResource(this, "/donate");
    private final PaymentResource voidPendingRefund = new PaymentResource(this, "/voidPendingRefund");

    public Payment(Client client) {
        super(client);
        new JSON();
    }

    public PaymentResult authorise(PaymentRequest paymentRequest) throws ApiException, IOException {
        return this.authorise(paymentRequest, null);
    }

    public PaymentResult authorise(PaymentRequest paymentRequest, RequestOptions requestOptions) throws ApiException, IOException {
        paymentRequest.setApplicationInfo(this.addLibrary(paymentRequest.getApplicationInfo()));
        String jsonRequest = paymentRequest.toJson();
        String jsonResult = this.authorise.request(jsonRequest, requestOptions);
        return PaymentResult.fromJson(jsonResult);
    }

    public PaymentResult authorise3D(PaymentRequest3d paymentRequest3d) throws Exception {
        paymentRequest3d.setApplicationInfo(this.addLibrary(paymentRequest3d.getApplicationInfo()));
        String jsonRequest = paymentRequest3d.toJson();
        String jsonResult = this.authorise3D.request(jsonRequest);
        return PaymentResult.fromJson(jsonResult);
    }

    public PaymentResult authorise3DS2(PaymentRequest3ds2 paymentRequest3ds2) throws Exception {
        paymentRequest3ds2.setApplicationInfo(this.addLibrary(paymentRequest3ds2.getApplicationInfo()));
        String jsonRequest = paymentRequest3ds2.toJson();
        String jsonResult = this.authorise3DS2.request(jsonRequest);
        return PaymentResult.fromJson(jsonResult);
    }

    @Deprecated
    public ThreeDS2ResultResponse retrieve3ds2Result(ThreeDS2ResultRequest threeDS2ResultRequest) throws Exception {
        String jsonRequest = threeDS2ResultRequest.toJson();
        String jsonResult = this.retrieve3DS2Result.request(jsonRequest);
        return ThreeDS2ResultResponse.fromJson(jsonResult);
    }

    public AuthenticationResultResponse getAuthenticationResult(AuthenticationResultRequest authenticationResultRequest) throws IOException, ApiException {
        String jsonRequest = authenticationResultRequest.toJson();
        String jsonResult = this.getAuthenticationResult.request(jsonRequest);
        return AuthenticationResultResponse.fromJson(jsonResult);
    }

    private ApplicationInfo addLibrary(ApplicationInfo applicationInfo) {
        return Optional.ofNullable(applicationInfo).orElse(new ApplicationInfo()).adyenLibrary(new CommonField().name("adyen-java-api-library").version("19.0.0"));
    }

    public ModificationResult capture(CaptureRequest captureRequest) throws IOException, ApiException {
        String jsonRequest = captureRequest.toJson();
        String jsonResult = this.capture.request(jsonRequest);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult cancel(CancelRequest cancelRequest) throws IOException, ApiException {
        String jsonRequest = cancelRequest.toJson();
        String jsonResult = this.cancel.request(jsonRequest);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult refund(RefundRequest refundRequest) throws IOException, ApiException {
        String jsonRequest = refundRequest.toJson();
        String jsonResult = this.refund.request(jsonRequest);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult cancelOrRefund(CancelOrRefundRequest cancelOrRefundRequest) throws IOException, ApiException {
        String jsonRequest = cancelOrRefundRequest.toJson();
        String jsonResult = this.cancelOrRefund.request(jsonRequest);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult technicalCancel(TechnicalCancelRequest technicalCancelRequest) throws IOException, ApiException {
        String jsonRequest = technicalCancelRequest.toJson();
        String jsonResult = this.technicalCancel.request(jsonRequest);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult adjustAuthorisation(AdjustAuthorisationRequest adjustAuthorisationRequest) throws IOException, ApiException {
        String jsonRequest = adjustAuthorisationRequest.toJson();
        String jsonResult = this.adjustAuthorisation.request(jsonRequest);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult donate(DonationRequest donationRequest) throws IOException, ApiException {
        String jsonRequest = donationRequest.toJson();
        String jsonResult = this.donate.request(jsonRequest);
        return ModificationResult.fromJson(jsonResult);
    }

    public ModificationResult voidPendingRefund(VoidPendingRefundRequest voidPendingRefundRequest) throws IOException, ApiException {
        String jsonRequest = voidPendingRefundRequest.toJson();
        String jsonResult = this.voidPendingRefund.request(jsonRequest);
        return ModificationResult.fromJson(jsonResult);
    }
}

