/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.notification;

import com.adyen.deserializer.MarketPayNotificationMessageDeserializer;
import com.adyen.model.marketpay.notification.GenericNotification;
import com.adyen.model.notification.NotificationRequest;
import com.adyen.model.terminal.TerminalAPIRequest;
import com.adyen.terminal.serialization.TerminalAPIGsonBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

public class NotificationHandler {
    private static final Gson GSON = new Gson();
    private final Gson marketPayGson;
    private final Gson terminalGson;

    public NotificationHandler() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(GenericNotification.class, (Object)new MarketPayNotificationMessageDeserializer());
        this.marketPayGson = gsonBuilder.create();
        this.terminalGson = TerminalAPIGsonBuilder.create();
    }

    public NotificationRequest handleNotificationJson(String json) {
        return (NotificationRequest)GSON.fromJson(json, new TypeToken<NotificationRequest>(){}.getType());
    }

    public GenericNotification handleMarketpayNotificationJson(String json) {
        return (GenericNotification)this.marketPayGson.fromJson(json, GenericNotification.class);
    }

    public TerminalAPIRequest handleTerminalNotificationJson(String json) {
        return (TerminalAPIRequest)this.terminalGson.fromJson(json, new TypeToken<TerminalAPIRequest>(){}.getType());
    }
}

