/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.OrderItem;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TerminalOrderRequest {
    public static final String SERIALIZED_NAME_BILLING_ENTITY_ID = "billingEntityId";
    @SerializedName(value="billingEntityId")
    private String billingEntityId;
    public static final String SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE = "customerOrderReference";
    @SerializedName(value="customerOrderReference")
    private String customerOrderReference;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<OrderItem> items = null;
    public static final String SERIALIZED_NAME_SHIPPING_LOCATION_ID = "shippingLocationId";
    @SerializedName(value="shippingLocationId")
    private String shippingLocationId;
    public static final String SERIALIZED_NAME_TAX_ID = "taxId";
    @SerializedName(value="taxId")
    private String taxId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TerminalOrderRequest billingEntityId(String billingEntityId) {
        this.billingEntityId = billingEntityId;
        return this;
    }

    @ApiModelProperty(value="The identification of the billing entity to use for the order.")
    public String getBillingEntityId() {
        return this.billingEntityId;
    }

    public void setBillingEntityId(String billingEntityId) {
        this.billingEntityId = billingEntityId;
    }

    public TerminalOrderRequest customerOrderReference(String customerOrderReference) {
        this.customerOrderReference = customerOrderReference;
        return this;
    }

    @ApiModelProperty(value="The merchant-defined purchase order reference.")
    public String getCustomerOrderReference() {
        return this.customerOrderReference;
    }

    public void setCustomerOrderReference(String customerOrderReference) {
        this.customerOrderReference = customerOrderReference;
    }

    public TerminalOrderRequest items(List<OrderItem> items) {
        this.items = items;
        return this;
    }

    public TerminalOrderRequest addItemsItem(OrderItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<OrderItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="The products included in the order.")
    public List<OrderItem> getItems() {
        return this.items;
    }

    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    public TerminalOrderRequest shippingLocationId(String shippingLocationId) {
        this.shippingLocationId = shippingLocationId;
        return this;
    }

    @ApiModelProperty(value="The identification of the shipping location to use for the order.")
    public String getShippingLocationId() {
        return this.shippingLocationId;
    }

    public void setShippingLocationId(String shippingLocationId) {
        this.shippingLocationId = shippingLocationId;
    }

    public TerminalOrderRequest taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @ApiModelProperty(value="The tax number of the billing entity.")
    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalOrderRequest terminalOrderRequest = (TerminalOrderRequest)o;
        return Objects.equals(this.billingEntityId, terminalOrderRequest.billingEntityId) && Objects.equals(this.customerOrderReference, terminalOrderRequest.customerOrderReference) && Objects.equals(this.items, terminalOrderRequest.items) && Objects.equals(this.shippingLocationId, terminalOrderRequest.shippingLocationId) && Objects.equals(this.taxId, terminalOrderRequest.taxId);
    }

    public int hashCode() {
        return Objects.hash(this.billingEntityId, this.customerOrderReference, this.items, this.shippingLocationId, this.taxId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TerminalOrderRequest {\n");
        sb.append("    billingEntityId: ").append(this.toIndentedString(this.billingEntityId)).append("\n");
        sb.append("    customerOrderReference: ").append(this.toIndentedString(this.customerOrderReference)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    shippingLocationId: ").append(this.toIndentedString(this.shippingLocationId)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TerminalOrderRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TerminalOrderRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BILLING_ENTITY_ID) != null && !jsonObj.get(SERIALIZED_NAME_BILLING_ENTITY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `billingEntityId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BILLING_ENTITY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `customerOrderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE).toString()));
        }
        JsonArray jsonArrayitems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ITEMS);
        if (jsonArrayitems != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArrayitems.size(); ++i) {
                OrderItem.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SHIPPING_LOCATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_SHIPPING_LOCATION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shippingLocationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHIPPING_LOCATION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAX_ID) != null && !jsonObj.get(SERIALIZED_NAME_TAX_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `taxId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAX_ID).toString()));
        }
    }

    public static TerminalOrderRequest fromJson(String jsonString) throws IOException {
        return (TerminalOrderRequest)JSON.getGson().fromJson(jsonString, TerminalOrderRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BILLING_ENTITY_ID);
        openapiFields.add(SERIALIZED_NAME_CUSTOMER_ORDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_ITEMS);
        openapiFields.add(SERIALIZED_NAME_SHIPPING_LOCATION_ID);
        openapiFields.add(SERIALIZED_NAME_TAX_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TerminalOrderRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TerminalOrderRequest.class));
            return new TypeAdapter<TerminalOrderRequest>(){

                public void write(JsonWriter out, TerminalOrderRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TerminalOrderRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TerminalOrderRequest.validateJsonObject(jsonObj);
                    return (TerminalOrderRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

