/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.ScheduleTerminalActionsRequestActionDetails;
import com.adyen.model.management.TerminalActionScheduleDetail;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ScheduleTerminalActionsResponse {
    public static final String SERIALIZED_NAME_ACTION_DETAILS = "actionDetails";
    @SerializedName(value="actionDetails")
    private ScheduleTerminalActionsRequestActionDetails actionDetails;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<TerminalActionScheduleDetail> items = null;
    public static final String SERIALIZED_NAME_SCHEDULED_AT = "scheduledAt";
    @SerializedName(value="scheduledAt")
    private String scheduledAt;
    public static final String SERIALIZED_NAME_STORE_ID = "storeId";
    @SerializedName(value="storeId")
    private String storeId;
    public static final String SERIALIZED_NAME_TERMINAL_IDS = "terminalIds";
    @SerializedName(value="terminalIds")
    private List<String> terminalIds = null;
    public static final String SERIALIZED_NAME_TERMINALS_WITH_ERRORS = "terminalsWithErrors";
    @SerializedName(value="terminalsWithErrors")
    private Map<String, List<String>> terminalsWithErrors = null;
    public static final String SERIALIZED_NAME_TOTAL_ERRORS = "totalErrors";
    @SerializedName(value="totalErrors")
    private Integer totalErrors;
    public static final String SERIALIZED_NAME_TOTAL_SCHEDULED = "totalScheduled";
    @SerializedName(value="totalScheduled")
    private Integer totalScheduled;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ScheduleTerminalActionsResponse actionDetails(ScheduleTerminalActionsRequestActionDetails actionDetails) {
        this.actionDetails = actionDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public ScheduleTerminalActionsRequestActionDetails getActionDetails() {
        return this.actionDetails;
    }

    public void setActionDetails(ScheduleTerminalActionsRequestActionDetails actionDetails) {
        this.actionDetails = actionDetails;
    }

    public ScheduleTerminalActionsResponse items(List<TerminalActionScheduleDetail> items) {
        this.items = items;
        return this;
    }

    public ScheduleTerminalActionsResponse addItemsItem(TerminalActionScheduleDetail itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<TerminalActionScheduleDetail>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="A list containing a terminal ID and an action ID for each terminal that the action was scheduled for.")
    public List<TerminalActionScheduleDetail> getItems() {
        return this.items;
    }

    public void setItems(List<TerminalActionScheduleDetail> items) {
        this.items = items;
    }

    public ScheduleTerminalActionsResponse scheduledAt(String scheduledAt) {
        this.scheduledAt = scheduledAt;
        return this;
    }

    @ApiModelProperty(value="The date and time when the action should happen.  Format: [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339), but without the **Z** before the time offset. For example, **2021-11-15T12:16:21+01:00**  The action is sent with the first [maintenance call](https://docs.adyen.com/point-of-sale/automating-terminal-management/terminal-actions-api#when-actions-take-effect) after the specified date and time in the time zone of the terminal.  An empty value causes the action to be sent as soon as possible: at the next maintenance call.")
    public String getScheduledAt() {
        return this.scheduledAt;
    }

    public void setScheduledAt(String scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public ScheduleTerminalActionsResponse storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the [store](https://docs.adyen.com/api-explorer/#/ManagementService/latest/get/stores). If present, all terminals in the `terminalIds` list must be assigned to this store.")
    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public ScheduleTerminalActionsResponse terminalIds(List<String> terminalIds) {
        this.terminalIds = terminalIds;
        return this;
    }

    public ScheduleTerminalActionsResponse addTerminalIdsItem(String terminalIdsItem) {
        if (this.terminalIds == null) {
            this.terminalIds = new ArrayList<String>();
        }
        this.terminalIds.add(terminalIdsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="A list of unique IDs of the terminals that the action applies to.")
    public List<String> getTerminalIds() {
        return this.terminalIds;
    }

    public void setTerminalIds(List<String> terminalIds) {
        this.terminalIds = terminalIds;
    }

    public ScheduleTerminalActionsResponse terminalsWithErrors(Map<String, List<String>> terminalsWithErrors) {
        this.terminalsWithErrors = terminalsWithErrors;
        return this;
    }

    public ScheduleTerminalActionsResponse putTerminalsWithErrorsItem(String key, List<String> terminalsWithErrorsItem) {
        if (this.terminalsWithErrors == null) {
            this.terminalsWithErrors = new HashMap<String, List<String>>();
        }
        this.terminalsWithErrors.put(key, terminalsWithErrorsItem);
        return this;
    }

    @ApiModelProperty(value="The validation errors that occurred in the list of terminals, and for each error the IDs of the terminals that the error applies to.")
    public Map<String, List<String>> getTerminalsWithErrors() {
        return this.terminalsWithErrors;
    }

    public void setTerminalsWithErrors(Map<String, List<String>> terminalsWithErrors) {
        this.terminalsWithErrors = terminalsWithErrors;
    }

    public ScheduleTerminalActionsResponse totalErrors(Integer totalErrors) {
        this.totalErrors = totalErrors;
        return this;
    }

    @ApiModelProperty(value="The number of terminals for which scheduling the action failed.")
    public Integer getTotalErrors() {
        return this.totalErrors;
    }

    public void setTotalErrors(Integer totalErrors) {
        this.totalErrors = totalErrors;
    }

    public ScheduleTerminalActionsResponse totalScheduled(Integer totalScheduled) {
        this.totalScheduled = totalScheduled;
        return this;
    }

    @ApiModelProperty(value="The number of terminals for which the action was successfully scheduled. This doesn't mean the action has happened yet.")
    public Integer getTotalScheduled() {
        return this.totalScheduled;
    }

    public void setTotalScheduled(Integer totalScheduled) {
        this.totalScheduled = totalScheduled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleTerminalActionsResponse scheduleTerminalActionsResponse = (ScheduleTerminalActionsResponse)o;
        return Objects.equals(this.actionDetails, scheduleTerminalActionsResponse.actionDetails) && Objects.equals(this.items, scheduleTerminalActionsResponse.items) && Objects.equals(this.scheduledAt, scheduleTerminalActionsResponse.scheduledAt) && Objects.equals(this.storeId, scheduleTerminalActionsResponse.storeId) && Objects.equals(this.terminalIds, scheduleTerminalActionsResponse.terminalIds) && Objects.equals(this.terminalsWithErrors, scheduleTerminalActionsResponse.terminalsWithErrors) && Objects.equals(this.totalErrors, scheduleTerminalActionsResponse.totalErrors) && Objects.equals(this.totalScheduled, scheduleTerminalActionsResponse.totalScheduled);
    }

    public int hashCode() {
        return Objects.hash(this.actionDetails, this.items, this.scheduledAt, this.storeId, this.terminalIds, this.terminalsWithErrors, this.totalErrors, this.totalScheduled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleTerminalActionsResponse {\n");
        sb.append("    actionDetails: ").append(this.toIndentedString(this.actionDetails)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    scheduledAt: ").append(this.toIndentedString(this.scheduledAt)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    terminalIds: ").append(this.toIndentedString(this.terminalIds)).append("\n");
        sb.append("    terminalsWithErrors: ").append(this.toIndentedString(this.terminalsWithErrors)).append("\n");
        sb.append("    totalErrors: ").append(this.toIndentedString(this.totalErrors)).append("\n");
        sb.append("    totalScheduled: ").append(this.toIndentedString(this.totalScheduled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayitems;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ScheduleTerminalActionsResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ScheduleTerminalActionsResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACTION_DETAILS) != null) {
            ScheduleTerminalActionsRequestActionDetails.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACTION_DETAILS));
        }
        if ((jsonArrayitems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ITEMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArrayitems.size(); ++i) {
                TerminalActionScheduleDetail.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SCHEDULED_AT) != null && !jsonObj.get(SERIALIZED_NAME_SCHEDULED_AT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scheduledAt` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCHEDULED_AT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE_ID) != null && !jsonObj.get(SERIALIZED_NAME_STORE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `storeId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMINAL_IDS) != null && !jsonObj.get(SERIALIZED_NAME_TERMINAL_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `terminalIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TERMINAL_IDS).toString()));
        }
    }

    public static ScheduleTerminalActionsResponse fromJson(String jsonString) throws IOException {
        return (ScheduleTerminalActionsResponse)JSON.getGson().fromJson(jsonString, ScheduleTerminalActionsResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTION_DETAILS);
        openapiFields.add(SERIALIZED_NAME_ITEMS);
        openapiFields.add(SERIALIZED_NAME_SCHEDULED_AT);
        openapiFields.add(SERIALIZED_NAME_STORE_ID);
        openapiFields.add(SERIALIZED_NAME_TERMINAL_IDS);
        openapiFields.add(SERIALIZED_NAME_TERMINALS_WITH_ERRORS);
        openapiFields.add(SERIALIZED_NAME_TOTAL_ERRORS);
        openapiFields.add(SERIALIZED_NAME_TOTAL_SCHEDULED);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ScheduleTerminalActionsResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ScheduleTerminalActionsResponse.class));
            return new TypeAdapter<ScheduleTerminalActionsResponse>(){

                public void write(JsonWriter out, ScheduleTerminalActionsResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ScheduleTerminalActionsResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ScheduleTerminalActionsResponse.validateJsonObject(jsonObj);
                    return (ScheduleTerminalActionsResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

