/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CreateMerchantRequest {
    public static final String SERIALIZED_NAME_BUSINESS_LINE_ID = "businessLineId";
    @SerializedName(value="businessLineId")
    private String businessLineId;
    public static final String SERIALIZED_NAME_COMPANY_ID = "companyId";
    @SerializedName(value="companyId")
    private String companyId;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_LEGAL_ENTITY_ID = "legalEntityId";
    @SerializedName(value="legalEntityId")
    private String legalEntityId;
    public static final String SERIALIZED_NAME_PRICING_PLAN = "pricingPlan";
    @SerializedName(value="pricingPlan")
    private String pricingPlan;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SALES_CHANNELS = "salesChannels";
    @SerializedName(value="salesChannels")
    private List<String> salesChannels = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateMerchantRequest businessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [business line](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/businessLines). Required for an Adyen for Platforms Manage integration.")
    public String getBusinessLineId() {
        return this.businessLineId;
    }

    public void setBusinessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
    }

    public CreateMerchantRequest companyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the company account.")
    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public CreateMerchantRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the merchant account, maximum 300 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateMerchantRequest legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [legal entity](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities). Required for an Adyen for Platforms Manage integration.")
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public CreateMerchantRequest pricingPlan(String pricingPlan) {
        this.pricingPlan = pricingPlan;
        return this;
    }

    @ApiModelProperty(value="Sets the pricing plan for the merchant account. Required for an Adyen for Platforms Manage integration. Your Adyen contact will provide the values that you can use.")
    public String getPricingPlan() {
        return this.pricingPlan;
    }

    public void setPricingPlan(String pricingPlan) {
        this.pricingPlan = pricingPlan;
    }

    public CreateMerchantRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the merchant account. To make this reference the unique identifier of the merchant account, your Adyen contact can set up a template on your company account. The template can have 6 to 255 characters with upper- and lower-case letters, underscores, and numbers. When your company account has a template, then the `reference` is required and must be unique within the company account.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public CreateMerchantRequest salesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
        return this;
    }

    public CreateMerchantRequest addSalesChannelsItem(String salesChannelsItem) {
        if (this.salesChannels == null) {
            this.salesChannels = new ArrayList<String>();
        }
        this.salesChannels.add(salesChannelsItem);
        return this;
    }

    @ApiModelProperty(value="List of sales channels that the merchant will process payments with")
    public List<String> getSalesChannels() {
        return this.salesChannels;
    }

    public void setSalesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMerchantRequest createMerchantRequest = (CreateMerchantRequest)o;
        return Objects.equals(this.businessLineId, createMerchantRequest.businessLineId) && Objects.equals(this.companyId, createMerchantRequest.companyId) && Objects.equals(this.description, createMerchantRequest.description) && Objects.equals(this.legalEntityId, createMerchantRequest.legalEntityId) && Objects.equals(this.pricingPlan, createMerchantRequest.pricingPlan) && Objects.equals(this.reference, createMerchantRequest.reference) && Objects.equals(this.salesChannels, createMerchantRequest.salesChannels);
    }

    public int hashCode() {
        return Objects.hash(this.businessLineId, this.companyId, this.description, this.legalEntityId, this.pricingPlan, this.reference, this.salesChannels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMerchantRequest {\n");
        sb.append("    businessLineId: ").append(this.toIndentedString(this.businessLineId)).append("\n");
        sb.append("    companyId: ").append(this.toIndentedString(this.companyId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    pricingPlan: ").append(this.toIndentedString(this.pricingPlan)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    salesChannels: ").append(this.toIndentedString(this.salesChannels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateMerchantRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateMerchantRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_ID) != null && !jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `businessLineId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPANY_ID) != null && !jsonObj.get(SERIALIZED_NAME_COMPANY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `companyId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPANY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID) != null && !jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `legalEntityId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRICING_PLAN) != null && !jsonObj.get(SERIALIZED_NAME_PRICING_PLAN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pricingPlan` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRICING_PLAN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SALES_CHANNELS) != null && !jsonObj.get(SERIALIZED_NAME_SALES_CHANNELS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `salesChannels` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SALES_CHANNELS).toString()));
        }
    }

    public static CreateMerchantRequest fromJson(String jsonString) throws IOException {
        return (CreateMerchantRequest)JSON.getGson().fromJson(jsonString, CreateMerchantRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BUSINESS_LINE_ID);
        openapiFields.add(SERIALIZED_NAME_COMPANY_ID);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_LEGAL_ENTITY_ID);
        openapiFields.add(SERIALIZED_NAME_PRICING_PLAN);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SALES_CHANNELS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COMPANY_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateMerchantRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateMerchantRequest.class));
            return new TypeAdapter<CreateMerchantRequest>(){

                public void write(JsonWriter out, CreateMerchantRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateMerchantRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateMerchantRequest.validateJsonObject(jsonObj);
                    return (CreateMerchantRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

