/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.BillingEntity;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BillingEntitiesResponse {
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private List<BillingEntity> data = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BillingEntitiesResponse data(List<BillingEntity> data) {
        this.data = data;
        return this;
    }

    public BillingEntitiesResponse addDataItem(BillingEntity dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<BillingEntity>();
        }
        this.data.add(dataItem);
        return this;
    }

    @ApiModelProperty(value="List of legal entities that can be used for the billing of orders.")
    public List<BillingEntity> getData() {
        return this.data;
    }

    public void setData(List<BillingEntity> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingEntitiesResponse billingEntitiesResponse = (BillingEntitiesResponse)o;
        return Objects.equals(this.data, billingEntitiesResponse.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingEntitiesResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BillingEntitiesResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BillingEntitiesResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        JsonArray jsonArraydata = jsonObj.getAsJsonArray(SERIALIZED_NAME_DATA);
        if (jsonArraydata != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DATA).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `data` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA).toString()));
            }
            for (int i = 0; i < jsonArraydata.size(); ++i) {
                BillingEntity.validateJsonObject(jsonArraydata.get(i).getAsJsonObject());
            }
        }
    }

    public static BillingEntitiesResponse fromJson(String jsonString) throws IOException {
        return (BillingEntitiesResponse)JSON.getGson().fromJson(jsonString, BillingEntitiesResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BillingEntitiesResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BillingEntitiesResponse.class));
            return new TypeAdapter<BillingEntitiesResponse>(){

                public void write(JsonWriter out, BillingEntitiesResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BillingEntitiesResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BillingEntitiesResponse.validateJsonObject(jsonObj);
                    return (BillingEntitiesResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

