/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentMethod;
import com.adyen.model.checkout.StoredPaymentMethod;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PaymentMethodsResponse {
    public static final String SERIALIZED_NAME_PAYMENT_METHODS = "paymentMethods";
    @SerializedName(value="paymentMethods")
    private List<PaymentMethod> paymentMethods = null;
    public static final String SERIALIZED_NAME_STORED_PAYMENT_METHODS = "storedPaymentMethods";
    @SerializedName(value="storedPaymentMethods")
    private List<StoredPaymentMethod> storedPaymentMethods = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaymentMethodsResponse paymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
        return this;
    }

    public PaymentMethodsResponse addPaymentMethodsItem(PaymentMethod paymentMethodsItem) {
        if (this.paymentMethods == null) {
            this.paymentMethods = new ArrayList<PaymentMethod>();
        }
        this.paymentMethods.add(paymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="Detailed list of payment methods required to generate payment forms.")
    public List<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    public void setPaymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }

    public PaymentMethodsResponse storedPaymentMethods(List<StoredPaymentMethod> storedPaymentMethods) {
        this.storedPaymentMethods = storedPaymentMethods;
        return this;
    }

    public PaymentMethodsResponse addStoredPaymentMethodsItem(StoredPaymentMethod storedPaymentMethodsItem) {
        if (this.storedPaymentMethods == null) {
            this.storedPaymentMethods = new ArrayList<StoredPaymentMethod>();
        }
        this.storedPaymentMethods.add(storedPaymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="List of all stored payment methods.")
    public List<StoredPaymentMethod> getStoredPaymentMethods() {
        return this.storedPaymentMethods;
    }

    public void setStoredPaymentMethods(List<StoredPaymentMethod> storedPaymentMethods) {
        this.storedPaymentMethods = storedPaymentMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodsResponse paymentMethodsResponse = (PaymentMethodsResponse)o;
        return Objects.equals(this.paymentMethods, paymentMethodsResponse.paymentMethods) && Objects.equals(this.storedPaymentMethods, paymentMethodsResponse.storedPaymentMethods);
    }

    public int hashCode() {
        return Objects.hash(this.paymentMethods, this.storedPaymentMethods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodsResponse {\n");
        sb.append("    paymentMethods: ").append(this.toIndentedString(this.paymentMethods)).append("\n");
        sb.append("    storedPaymentMethods: ").append(this.toIndentedString(this.storedPaymentMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraystoredPaymentMethods;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentMethodsResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PaymentMethodsResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        JsonArray jsonArraypaymentMethods = jsonObj.getAsJsonArray(SERIALIZED_NAME_PAYMENT_METHODS);
        if (jsonArraypaymentMethods != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PAYMENT_METHODS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `paymentMethods` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_METHODS).toString()));
            }
            for (int i = 0; i < jsonArraypaymentMethods.size(); ++i) {
                PaymentMethod.validateJsonObject(jsonArraypaymentMethods.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraystoredPaymentMethods = jsonObj.getAsJsonArray(SERIALIZED_NAME_STORED_PAYMENT_METHODS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHODS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `storedPaymentMethods` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHODS).toString()));
            }
            for (int i = 0; i < jsonArraystoredPaymentMethods.size(); ++i) {
                StoredPaymentMethod.validateJsonObject(jsonArraystoredPaymentMethods.get(i).getAsJsonObject());
            }
        }
    }

    public static PaymentMethodsResponse fromJson(String jsonString) throws IOException {
        return (PaymentMethodsResponse)JSON.getGson().fromJson(jsonString, PaymentMethodsResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PAYMENT_METHODS);
        openapiFields.add(SERIALIZED_NAME_STORED_PAYMENT_METHODS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentMethodsResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentMethodsResponse.class));
            return new TypeAdapter<PaymentMethodsResponse>(){

                public void write(JsonWriter out, PaymentMethodsResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentMethodsResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentMethodsResponse.validateJsonObject(jsonObj);
                    return (PaymentMethodsResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

