/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InstallmentOption {
    public static final String SERIALIZED_NAME_MAX_VALUE = "maxValue";
    @SerializedName(value="maxValue")
    private Integer maxValue;
    public static final String SERIALIZED_NAME_PLANS = "plans";
    @SerializedName(value="plans")
    private List<PlansEnum> plans = null;
    public static final String SERIALIZED_NAME_PRESELECTED_VALUE = "preselectedValue";
    @SerializedName(value="preselectedValue")
    private Integer preselectedValue;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    private List<Integer> values = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InstallmentOption maxValue(Integer maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    @ApiModelProperty(value="The maximum number of installments offered for this payment method.")
    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public InstallmentOption plans(List<PlansEnum> plans) {
        this.plans = plans;
        return this;
    }

    public InstallmentOption addPlansItem(PlansEnum plansItem) {
        if (this.plans == null) {
            this.plans = new ArrayList<PlansEnum>();
        }
        this.plans.add(plansItem);
        return this;
    }

    @ApiModelProperty(value="Defines the type of installment plan. If not set, defaults to **regular**.  Possible values: * **regular** * **revolving**")
    public List<PlansEnum> getPlans() {
        return this.plans;
    }

    public void setPlans(List<PlansEnum> plans) {
        this.plans = plans;
    }

    public InstallmentOption preselectedValue(Integer preselectedValue) {
        this.preselectedValue = preselectedValue;
        return this;
    }

    @ApiModelProperty(value="Preselected number of installments offered for this payment method.")
    public Integer getPreselectedValue() {
        return this.preselectedValue;
    }

    public void setPreselectedValue(Integer preselectedValue) {
        this.preselectedValue = preselectedValue;
    }

    public InstallmentOption values(List<Integer> values) {
        this.values = values;
        return this;
    }

    public InstallmentOption addValuesItem(Integer valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @ApiModelProperty(value="An array of the number of installments that the shopper can choose from. For example, **[2,3,5]**. This cannot be specified simultaneously with `maxValue`.")
    public List<Integer> getValues() {
        return this.values;
    }

    public void setValues(List<Integer> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallmentOption installmentOption = (InstallmentOption)o;
        return Objects.equals(this.maxValue, installmentOption.maxValue) && Objects.equals(this.plans, installmentOption.plans) && Objects.equals(this.preselectedValue, installmentOption.preselectedValue) && Objects.equals(this.values, installmentOption.values);
    }

    public int hashCode() {
        return Objects.hash(this.maxValue, this.plans, this.preselectedValue, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstallmentOption {\n");
        sb.append("    maxValue: ").append(this.toIndentedString(this.maxValue)).append("\n");
        sb.append("    plans: ").append(this.toIndentedString(this.plans)).append("\n");
        sb.append("    preselectedValue: ").append(this.toIndentedString(this.preselectedValue)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InstallmentOption is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InstallmentOption` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PLANS) != null && !jsonObj.get(SERIALIZED_NAME_PLANS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `plans` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PLANS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUES) != null && !jsonObj.get(SERIALIZED_NAME_VALUES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `values` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUES).toString()));
        }
    }

    public static InstallmentOption fromJson(String jsonString) throws IOException {
        return (InstallmentOption)JSON.getGson().fromJson(jsonString, InstallmentOption.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MAX_VALUE);
        openapiFields.add(SERIALIZED_NAME_PLANS);
        openapiFields.add(SERIALIZED_NAME_PRESELECTED_VALUE);
        openapiFields.add(SERIALIZED_NAME_VALUES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InstallmentOption.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InstallmentOption.class));
            return new TypeAdapter<InstallmentOption>(){

                public void write(JsonWriter out, InstallmentOption value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InstallmentOption read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InstallmentOption.validateJsonObject(jsonObj);
                    return (InstallmentOption)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PlansEnum {
        REGULAR("regular"),
        REVOLVING("revolving");

        private String value;

        private PlansEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PlansEnum fromValue(String value) {
            for (PlansEnum b : PlansEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PlansEnum> {
            public void write(JsonWriter jsonWriter, PlansEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PlansEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PlansEnum.fromValue(value);
            }
        }
    }
}

