/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Avs {
    public static final String SERIALIZED_NAME_ADDRESS_EDITABLE = "addressEditable";
    @SerializedName(value="addressEditable")
    private Boolean addressEditable;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private EnabledEnum enabled;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Avs addressEditable(Boolean addressEditable) {
        this.addressEditable = addressEditable;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the shopper is allowed to modify the billing address for the current payment request.")
    public Boolean getAddressEditable() {
        return this.addressEditable;
    }

    public void setAddressEditable(Boolean addressEditable) {
        this.addressEditable = addressEditable;
    }

    public Avs enabled(EnabledEnum enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the shopper should enter their billing address during checkout.  Allowed values: * yes \u2014 Perform AVS checks for every card payment. * automatic \u2014 Perform AVS checks only when required to optimize the conversion rate. * no \u2014 Do not perform AVS checks.")
    public EnabledEnum getEnabled() {
        return this.enabled;
    }

    public void setEnabled(EnabledEnum enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Avs avs = (Avs)o;
        return Objects.equals(this.addressEditable, avs.addressEditable) && Objects.equals((Object)this.enabled, (Object)avs.enabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressEditable, this.enabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Avs {\n");
        sb.append("    addressEditable: ").append(this.toIndentedString(this.addressEditable)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString((Object)this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Avs is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Avs` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENABLED) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ENABLED).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `enabled` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENABLED).toString()));
            }
            EnabledEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ENABLED).getAsString());
        }
    }

    public static Avs fromJson(String jsonString) throws IOException {
        return (Avs)JSON.getGson().fromJson(jsonString, Avs.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS_EDITABLE);
        openapiFields.add(SERIALIZED_NAME_ENABLED);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Avs.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Avs.class));
            return new TypeAdapter<Avs>(){

                public void write(JsonWriter out, Avs value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Avs read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Avs.validateJsonObject(jsonObj);
                    return (Avs)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EnabledEnum {
        YES("yes"),
        NO("no"),
        AUTOMATIC("automatic");

        private String value;

        private EnabledEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EnabledEnum fromValue(String value) {
            for (EnabledEnum b : EnabledEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EnabledEnum> {
            public void write(JsonWriter jsonWriter, EnabledEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EnabledEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EnabledEnum.fromValue(value);
            }
        }
    }
}

