/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Duration;
import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TransactionRuleInterval {
    public static final String SERIALIZED_NAME_DAY_OF_MONTH = "dayOfMonth";
    @SerializedName(value="dayOfMonth")
    private Integer dayOfMonth;
    public static final String SERIALIZED_NAME_DAY_OF_WEEK = "dayOfWeek";
    @SerializedName(value="dayOfWeek")
    private DayOfWeekEnum dayOfWeek;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private Duration duration;
    public static final String SERIALIZED_NAME_TIME_OF_DAY = "timeOfDay";
    @SerializedName(value="timeOfDay")
    private String timeOfDay;
    public static final String SERIALIZED_NAME_TIME_ZONE = "timeZone";
    @SerializedName(value="timeZone")
    private String timeZone;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TransactionRuleInterval dayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    @ApiModelProperty(value="The day of month, used when the `duration.unit` is **months**. If not provided, by default, this is set to **1**, the first day of the month.")
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public TransactionRuleInterval dayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    @ApiModelProperty(value="The day of week, used when the `duration.unit` is **weeks**. If not provided, by default, this is set to **monday**.  Possible values: **sunday**, **monday**, **tuesday**, **wednesday**, **thursday**, **friday**.")
    public DayOfWeekEnum getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public TransactionRuleInterval duration(Duration duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(value="")
    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public TransactionRuleInterval timeOfDay(String timeOfDay) {
        this.timeOfDay = timeOfDay;
        return this;
    }

    @ApiModelProperty(value="The time of day, in **hh:mm:ss** format, used when the `duration.unit` is **hours**. If not provided, by default, this is set to **00:00:00**.")
    public String getTimeOfDay() {
        return this.timeOfDay;
    }

    public void setTimeOfDay(String timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    public TransactionRuleInterval timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(value="The [time zone](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For example, **Europe/Amsterdam**. By default, this is set to **UTC**.")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public TransactionRuleInterval type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The [type of interval](https://docs.adyen.com/issuing/transaction-rules#time-intervals) during which the rule conditions and limits apply, and how often counters are reset.  Possible values:   * **perTransaction**: conditions are evaluated and the counters are reset for every transaction.  * **daily**: the counters are reset daily at 00:00:00 UTC.  * **weekly**: the counters are reset every Monday at 00:00:00 UTC.   * **monthly**: the counters reset every first day of the month at 00:00:00 UTC.   * **lifetime**: conditions are applied to the lifetime of the payment instrument.  * **rolling**: conditions are applied and the counters are reset based on a `duration`. If the reset date and time are not provided, Adyen applies the default reset time similar to fixed intervals. For example, if the duration is every two weeks, the counter resets every third Monday at 00:00:00 UTC.  * **sliding**: conditions are applied and the counters are reset based on the current time and a `duration` that you specify.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionRuleInterval transactionRuleInterval = (TransactionRuleInterval)o;
        return Objects.equals(this.dayOfMonth, transactionRuleInterval.dayOfMonth) && Objects.equals((Object)this.dayOfWeek, (Object)transactionRuleInterval.dayOfWeek) && Objects.equals(this.duration, transactionRuleInterval.duration) && Objects.equals(this.timeOfDay, transactionRuleInterval.timeOfDay) && Objects.equals(this.timeZone, transactionRuleInterval.timeZone) && Objects.equals((Object)this.type, (Object)transactionRuleInterval.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dayOfMonth, this.dayOfWeek, this.duration, this.timeOfDay, this.timeZone, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionRuleInterval {\n");
        sb.append("    dayOfMonth: ").append(this.toIndentedString(this.dayOfMonth)).append("\n");
        sb.append("    dayOfWeek: ").append(this.toIndentedString((Object)this.dayOfWeek)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    timeOfDay: ").append(this.toIndentedString(this.timeOfDay)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransactionRuleInterval is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransactionRuleInterval` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DAY_OF_WEEK) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DAY_OF_WEEK).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `dayOfWeek` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DAY_OF_WEEK).toString()));
            }
            DayOfWeekEnum.fromValue(jsonObj.get(SERIALIZED_NAME_DAY_OF_WEEK).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DURATION) != null) {
            Duration.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DURATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIME_OF_DAY) != null && !jsonObj.get(SERIALIZED_NAME_TIME_OF_DAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timeOfDay` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIME_OF_DAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIME_ZONE) != null && !jsonObj.get(SERIALIZED_NAME_TIME_ZONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timeZone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIME_ZONE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static TransactionRuleInterval fromJson(String jsonString) throws IOException {
        return (TransactionRuleInterval)JSON.getGson().fromJson(jsonString, TransactionRuleInterval.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DAY_OF_MONTH);
        openapiFields.add(SERIALIZED_NAME_DAY_OF_WEEK);
        openapiFields.add(SERIALIZED_NAME_DURATION);
        openapiFields.add(SERIALIZED_NAME_TIME_OF_DAY);
        openapiFields.add(SERIALIZED_NAME_TIME_ZONE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransactionRuleInterval.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransactionRuleInterval.class));
            return new TypeAdapter<TransactionRuleInterval>(){

                public void write(JsonWriter out, TransactionRuleInterval value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransactionRuleInterval read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransactionRuleInterval.validateJsonObject(jsonObj);
                    return (TransactionRuleInterval)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        DAILY("daily"),
        LIFETIME("lifetime"),
        MONTHLY("monthly"),
        PERTRANSACTION("perTransaction"),
        ROLLING("rolling"),
        SLIDING("sliding"),
        WEEKLY("weekly");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DayOfWeekEnum {
        FRIDAY("friday"),
        MONDAY("monday"),
        SATURDAY("saturday"),
        SUNDAY("sunday"),
        THURSDAY("thursday"),
        TUESDAY("tuesday"),
        WEDNESDAY("wednesday");

        private String value;

        private DayOfWeekEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DayOfWeekEnum fromValue(String value) {
            for (DayOfWeekEnum b : DayOfWeekEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DayOfWeekEnum> {
            public void write(JsonWriter jsonWriter, DayOfWeekEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DayOfWeekEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DayOfWeekEnum.fromValue(value);
            }
        }
    }
}

