/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Authentication;
import com.adyen.model.balanceplatform.CardConfiguration;
import com.adyen.model.balanceplatform.DeliveryContact;
import com.adyen.model.balanceplatform.Expiry;
import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Card {
    public static final String SERIALIZED_NAME_AUTHENTICATION = "authentication";
    @SerializedName(value="authentication")
    private Authentication authentication;
    public static final String SERIALIZED_NAME_BIN = "bin";
    @SerializedName(value="bin")
    private String bin;
    public static final String SERIALIZED_NAME_BRAND = "brand";
    @SerializedName(value="brand")
    private String brand;
    public static final String SERIALIZED_NAME_BRAND_VARIANT = "brandVariant";
    @SerializedName(value="brandVariant")
    private String brandVariant;
    public static final String SERIALIZED_NAME_CARDHOLDER_NAME = "cardholderName";
    @SerializedName(value="cardholderName")
    private String cardholderName;
    public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";
    @SerializedName(value="configuration")
    private CardConfiguration configuration;
    public static final String SERIALIZED_NAME_CVC = "cvc";
    @SerializedName(value="cvc")
    private String cvc;
    public static final String SERIALIZED_NAME_DELIVERY_CONTACT = "deliveryContact";
    @SerializedName(value="deliveryContact")
    private DeliveryContact deliveryContact;
    public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
    @SerializedName(value="expiration")
    private Expiry expiration;
    public static final String SERIALIZED_NAME_FORM_FACTOR = "formFactor";
    @SerializedName(value="formFactor")
    private FormFactorEnum formFactor;
    public static final String SERIALIZED_NAME_LAST_FOUR = "lastFour";
    @SerializedName(value="lastFour")
    private String lastFour;
    public static final String SERIALIZED_NAME_NUMBER = "number";
    @SerializedName(value="number")
    private String number;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Card() {
    }

    public Card(String number) {
        this();
        this.number = number;
    }

    public Card authentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    @ApiModelProperty(value="")
    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Card bin(String bin) {
        this.bin = bin;
        return this;
    }

    @ApiModelProperty(value="The bank identification number (BIN) of the card number.")
    public String getBin() {
        return this.bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public Card brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(required=true, value="The brand of the payment instrument. Possible values: **visa**, **mc**.")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Card brandVariant(String brandVariant) {
        this.brandVariant = brandVariant;
        return this;
    }

    @ApiModelProperty(required=true, value="The brand variant of the payment instrument. >Contact your Adyen Implementation Manager to get the values that are relevant to your integration. Examples: **visadebit**, **mcprepaid**.")
    public String getBrandVariant() {
        return this.brandVariant;
    }

    public void setBrandVariant(String brandVariant) {
        this.brandVariant = brandVariant;
    }

    public Card cardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the cardholder.  Maximum length: 26 characters.")
    public String getCardholderName() {
        return this.cardholderName;
    }

    public void setCardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
    }

    public Card configuration(CardConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    @ApiModelProperty(value="")
    public CardConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CardConfiguration configuration) {
        this.configuration = configuration;
    }

    public Card cvc(String cvc) {
        this.cvc = cvc;
        return this;
    }

    @ApiModelProperty(value="The CVC2 value of the card. > The CVC2 is not sent by default. This is only returned in the `POST` response for single-use virtual cards.")
    public String getCvc() {
        return this.cvc;
    }

    public void setCvc(String cvc) {
        this.cvc = cvc;
    }

    public Card deliveryContact(DeliveryContact deliveryContact) {
        this.deliveryContact = deliveryContact;
        return this;
    }

    @ApiModelProperty(value="")
    public DeliveryContact getDeliveryContact() {
        return this.deliveryContact;
    }

    public void setDeliveryContact(DeliveryContact deliveryContact) {
        this.deliveryContact = deliveryContact;
    }

    public Card expiration(Expiry expiration) {
        this.expiration = expiration;
        return this;
    }

    @ApiModelProperty(value="")
    public Expiry getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Expiry expiration) {
        this.expiration = expiration;
    }

    public Card formFactor(FormFactorEnum formFactor) {
        this.formFactor = formFactor;
        return this;
    }

    @ApiModelProperty(required=true, value="The form factor of the card. Possible values: **virtual**, **physical**.")
    public FormFactorEnum getFormFactor() {
        return this.formFactor;
    }

    public void setFormFactor(FormFactorEnum formFactor) {
        this.formFactor = formFactor;
    }

    public Card lastFour(String lastFour) {
        this.lastFour = lastFour;
        return this;
    }

    @ApiModelProperty(value="Last last four digits of the card number.")
    public String getLastFour() {
        return this.lastFour;
    }

    public void setLastFour(String lastFour) {
        this.lastFour = lastFour;
    }

    @ApiModelProperty(required=true, value="The primary account number (PAN) of the card. > The PAN is masked by default and returned only for single-use virtual cards.")
    public String getNumber() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        return Objects.equals(this.authentication, card.authentication) && Objects.equals(this.bin, card.bin) && Objects.equals(this.brand, card.brand) && Objects.equals(this.brandVariant, card.brandVariant) && Objects.equals(this.cardholderName, card.cardholderName) && Objects.equals(this.configuration, card.configuration) && Objects.equals(this.cvc, card.cvc) && Objects.equals(this.deliveryContact, card.deliveryContact) && Objects.equals(this.expiration, card.expiration) && Objects.equals((Object)this.formFactor, (Object)card.formFactor) && Objects.equals(this.lastFour, card.lastFour) && Objects.equals(this.number, card.number);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authentication, this.bin, this.brand, this.brandVariant, this.cardholderName, this.configuration, this.cvc, this.deliveryContact, this.expiration, this.formFactor, this.lastFour, this.number});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Card {\n");
        sb.append("    authentication: ").append(this.toIndentedString(this.authentication)).append("\n");
        sb.append("    bin: ").append(this.toIndentedString(this.bin)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    brandVariant: ").append(this.toIndentedString(this.brandVariant)).append("\n");
        sb.append("    cardholderName: ").append(this.toIndentedString(this.cardholderName)).append("\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    cvc: ").append(this.toIndentedString(this.cvc)).append("\n");
        sb.append("    deliveryContact: ").append(this.toIndentedString(this.deliveryContact)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    formFactor: ").append(this.toIndentedString((Object)this.formFactor)).append("\n");
        sb.append("    lastFour: ").append(this.toIndentedString(this.lastFour)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Card is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Card` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTHENTICATION) != null) {
            Authentication.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTHENTICATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_BIN) != null && !jsonObj.get(SERIALIZED_NAME_BIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BRAND) != null && !jsonObj.get(SERIALIZED_NAME_BRAND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `brand` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BRAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BRAND_VARIANT) != null && !jsonObj.get(SERIALIZED_NAME_BRAND_VARIANT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `brandVariant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BRAND_VARIANT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARDHOLDER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_CARDHOLDER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cardholderName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARDHOLDER_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CONFIGURATION) != null) {
            CardConfiguration.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CONFIGURATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_CVC) != null && !jsonObj.get(SERIALIZED_NAME_CVC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cvc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CVC).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DELIVERY_CONTACT) != null) {
            DeliveryContact.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DELIVERY_CONTACT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EXPIRATION) != null) {
            Expiry.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EXPIRATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORM_FACTOR) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FORM_FACTOR).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `formFactor` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORM_FACTOR).toString()));
            }
            FormFactorEnum.fromValue(jsonObj.get(SERIALIZED_NAME_FORM_FACTOR).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_FOUR) != null && !jsonObj.get(SERIALIZED_NAME_LAST_FOUR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `lastFour` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_FOUR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NUMBER).toString()));
        }
    }

    public static Card fromJson(String jsonString) throws IOException {
        return (Card)JSON.getGson().fromJson(jsonString, Card.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATION);
        openapiFields.add(SERIALIZED_NAME_BIN);
        openapiFields.add(SERIALIZED_NAME_BRAND);
        openapiFields.add(SERIALIZED_NAME_BRAND_VARIANT);
        openapiFields.add(SERIALIZED_NAME_CARDHOLDER_NAME);
        openapiFields.add(SERIALIZED_NAME_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_CVC);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_CONTACT);
        openapiFields.add(SERIALIZED_NAME_EXPIRATION);
        openapiFields.add(SERIALIZED_NAME_FORM_FACTOR);
        openapiFields.add(SERIALIZED_NAME_LAST_FOUR);
        openapiFields.add(SERIALIZED_NAME_NUMBER);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BRAND);
        openapiRequiredFields.add(SERIALIZED_NAME_BRAND_VARIANT);
        openapiRequiredFields.add(SERIALIZED_NAME_CARDHOLDER_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_FORM_FACTOR);
        openapiRequiredFields.add(SERIALIZED_NAME_NUMBER);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Card.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Card.class));
            return new TypeAdapter<Card>(){

                public void write(JsonWriter out, Card value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Card read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Card.validateJsonObject(jsonObj);
                    return (Card)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FormFactorEnum {
        PHYSICAL("physical"),
        UNKNOWN("unknown"),
        VIRTUAL("virtual");

        private String value;

        private FormFactorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FormFactorEnum fromValue(String value) {
            for (FormFactorEnum b : FormFactorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FormFactorEnum> {
            public void write(JsonWriter jsonWriter, FormFactorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FormFactorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FormFactorEnum.fromValue(value);
            }
        }
    }
}

