/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.JSON;
import com.adyen.model.management.ListStoresResponse;
import com.adyen.model.management.Store;
import com.adyen.model.management.StoreCreationRequest;
import com.adyen.model.management.StoreCreationWithMerchantCodeRequest;
import com.adyen.model.management.UpdateStoreRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AccountStoreLevel
extends ApiKeyAuthenticatedService {
    public AccountStoreLevel(Client client) {
        super(client);
        new JSON();
    }

    public ListStoresResponse listStores(String merchantId, Map<String, String> queryParams) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/stores");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListStoresResponse.fromJson(jsonResult);
    }

    public Store getStore(String merchantId, String storeId) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (storeId == null) {
            throw new ApiException("Missing the required parameter 'storeId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("storeId", storeId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/stores/{storeId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return Store.fromJson(jsonResult);
    }

    public ListStoresResponse listStores(Map<String, String> queryParams) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/stores");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListStoresResponse.fromJson(jsonResult);
    }

    public Store getStore(String storeId) throws ApiException, IOException {
        if (storeId == null) {
            throw new ApiException("Missing the required parameter 'storeId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("storeId", storeId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/stores/{storeId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return Store.fromJson(jsonResult);
    }

    public Store updateStore(String merchantId, String storeId, UpdateStoreRequest updateStoreRequest) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (storeId == null) {
            throw new ApiException("Missing the required parameter 'storeId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("storeId", storeId);
        String requestBody = updateStoreRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/stores/{storeId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return Store.fromJson(jsonResult);
    }

    public Store updateStore(String storeId, UpdateStoreRequest updateStoreRequest) throws ApiException, IOException {
        if (storeId == null) {
            throw new ApiException("Missing the required parameter 'storeId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("storeId", storeId);
        String requestBody = updateStoreRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/stores/{storeId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return Store.fromJson(jsonResult);
    }

    public Store createStore(String merchantId, StoreCreationRequest storeCreationRequest) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = storeCreationRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/stores");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return Store.fromJson(jsonResult);
    }

    public Store createStore(StoreCreationWithMerchantCodeRequest storeCreationWithMerchantCodeRequest) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        String requestBody = storeCreationWithMerchantCodeRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/stores");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return Store.fromJson(jsonResult);
    }
}

