/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.CreateMerchantRequest;
import com.adyen.model.management.CreateMerchantResponse;
import com.adyen.model.management.JSON;
import com.adyen.model.management.ListMerchantResponse;
import com.adyen.model.management.Merchant;
import com.adyen.model.management.RequestActivationResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AccountMerchantLevel
extends ApiKeyAuthenticatedService {
    public AccountMerchantLevel(Client client) {
        super(client);
        new JSON();
    }

    public ListMerchantResponse listMerchantAccounts(Map<String, String> queryParams) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListMerchantResponse.fromJson(jsonResult);
    }

    public Merchant getMerchantAccount(String merchantId) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return Merchant.fromJson(jsonResult);
    }

    public CreateMerchantResponse createMerchantAccount(CreateMerchantRequest createMerchantRequest) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        String requestBody = createMerchantRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return CreateMerchantResponse.fromJson(jsonResult);
    }

    public RequestActivationResponse requestToActivateMerchantAccount(String merchantId) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/activate");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return RequestActivationResponse.fromJson(jsonResult);
    }
}

