/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.JSON;
import com.adyen.model.recurring.PermitRestriction;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Permit {
    public static final String SERIALIZED_NAME_PARTNER_ID = "partnerId";
    @SerializedName(value="partnerId")
    private String partnerId;
    public static final String SERIALIZED_NAME_PROFILE_REFERENCE = "profileReference";
    @SerializedName(value="profileReference")
    private String profileReference;
    public static final String SERIALIZED_NAME_RESTRICTION = "restriction";
    @SerializedName(value="restriction")
    private PermitRestriction restriction;
    public static final String SERIALIZED_NAME_RESULT_KEY = "resultKey";
    @SerializedName(value="resultKey")
    private String resultKey;
    public static final String SERIALIZED_NAME_VALID_TILL_DATE = "validTillDate";
    @SerializedName(value="validTillDate")
    private OffsetDateTime validTillDate;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Permit partnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    @ApiModelProperty(value="Partner ID (when using the permit-per-partner token sharing model).")
    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public Permit profileReference(String profileReference) {
        this.profileReference = profileReference;
        return this;
    }

    @ApiModelProperty(value="The profile to apply to this permit (when using the shared permits model).")
    public String getProfileReference() {
        return this.profileReference;
    }

    public void setProfileReference(String profileReference) {
        this.profileReference = profileReference;
    }

    public Permit restriction(PermitRestriction restriction) {
        this.restriction = restriction;
        return this;
    }

    @ApiModelProperty(value="")
    public PermitRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(PermitRestriction restriction) {
        this.restriction = restriction;
    }

    public Permit resultKey(String resultKey) {
        this.resultKey = resultKey;
        return this;
    }

    @ApiModelProperty(value="The key to link permit requests to permit results.")
    public String getResultKey() {
        return this.resultKey;
    }

    public void setResultKey(String resultKey) {
        this.resultKey = resultKey;
    }

    public Permit validTillDate(OffsetDateTime validTillDate) {
        this.validTillDate = validTillDate;
        return this;
    }

    @ApiModelProperty(value="The expiry date for this permit.")
    public OffsetDateTime getValidTillDate() {
        return this.validTillDate;
    }

    public void setValidTillDate(OffsetDateTime validTillDate) {
        this.validTillDate = validTillDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permit permit = (Permit)o;
        return Objects.equals(this.partnerId, permit.partnerId) && Objects.equals(this.profileReference, permit.profileReference) && Objects.equals(this.restriction, permit.restriction) && Objects.equals(this.resultKey, permit.resultKey) && Objects.equals(this.validTillDate, permit.validTillDate);
    }

    public int hashCode() {
        return Objects.hash(this.partnerId, this.profileReference, this.restriction, this.resultKey, this.validTillDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Permit {\n");
        sb.append("    partnerId: ").append(this.toIndentedString(this.partnerId)).append("\n");
        sb.append("    profileReference: ").append(this.toIndentedString(this.profileReference)).append("\n");
        sb.append("    restriction: ").append(this.toIndentedString(this.restriction)).append("\n");
        sb.append("    resultKey: ").append(this.toIndentedString(this.resultKey)).append("\n");
        sb.append("    validTillDate: ").append(this.toIndentedString(this.validTillDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Permit is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Permit` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARTNER_ID) != null && !jsonObj.get(SERIALIZED_NAME_PARTNER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `partnerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARTNER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROFILE_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PROFILE_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `profileReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROFILE_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RESTRICTION) != null) {
            PermitRestriction.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RESTRICTION));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESULT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_RESULT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resultKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULT_KEY).toString()));
        }
    }

    public static Permit fromJson(String jsonString) throws IOException {
        return (Permit)JSON.getGson().fromJson(jsonString, Permit.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PARTNER_ID);
        openapiFields.add(SERIALIZED_NAME_PROFILE_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_RESTRICTION);
        openapiFields.add(SERIALIZED_NAME_RESULT_KEY);
        openapiFields.add(SERIALIZED_NAME_VALID_TILL_DATE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Permit.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Permit.class));
            return new TypeAdapter<Permit>(){

                public void write(JsonWriter out, Permit value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Permit read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Permit.validateJsonObject(jsonObj);
                    return (Permit)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

