/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payments;

import com.adyen.model.payments.AcctInfo;
import com.adyen.model.payments.DeviceRenderOptions;
import com.adyen.model.payments.JSON;
import com.adyen.model.payments.Phone;
import com.adyen.model.payments.SDKEphemPubKey;
import com.adyen.model.payments.ThreeDSRequestorAuthenticationInfo;
import com.adyen.model.payments.ThreeDSRequestorPriorAuthenticationInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ThreeDS2RequestData {
    public static final String SERIALIZED_NAME_ACCT_INFO = "acctInfo";
    @SerializedName(value="acctInfo")
    private AcctInfo acctInfo;
    public static final String SERIALIZED_NAME_ACCT_TYPE = "acctType";
    @SerializedName(value="acctType")
    private AcctTypeEnum acctType;
    public static final String SERIALIZED_NAME_ACQUIRER_B_I_N = "acquirerBIN";
    @SerializedName(value="acquirerBIN")
    private String acquirerBIN;
    public static final String SERIALIZED_NAME_ACQUIRER_MERCHANT_I_D = "acquirerMerchantID";
    @SerializedName(value="acquirerMerchantID")
    private String acquirerMerchantID;
    public static final String SERIALIZED_NAME_ADDR_MATCH = "addrMatch";
    @SerializedName(value="addrMatch")
    private AddrMatchEnum addrMatch;
    public static final String SERIALIZED_NAME_AUTHENTICATION_ONLY = "authenticationOnly";
    @SerializedName(value="authenticationOnly")
    private Boolean authenticationOnly = false;
    public static final String SERIALIZED_NAME_CHALLENGE_INDICATOR = "challengeIndicator";
    @SerializedName(value="challengeIndicator")
    private ChallengeIndicatorEnum challengeIndicator;
    public static final String SERIALIZED_NAME_DEVICE_CHANNEL = "deviceChannel";
    @SerializedName(value="deviceChannel")
    private String deviceChannel;
    public static final String SERIALIZED_NAME_DEVICE_RENDER_OPTIONS = "deviceRenderOptions";
    @SerializedName(value="deviceRenderOptions")
    private DeviceRenderOptions deviceRenderOptions;
    public static final String SERIALIZED_NAME_HOME_PHONE = "homePhone";
    @SerializedName(value="homePhone")
    private Phone homePhone;
    public static final String SERIALIZED_NAME_MCC = "mcc";
    @SerializedName(value="mcc")
    private String mcc;
    public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchantName";
    @SerializedName(value="merchantName")
    private String merchantName;
    public static final String SERIALIZED_NAME_MESSAGE_VERSION = "messageVersion";
    @SerializedName(value="messageVersion")
    private String messageVersion = "2.1.0";
    public static final String SERIALIZED_NAME_MOBILE_PHONE = "mobilePhone";
    @SerializedName(value="mobilePhone")
    private Phone mobilePhone;
    public static final String SERIALIZED_NAME_NOTIFICATION_U_R_L = "notificationURL";
    @SerializedName(value="notificationURL")
    private String notificationURL;
    public static final String SERIALIZED_NAME_PAY_TOKEN_IND = "payTokenInd";
    @SerializedName(value="payTokenInd")
    private Boolean payTokenInd;
    public static final String SERIALIZED_NAME_PAYMENT_AUTHENTICATION_USE_CASE = "paymentAuthenticationUseCase";
    @SerializedName(value="paymentAuthenticationUseCase")
    private String paymentAuthenticationUseCase;
    public static final String SERIALIZED_NAME_PURCHASE_INSTAL_DATA = "purchaseInstalData";
    @SerializedName(value="purchaseInstalData")
    private String purchaseInstalData;
    public static final String SERIALIZED_NAME_RECURRING_EXPIRY = "recurringExpiry";
    @SerializedName(value="recurringExpiry")
    private String recurringExpiry;
    public static final String SERIALIZED_NAME_RECURRING_FREQUENCY = "recurringFrequency";
    @SerializedName(value="recurringFrequency")
    private String recurringFrequency;
    public static final String SERIALIZED_NAME_SDK_APP_I_D = "sdkAppID";
    @SerializedName(value="sdkAppID")
    private String sdkAppID;
    public static final String SERIALIZED_NAME_SDK_ENC_DATA = "sdkEncData";
    @SerializedName(value="sdkEncData")
    private String sdkEncData;
    public static final String SERIALIZED_NAME_SDK_EPHEM_PUB_KEY = "sdkEphemPubKey";
    @SerializedName(value="sdkEphemPubKey")
    private SDKEphemPubKey sdkEphemPubKey;
    public static final String SERIALIZED_NAME_SDK_MAX_TIMEOUT = "sdkMaxTimeout";
    @SerializedName(value="sdkMaxTimeout")
    private Integer sdkMaxTimeout = 60;
    public static final String SERIALIZED_NAME_SDK_REFERENCE_NUMBER = "sdkReferenceNumber";
    @SerializedName(value="sdkReferenceNumber")
    private String sdkReferenceNumber;
    public static final String SERIALIZED_NAME_SDK_TRANS_I_D = "sdkTransID";
    @SerializedName(value="sdkTransID")
    private String sdkTransID;
    public static final String SERIALIZED_NAME_SDK_VERSION = "sdkVersion";
    @SerializedName(value="sdkVersion")
    private String sdkVersion;
    public static final String SERIALIZED_NAME_THREE_D_S_COMP_IND = "threeDSCompInd";
    @SerializedName(value="threeDSCompInd")
    private String threeDSCompInd;
    public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_IND = "threeDSRequestorAuthenticationInd";
    @SerializedName(value="threeDSRequestorAuthenticationInd")
    private String threeDSRequestorAuthenticationInd;
    public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO = "threeDSRequestorAuthenticationInfo";
    @SerializedName(value="threeDSRequestorAuthenticationInfo")
    private ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo;
    public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_CHALLENGE_IND = "threeDSRequestorChallengeInd";
    @SerializedName(value="threeDSRequestorChallengeInd")
    private ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd;
    public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_I_D = "threeDSRequestorID";
    @SerializedName(value="threeDSRequestorID")
    private String threeDSRequestorID;
    public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_NAME = "threeDSRequestorName";
    @SerializedName(value="threeDSRequestorName")
    private String threeDSRequestorName;
    public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO = "threeDSRequestorPriorAuthenticationInfo";
    @SerializedName(value="threeDSRequestorPriorAuthenticationInfo")
    private ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo;
    public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_U_R_L = "threeDSRequestorURL";
    @SerializedName(value="threeDSRequestorURL")
    private String threeDSRequestorURL;
    public static final String SERIALIZED_NAME_TRANS_TYPE = "transType";
    @SerializedName(value="transType")
    private TransTypeEnum transType;
    public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
    @SerializedName(value="transactionType")
    private TransactionTypeEnum transactionType;
    public static final String SERIALIZED_NAME_WHITE_LIST_STATUS = "whiteListStatus";
    @SerializedName(value="whiteListStatus")
    private String whiteListStatus;
    public static final String SERIALIZED_NAME_WORK_PHONE = "workPhone";
    @SerializedName(value="workPhone")
    private Phone workPhone;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ThreeDS2RequestData acctInfo(AcctInfo acctInfo) {
        this.acctInfo = acctInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public AcctInfo getAcctInfo() {
        return this.acctInfo;
    }

    public void setAcctInfo(AcctInfo acctInfo) {
        this.acctInfo = acctInfo;
    }

    public ThreeDS2RequestData acctType(AcctTypeEnum acctType) {
        this.acctType = acctType;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of account. For example, for a multi-account card product. Length: 2 characters. Allowed values: * **01** \u2014 Not applicable * **02** \u2014 Credit * **03** \u2014 Debit")
    public AcctTypeEnum getAcctType() {
        return this.acctType;
    }

    public void setAcctType(AcctTypeEnum acctType) {
        this.acctType = acctType;
    }

    public ThreeDS2RequestData acquirerBIN(String acquirerBIN) {
        this.acquirerBIN = acquirerBIN;
        return this;
    }

    @ApiModelProperty(value="Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The acquiring BIN enrolled for 3D Secure 2. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.")
    public String getAcquirerBIN() {
        return this.acquirerBIN;
    }

    public void setAcquirerBIN(String acquirerBIN) {
        this.acquirerBIN = acquirerBIN;
    }

    public ThreeDS2RequestData acquirerMerchantID(String acquirerMerchantID) {
        this.acquirerMerchantID = acquirerMerchantID;
        return this;
    }

    @ApiModelProperty(value="Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchantId that is enrolled for 3D Secure 2 by the merchant's acquirer. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.")
    public String getAcquirerMerchantID() {
        return this.acquirerMerchantID;
    }

    public void setAcquirerMerchantID(String acquirerMerchantID) {
        this.acquirerMerchantID = acquirerMerchantID;
    }

    public ThreeDS2RequestData addrMatch(AddrMatchEnum addrMatch) {
        this.addrMatch = addrMatch;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the Cardholder Shipping Address and Cardholder Billing Address are the same. Allowed values: * **Y** \u2014 Shipping Address matches Billing Address. * **N** \u2014 Shipping Address does not match Billing Address.")
    public AddrMatchEnum getAddrMatch() {
        return this.addrMatch;
    }

    public void setAddrMatch(AddrMatchEnum addrMatch) {
        this.addrMatch = addrMatch;
    }

    public ThreeDS2RequestData authenticationOnly(Boolean authenticationOnly) {
        this.authenticationOnly = authenticationOnly;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")
    public Boolean getAuthenticationOnly() {
        return this.authenticationOnly;
    }

    public void setAuthenticationOnly(Boolean authenticationOnly) {
        this.authenticationOnly = authenticationOnly;
    }

    public ThreeDS2RequestData challengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
        this.challengeIndicator = challengeIndicator;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Possibility to specify a preference for receiving a challenge from the issuer. Allowed values: * `noPreference` * `requestNoChallenge` * `requestChallenge` * `requestChallengeAsMandate` ")
    public ChallengeIndicatorEnum getChallengeIndicator() {
        return this.challengeIndicator;
    }

    public void setChallengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
        this.challengeIndicator = challengeIndicator;
    }

    public ThreeDS2RequestData deviceChannel(String deviceChannel) {
        this.deviceChannel = deviceChannel;
        return this;
    }

    @ApiModelProperty(required=true, value="The environment of the shopper. Allowed values: * `app` * `browser`")
    public String getDeviceChannel() {
        return this.deviceChannel;
    }

    public void setDeviceChannel(String deviceChannel) {
        this.deviceChannel = deviceChannel;
    }

    public ThreeDS2RequestData deviceRenderOptions(DeviceRenderOptions deviceRenderOptions) {
        this.deviceRenderOptions = deviceRenderOptions;
        return this;
    }

    @ApiModelProperty(value="")
    public DeviceRenderOptions getDeviceRenderOptions() {
        return this.deviceRenderOptions;
    }

    public void setDeviceRenderOptions(DeviceRenderOptions deviceRenderOptions) {
        this.deviceRenderOptions = deviceRenderOptions;
    }

    public ThreeDS2RequestData homePhone(Phone homePhone) {
        this.homePhone = homePhone;
        return this;
    }

    @ApiModelProperty(value="")
    public Phone getHomePhone() {
        return this.homePhone;
    }

    public void setHomePhone(Phone homePhone) {
        this.homePhone = homePhone;
    }

    public ThreeDS2RequestData mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="Required for merchants that have been enrolled for 3D Secure 2 by another party than Adyen, mostly [authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The `mcc` is a four-digit code with which the previously given `acquirerMerchantID` is registered at the scheme.")
    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public ThreeDS2RequestData merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @ApiModelProperty(value="Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchant name that the issuer presents to the shopper if they get a challenge. We recommend to use the same value that you will use in the authorization. Maximum length is 40 characters. > Optional for a [full 3D Secure 2 integration](https://docs.adyen.com/online-payments/3d-secure/native-3ds2/api-integration). Use this field if you are enrolled for 3D Secure 2 with us and want to override the merchant name already configured on your account.")
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public ThreeDS2RequestData messageVersion(String messageVersion) {
        this.messageVersion = messageVersion;
        return this;
    }

    @ApiModelProperty(value="The `messageVersion` value indicating the 3D Secure 2 protocol version.")
    public String getMessageVersion() {
        return this.messageVersion;
    }

    public void setMessageVersion(String messageVersion) {
        this.messageVersion = messageVersion;
    }

    public ThreeDS2RequestData mobilePhone(Phone mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    @ApiModelProperty(value="")
    public Phone getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(Phone mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public ThreeDS2RequestData notificationURL(String notificationURL) {
        this.notificationURL = notificationURL;
        return this;
    }

    @ApiModelProperty(value="URL to where the issuer should send the `CRes`. Required if you are not using components for `channel` **Web** or if you are using classic integration `deviceChannel` **browser**.")
    public String getNotificationURL() {
        return this.notificationURL;
    }

    public void setNotificationURL(String notificationURL) {
        this.notificationURL = notificationURL;
    }

    public ThreeDS2RequestData payTokenInd(Boolean payTokenInd) {
        this.payTokenInd = payTokenInd;
        return this;
    }

    @ApiModelProperty(value="Value **true** indicates that the transaction was de-tokenised prior to being received by the ACS.")
    public Boolean getPayTokenInd() {
        return this.payTokenInd;
    }

    public void setPayTokenInd(Boolean payTokenInd) {
        this.payTokenInd = payTokenInd;
    }

    public ThreeDS2RequestData paymentAuthenticationUseCase(String paymentAuthenticationUseCase) {
        this.paymentAuthenticationUseCase = paymentAuthenticationUseCase;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of payment for which an authentication is requested (message extension)")
    public String getPaymentAuthenticationUseCase() {
        return this.paymentAuthenticationUseCase;
    }

    public void setPaymentAuthenticationUseCase(String paymentAuthenticationUseCase) {
        this.paymentAuthenticationUseCase = paymentAuthenticationUseCase;
    }

    public ThreeDS2RequestData purchaseInstalData(String purchaseInstalData) {
        this.purchaseInstalData = purchaseInstalData;
        return this;
    }

    @ApiModelProperty(value="Indicates the maximum number of authorisations permitted for instalment payments. Length: 1\u20133 characters.")
    public String getPurchaseInstalData() {
        return this.purchaseInstalData;
    }

    public void setPurchaseInstalData(String purchaseInstalData) {
        this.purchaseInstalData = purchaseInstalData;
    }

    public ThreeDS2RequestData recurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
        return this;
    }

    @ApiModelProperty(value="Date after which no further authorisations shall be performed. Format: YYYYMMDD")
    public String getRecurringExpiry() {
        return this.recurringExpiry;
    }

    public void setRecurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
    }

    public ThreeDS2RequestData recurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
        return this;
    }

    @ApiModelProperty(value="Indicates the minimum number of days between authorisations. Maximum length: 4 characters.")
    public String getRecurringFrequency() {
        return this.recurringFrequency;
    }

    public void setRecurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
    }

    public ThreeDS2RequestData sdkAppID(String sdkAppID) {
        this.sdkAppID = sdkAppID;
        return this;
    }

    @ApiModelProperty(value="The `sdkAppID` value as received from the 3D Secure 2 SDK. Required for `deviceChannel` set to **app**.")
    public String getSdkAppID() {
        return this.sdkAppID;
    }

    public void setSdkAppID(String sdkAppID) {
        this.sdkAppID = sdkAppID;
    }

    public ThreeDS2RequestData sdkEncData(String sdkEncData) {
        this.sdkEncData = sdkEncData;
        return this;
    }

    @ApiModelProperty(value="The `sdkEncData` value as received from the 3D Secure 2 SDK. Required for `deviceChannel` set to **app**.")
    public String getSdkEncData() {
        return this.sdkEncData;
    }

    public void setSdkEncData(String sdkEncData) {
        this.sdkEncData = sdkEncData;
    }

    public ThreeDS2RequestData sdkEphemPubKey(SDKEphemPubKey sdkEphemPubKey) {
        this.sdkEphemPubKey = sdkEphemPubKey;
        return this;
    }

    @ApiModelProperty(value="")
    public SDKEphemPubKey getSdkEphemPubKey() {
        return this.sdkEphemPubKey;
    }

    public void setSdkEphemPubKey(SDKEphemPubKey sdkEphemPubKey) {
        this.sdkEphemPubKey = sdkEphemPubKey;
    }

    public ThreeDS2RequestData sdkMaxTimeout(Integer sdkMaxTimeout) {
        this.sdkMaxTimeout = sdkMaxTimeout;
        return this;
    }

    @ApiModelProperty(value="The maximum amount of time in minutes for the 3D Secure 2 authentication process. Optional and only for `deviceChannel` set to **app**. Defaults to **60** minutes.")
    public Integer getSdkMaxTimeout() {
        return this.sdkMaxTimeout;
    }

    public void setSdkMaxTimeout(Integer sdkMaxTimeout) {
        this.sdkMaxTimeout = sdkMaxTimeout;
    }

    public ThreeDS2RequestData sdkReferenceNumber(String sdkReferenceNumber) {
        this.sdkReferenceNumber = sdkReferenceNumber;
        return this;
    }

    @ApiModelProperty(value="The `sdkReferenceNumber` value as received from the 3D Secure 2 SDK. Only for `deviceChannel` set to **app**.")
    public String getSdkReferenceNumber() {
        return this.sdkReferenceNumber;
    }

    public void setSdkReferenceNumber(String sdkReferenceNumber) {
        this.sdkReferenceNumber = sdkReferenceNumber;
    }

    public ThreeDS2RequestData sdkTransID(String sdkTransID) {
        this.sdkTransID = sdkTransID;
        return this;
    }

    @ApiModelProperty(value="The `sdkTransID` value as received from the 3D Secure 2 SDK. Only for `deviceChannel` set to **app**.")
    public String getSdkTransID() {
        return this.sdkTransID;
    }

    public void setSdkTransID(String sdkTransID) {
        this.sdkTransID = sdkTransID;
    }

    public ThreeDS2RequestData sdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
        return this;
    }

    @ApiModelProperty(value="Version of the 3D Secure 2 mobile SDK.  Only for `deviceChannel` set to **app**.")
    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public ThreeDS2RequestData threeDSCompInd(String threeDSCompInd) {
        this.threeDSCompInd = threeDSCompInd;
        return this;
    }

    @ApiModelProperty(value="Completion indicator for the device fingerprinting.")
    public String getThreeDSCompInd() {
        return this.threeDSCompInd;
    }

    public void setThreeDSCompInd(String threeDSCompInd) {
        this.threeDSCompInd = threeDSCompInd;
    }

    public ThreeDS2RequestData threeDSRequestorAuthenticationInd(String threeDSRequestorAuthenticationInd) {
        this.threeDSRequestorAuthenticationInd = threeDSRequestorAuthenticationInd;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of Authentication request.")
    public String getThreeDSRequestorAuthenticationInd() {
        return this.threeDSRequestorAuthenticationInd;
    }

    public void setThreeDSRequestorAuthenticationInd(String threeDSRequestorAuthenticationInd) {
        this.threeDSRequestorAuthenticationInd = threeDSRequestorAuthenticationInd;
    }

    public ThreeDS2RequestData threeDSRequestorAuthenticationInfo(ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo) {
        this.threeDSRequestorAuthenticationInfo = threeDSRequestorAuthenticationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDSRequestorAuthenticationInfo getThreeDSRequestorAuthenticationInfo() {
        return this.threeDSRequestorAuthenticationInfo;
    }

    public void setThreeDSRequestorAuthenticationInfo(ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo) {
        this.threeDSRequestorAuthenticationInfo = threeDSRequestorAuthenticationInfo;
    }

    public ThreeDS2RequestData threeDSRequestorChallengeInd(ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd) {
        this.threeDSRequestorChallengeInd = threeDSRequestorChallengeInd;
        return this;
    }

    @ApiModelProperty(value="Indicates whether a challenge is requested for this transaction. Possible values: * **01** \u2014 No preference * **02** \u2014 No challenge requested * **03** \u2014 Challenge requested (3DS Requestor preference) * **04** \u2014 Challenge requested (Mandate) * **05** \u2014 No challenge (transactional risk analysis is already performed) * **06** \u2014 Data Only")
    public ThreeDSRequestorChallengeIndEnum getThreeDSRequestorChallengeInd() {
        return this.threeDSRequestorChallengeInd;
    }

    public void setThreeDSRequestorChallengeInd(ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd) {
        this.threeDSRequestorChallengeInd = threeDSRequestorChallengeInd;
    }

    public ThreeDS2RequestData threeDSRequestorID(String threeDSRequestorID) {
        this.threeDSRequestorID = threeDSRequestorID;
        return this;
    }

    @ApiModelProperty(value="Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor identifier assigned by the Directory Server when you enrol for 3D Secure 2.")
    public String getThreeDSRequestorID() {
        return this.threeDSRequestorID;
    }

    public void setThreeDSRequestorID(String threeDSRequestorID) {
        this.threeDSRequestorID = threeDSRequestorID;
    }

    public ThreeDS2RequestData threeDSRequestorName(String threeDSRequestorName) {
        this.threeDSRequestorName = threeDSRequestorName;
        return this;
    }

    @ApiModelProperty(value="Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor name assigned by the Directory Server when you enrol for 3D Secure 2.")
    public String getThreeDSRequestorName() {
        return this.threeDSRequestorName;
    }

    public void setThreeDSRequestorName(String threeDSRequestorName) {
        this.threeDSRequestorName = threeDSRequestorName;
    }

    public ThreeDS2RequestData threeDSRequestorPriorAuthenticationInfo(ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo) {
        this.threeDSRequestorPriorAuthenticationInfo = threeDSRequestorPriorAuthenticationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDSRequestorPriorAuthenticationInfo getThreeDSRequestorPriorAuthenticationInfo() {
        return this.threeDSRequestorPriorAuthenticationInfo;
    }

    public void setThreeDSRequestorPriorAuthenticationInfo(ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo) {
        this.threeDSRequestorPriorAuthenticationInfo = threeDSRequestorPriorAuthenticationInfo;
    }

    public ThreeDS2RequestData threeDSRequestorURL(String threeDSRequestorURL) {
        this.threeDSRequestorURL = threeDSRequestorURL;
        return this;
    }

    @ApiModelProperty(value="URL of the (customer service) website that will be shown to the shopper in case of technical errors during the 3D Secure 2 process.")
    public String getThreeDSRequestorURL() {
        return this.threeDSRequestorURL;
    }

    public void setThreeDSRequestorURL(String threeDSRequestorURL) {
        this.threeDSRequestorURL = threeDSRequestorURL;
    }

    public ThreeDS2RequestData transType(TransTypeEnum transType) {
        this.transType = transType;
        return this;
    }

    @ApiModelProperty(value="Identifies the type of transaction being authenticated. Length: 2 characters. Allowed values: * **01** \u2014 Goods/Service Purchase * **03** \u2014 Check Acceptance * **10** \u2014 Account Funding * **11** \u2014 Quasi-Cash Transaction * **28** \u2014 Prepaid Activation and Load")
    public TransTypeEnum getTransType() {
        return this.transType;
    }

    public void setTransType(TransTypeEnum transType) {
        this.transType = transType;
    }

    public ThreeDS2RequestData transactionType(TransactionTypeEnum transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @ApiModelProperty(value="Identify the type of the transaction being authenticated.")
    public TransactionTypeEnum getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionTypeEnum transactionType) {
        this.transactionType = transactionType;
    }

    public ThreeDS2RequestData whiteListStatus(String whiteListStatus) {
        this.whiteListStatus = whiteListStatus;
        return this;
    }

    @ApiModelProperty(value="The `whiteListStatus` value returned from a previous 3D Secure 2 transaction, only applicable for 3D Secure 2 protocol version 2.2.0.")
    public String getWhiteListStatus() {
        return this.whiteListStatus;
    }

    public void setWhiteListStatus(String whiteListStatus) {
        this.whiteListStatus = whiteListStatus;
    }

    public ThreeDS2RequestData workPhone(Phone workPhone) {
        this.workPhone = workPhone;
        return this;
    }

    @ApiModelProperty(value="")
    public Phone getWorkPhone() {
        return this.workPhone;
    }

    public void setWorkPhone(Phone workPhone) {
        this.workPhone = workPhone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDS2RequestData threeDS2RequestData = (ThreeDS2RequestData)o;
        return Objects.equals(this.acctInfo, threeDS2RequestData.acctInfo) && Objects.equals((Object)this.acctType, (Object)threeDS2RequestData.acctType) && Objects.equals(this.acquirerBIN, threeDS2RequestData.acquirerBIN) && Objects.equals(this.acquirerMerchantID, threeDS2RequestData.acquirerMerchantID) && Objects.equals((Object)this.addrMatch, (Object)threeDS2RequestData.addrMatch) && Objects.equals(this.authenticationOnly, threeDS2RequestData.authenticationOnly) && Objects.equals((Object)this.challengeIndicator, (Object)threeDS2RequestData.challengeIndicator) && Objects.equals(this.deviceChannel, threeDS2RequestData.deviceChannel) && Objects.equals(this.deviceRenderOptions, threeDS2RequestData.deviceRenderOptions) && Objects.equals(this.homePhone, threeDS2RequestData.homePhone) && Objects.equals(this.mcc, threeDS2RequestData.mcc) && Objects.equals(this.merchantName, threeDS2RequestData.merchantName) && Objects.equals(this.messageVersion, threeDS2RequestData.messageVersion) && Objects.equals(this.mobilePhone, threeDS2RequestData.mobilePhone) && Objects.equals(this.notificationURL, threeDS2RequestData.notificationURL) && Objects.equals(this.payTokenInd, threeDS2RequestData.payTokenInd) && Objects.equals(this.paymentAuthenticationUseCase, threeDS2RequestData.paymentAuthenticationUseCase) && Objects.equals(this.purchaseInstalData, threeDS2RequestData.purchaseInstalData) && Objects.equals(this.recurringExpiry, threeDS2RequestData.recurringExpiry) && Objects.equals(this.recurringFrequency, threeDS2RequestData.recurringFrequency) && Objects.equals(this.sdkAppID, threeDS2RequestData.sdkAppID) && Objects.equals(this.sdkEncData, threeDS2RequestData.sdkEncData) && Objects.equals(this.sdkEphemPubKey, threeDS2RequestData.sdkEphemPubKey) && Objects.equals(this.sdkMaxTimeout, threeDS2RequestData.sdkMaxTimeout) && Objects.equals(this.sdkReferenceNumber, threeDS2RequestData.sdkReferenceNumber) && Objects.equals(this.sdkTransID, threeDS2RequestData.sdkTransID) && Objects.equals(this.sdkVersion, threeDS2RequestData.sdkVersion) && Objects.equals(this.threeDSCompInd, threeDS2RequestData.threeDSCompInd) && Objects.equals(this.threeDSRequestorAuthenticationInd, threeDS2RequestData.threeDSRequestorAuthenticationInd) && Objects.equals(this.threeDSRequestorAuthenticationInfo, threeDS2RequestData.threeDSRequestorAuthenticationInfo) && Objects.equals((Object)this.threeDSRequestorChallengeInd, (Object)threeDS2RequestData.threeDSRequestorChallengeInd) && Objects.equals(this.threeDSRequestorID, threeDS2RequestData.threeDSRequestorID) && Objects.equals(this.threeDSRequestorName, threeDS2RequestData.threeDSRequestorName) && Objects.equals(this.threeDSRequestorPriorAuthenticationInfo, threeDS2RequestData.threeDSRequestorPriorAuthenticationInfo) && Objects.equals(this.threeDSRequestorURL, threeDS2RequestData.threeDSRequestorURL) && Objects.equals((Object)this.transType, (Object)threeDS2RequestData.transType) && Objects.equals((Object)this.transactionType, (Object)threeDS2RequestData.transactionType) && Objects.equals(this.whiteListStatus, threeDS2RequestData.whiteListStatus) && Objects.equals(this.workPhone, threeDS2RequestData.workPhone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acctInfo, this.acctType, this.acquirerBIN, this.acquirerMerchantID, this.addrMatch, this.authenticationOnly, this.challengeIndicator, this.deviceChannel, this.deviceRenderOptions, this.homePhone, this.mcc, this.merchantName, this.messageVersion, this.mobilePhone, this.notificationURL, this.payTokenInd, this.paymentAuthenticationUseCase, this.purchaseInstalData, this.recurringExpiry, this.recurringFrequency, this.sdkAppID, this.sdkEncData, this.sdkEphemPubKey, this.sdkMaxTimeout, this.sdkReferenceNumber, this.sdkTransID, this.sdkVersion, this.threeDSCompInd, this.threeDSRequestorAuthenticationInd, this.threeDSRequestorAuthenticationInfo, this.threeDSRequestorChallengeInd, this.threeDSRequestorID, this.threeDSRequestorName, this.threeDSRequestorPriorAuthenticationInfo, this.threeDSRequestorURL, this.transType, this.transactionType, this.whiteListStatus, this.workPhone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDS2RequestData {\n");
        sb.append("    acctInfo: ").append(this.toIndentedString(this.acctInfo)).append("\n");
        sb.append("    acctType: ").append(this.toIndentedString((Object)this.acctType)).append("\n");
        sb.append("    acquirerBIN: ").append(this.toIndentedString(this.acquirerBIN)).append("\n");
        sb.append("    acquirerMerchantID: ").append(this.toIndentedString(this.acquirerMerchantID)).append("\n");
        sb.append("    addrMatch: ").append(this.toIndentedString((Object)this.addrMatch)).append("\n");
        sb.append("    authenticationOnly: ").append(this.toIndentedString(this.authenticationOnly)).append("\n");
        sb.append("    challengeIndicator: ").append(this.toIndentedString((Object)this.challengeIndicator)).append("\n");
        sb.append("    deviceChannel: ").append(this.toIndentedString(this.deviceChannel)).append("\n");
        sb.append("    deviceRenderOptions: ").append(this.toIndentedString(this.deviceRenderOptions)).append("\n");
        sb.append("    homePhone: ").append(this.toIndentedString(this.homePhone)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    messageVersion: ").append(this.toIndentedString(this.messageVersion)).append("\n");
        sb.append("    mobilePhone: ").append(this.toIndentedString(this.mobilePhone)).append("\n");
        sb.append("    notificationURL: ").append(this.toIndentedString(this.notificationURL)).append("\n");
        sb.append("    payTokenInd: ").append(this.toIndentedString(this.payTokenInd)).append("\n");
        sb.append("    paymentAuthenticationUseCase: ").append(this.toIndentedString(this.paymentAuthenticationUseCase)).append("\n");
        sb.append("    purchaseInstalData: ").append(this.toIndentedString(this.purchaseInstalData)).append("\n");
        sb.append("    recurringExpiry: ").append(this.toIndentedString(this.recurringExpiry)).append("\n");
        sb.append("    recurringFrequency: ").append(this.toIndentedString(this.recurringFrequency)).append("\n");
        sb.append("    sdkAppID: ").append(this.toIndentedString(this.sdkAppID)).append("\n");
        sb.append("    sdkEncData: ").append(this.toIndentedString(this.sdkEncData)).append("\n");
        sb.append("    sdkEphemPubKey: ").append(this.toIndentedString(this.sdkEphemPubKey)).append("\n");
        sb.append("    sdkMaxTimeout: ").append(this.toIndentedString(this.sdkMaxTimeout)).append("\n");
        sb.append("    sdkReferenceNumber: ").append(this.toIndentedString(this.sdkReferenceNumber)).append("\n");
        sb.append("    sdkTransID: ").append(this.toIndentedString(this.sdkTransID)).append("\n");
        sb.append("    sdkVersion: ").append(this.toIndentedString(this.sdkVersion)).append("\n");
        sb.append("    threeDSCompInd: ").append(this.toIndentedString(this.threeDSCompInd)).append("\n");
        sb.append("    threeDSRequestorAuthenticationInd: ").append(this.toIndentedString(this.threeDSRequestorAuthenticationInd)).append("\n");
        sb.append("    threeDSRequestorAuthenticationInfo: ").append(this.toIndentedString(this.threeDSRequestorAuthenticationInfo)).append("\n");
        sb.append("    threeDSRequestorChallengeInd: ").append(this.toIndentedString((Object)this.threeDSRequestorChallengeInd)).append("\n");
        sb.append("    threeDSRequestorID: ").append(this.toIndentedString(this.threeDSRequestorID)).append("\n");
        sb.append("    threeDSRequestorName: ").append(this.toIndentedString(this.threeDSRequestorName)).append("\n");
        sb.append("    threeDSRequestorPriorAuthenticationInfo: ").append(this.toIndentedString(this.threeDSRequestorPriorAuthenticationInfo)).append("\n");
        sb.append("    threeDSRequestorURL: ").append(this.toIndentedString(this.threeDSRequestorURL)).append("\n");
        sb.append("    transType: ").append(this.toIndentedString((Object)this.transType)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString((Object)this.transactionType)).append("\n");
        sb.append("    whiteListStatus: ").append(this.toIndentedString(this.whiteListStatus)).append("\n");
        sb.append("    workPhone: ").append(this.toIndentedString(this.workPhone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ThreeDS2RequestData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ThreeDS2RequestData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCT_INFO) != null) {
            AcctInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCT_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCT_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACCT_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `acctType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCT_TYPE).toString()));
            }
            AcctTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ACCT_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_ACQUIRER_B_I_N) != null && !jsonObj.get(SERIALIZED_NAME_ACQUIRER_B_I_N).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `acquirerBIN` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACQUIRER_B_I_N).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACQUIRER_MERCHANT_I_D) != null && !jsonObj.get(SERIALIZED_NAME_ACQUIRER_MERCHANT_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `acquirerMerchantID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACQUIRER_MERCHANT_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDR_MATCH) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ADDR_MATCH).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `addrMatch` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDR_MATCH).toString()));
            }
            AddrMatchEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ADDR_MATCH).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_CHALLENGE_INDICATOR) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CHALLENGE_INDICATOR).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `challengeIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHALLENGE_INDICATOR).toString()));
            }
            ChallengeIndicatorEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CHALLENGE_INDICATOR).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_CHANNEL) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_CHANNEL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `deviceChannel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_CHANNEL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DEVICE_RENDER_OPTIONS) != null) {
            DeviceRenderOptions.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DEVICE_RENDER_OPTIONS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_HOME_PHONE) != null) {
            Phone.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_HOME_PHONE));
        }
        if (jsonObj.get(SERIALIZED_NAME_MCC) != null && !jsonObj.get(SERIALIZED_NAME_MCC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MCC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_NAME) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MESSAGE_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGE_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `messageVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE_VERSION).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MOBILE_PHONE) != null) {
            Phone.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MOBILE_PHONE));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIFICATION_U_R_L) != null && !jsonObj.get(SERIALIZED_NAME_NOTIFICATION_U_R_L).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `notificationURL` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIFICATION_U_R_L).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_AUTHENTICATION_USE_CASE) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_AUTHENTICATION_USE_CASE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `paymentAuthenticationUseCase` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_AUTHENTICATION_USE_CASE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PURCHASE_INSTAL_DATA) != null && !jsonObj.get(SERIALIZED_NAME_PURCHASE_INSTAL_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `purchaseInstalData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PURCHASE_INSTAL_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_EXPIRY) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_EXPIRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recurringExpiry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_EXPIRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recurringFrequency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SDK_APP_I_D) != null && !jsonObj.get(SERIALIZED_NAME_SDK_APP_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sdkAppID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SDK_APP_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SDK_ENC_DATA) != null && !jsonObj.get(SERIALIZED_NAME_SDK_ENC_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sdkEncData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SDK_ENC_DATA).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SDK_EPHEM_PUB_KEY) != null) {
            SDKEphemPubKey.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SDK_EPHEM_PUB_KEY));
        }
        if (jsonObj.get(SERIALIZED_NAME_SDK_REFERENCE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_SDK_REFERENCE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sdkReferenceNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SDK_REFERENCE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SDK_TRANS_I_D) != null && !jsonObj.get(SERIALIZED_NAME_SDK_TRANS_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sdkTransID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SDK_TRANS_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SDK_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_SDK_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sdkVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SDK_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_COMP_IND) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S_COMP_IND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `threeDSCompInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_COMP_IND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_IND) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_IND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `threeDSRequestorAuthenticationInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_IND).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO) != null) {
            ThreeDSRequestorAuthenticationInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_CHALLENGE_IND) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_CHALLENGE_IND).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `threeDSRequestorChallengeInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_CHALLENGE_IND).toString()));
            }
            ThreeDSRequestorChallengeIndEnum.fromValue(jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_CHALLENGE_IND).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_I_D) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `threeDSRequestorID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_NAME) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `threeDSRequestorName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO) != null) {
            ThreeDSRequestorPriorAuthenticationInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_U_R_L) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_U_R_L).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `threeDSRequestorURL` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQUESTOR_U_R_L).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANS_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TRANS_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `transType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANS_TYPE).toString()));
            }
            TransTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TRANS_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TRANSACTION_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `transactionType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_TYPE).toString()));
            }
            TransactionTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TRANSACTION_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_WHITE_LIST_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_WHITE_LIST_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `whiteListStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WHITE_LIST_STATUS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WORK_PHONE) != null) {
            Phone.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WORK_PHONE));
        }
    }

    public static ThreeDS2RequestData fromJson(String jsonString) throws IOException {
        return (ThreeDS2RequestData)JSON.getGson().fromJson(jsonString, ThreeDS2RequestData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCT_INFO);
        openapiFields.add(SERIALIZED_NAME_ACCT_TYPE);
        openapiFields.add(SERIALIZED_NAME_ACQUIRER_B_I_N);
        openapiFields.add(SERIALIZED_NAME_ACQUIRER_MERCHANT_I_D);
        openapiFields.add(SERIALIZED_NAME_ADDR_MATCH);
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATION_ONLY);
        openapiFields.add(SERIALIZED_NAME_CHALLENGE_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_DEVICE_CHANNEL);
        openapiFields.add(SERIALIZED_NAME_DEVICE_RENDER_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_HOME_PHONE);
        openapiFields.add(SERIALIZED_NAME_MCC);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_NAME);
        openapiFields.add(SERIALIZED_NAME_MESSAGE_VERSION);
        openapiFields.add(SERIALIZED_NAME_MOBILE_PHONE);
        openapiFields.add(SERIALIZED_NAME_NOTIFICATION_U_R_L);
        openapiFields.add(SERIALIZED_NAME_PAY_TOKEN_IND);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_AUTHENTICATION_USE_CASE);
        openapiFields.add(SERIALIZED_NAME_PURCHASE_INSTAL_DATA);
        openapiFields.add(SERIALIZED_NAME_RECURRING_EXPIRY);
        openapiFields.add(SERIALIZED_NAME_RECURRING_FREQUENCY);
        openapiFields.add(SERIALIZED_NAME_SDK_APP_I_D);
        openapiFields.add(SERIALIZED_NAME_SDK_ENC_DATA);
        openapiFields.add(SERIALIZED_NAME_SDK_EPHEM_PUB_KEY);
        openapiFields.add(SERIALIZED_NAME_SDK_MAX_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_SDK_REFERENCE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_SDK_TRANS_I_D);
        openapiFields.add(SERIALIZED_NAME_SDK_VERSION);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_COMP_IND);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_IND);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQUESTOR_CHALLENGE_IND);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQUESTOR_I_D);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQUESTOR_NAME);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQUESTOR_U_R_L);
        openapiFields.add(SERIALIZED_NAME_TRANS_TYPE);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_TYPE);
        openapiFields.add(SERIALIZED_NAME_WHITE_LIST_STATUS);
        openapiFields.add(SERIALIZED_NAME_WORK_PHONE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DEVICE_CHANNEL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ThreeDS2RequestData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ThreeDS2RequestData.class));
            return new TypeAdapter<ThreeDS2RequestData>(){

                public void write(JsonWriter out, ThreeDS2RequestData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ThreeDS2RequestData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ThreeDS2RequestData.validateJsonObject(jsonObj);
                    return (ThreeDS2RequestData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransactionTypeEnum {
        GOODSORSERVICEPURCHASE("goodsOrServicePurchase"),
        CHECKACCEPTANCE("checkAcceptance"),
        ACCOUNTFUNDING("accountFunding"),
        QUASICASHTRANSACTION("quasiCashTransaction"),
        PREPAIDACTIVATIONANDLOAD("prepaidActivationAndLoad");

        private String value;

        private TransactionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransactionTypeEnum fromValue(String value) {
            for (TransactionTypeEnum b : TransactionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TransactionTypeEnum> {
            public void write(JsonWriter jsonWriter, TransactionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransactionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransactionTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransTypeEnum {
        _01("01"),
        _03("03"),
        _10("10"),
        _11("11"),
        _28("28");

        private String value;

        private TransTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransTypeEnum fromValue(String value) {
            for (TransTypeEnum b : TransTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TransTypeEnum> {
            public void write(JsonWriter jsonWriter, TransTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ThreeDSRequestorChallengeIndEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05"),
        _06("06");

        private String value;

        private ThreeDSRequestorChallengeIndEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ThreeDSRequestorChallengeIndEnum fromValue(String value) {
            for (ThreeDSRequestorChallengeIndEnum b : ThreeDSRequestorChallengeIndEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ThreeDSRequestorChallengeIndEnum> {
            public void write(JsonWriter jsonWriter, ThreeDSRequestorChallengeIndEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ThreeDSRequestorChallengeIndEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ThreeDSRequestorChallengeIndEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChallengeIndicatorEnum {
        NOPREFERENCE("noPreference"),
        REQUESTNOCHALLENGE("requestNoChallenge"),
        REQUESTCHALLENGE("requestChallenge"),
        REQUESTCHALLENGEASMANDATE("requestChallengeAsMandate");

        private String value;

        private ChallengeIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChallengeIndicatorEnum fromValue(String value) {
            for (ChallengeIndicatorEnum b : ChallengeIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ChallengeIndicatorEnum> {
            public void write(JsonWriter jsonWriter, ChallengeIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChallengeIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChallengeIndicatorEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AddrMatchEnum {
        Y("Y"),
        N("N");

        private String value;

        private AddrMatchEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AddrMatchEnum fromValue(String value) {
            for (AddrMatchEnum b : AddrMatchEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AddrMatchEnum> {
            public void write(JsonWriter jsonWriter, AddrMatchEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AddrMatchEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AddrMatchEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AcctTypeEnum {
        _01("01"),
        _02("02"),
        _03("03");

        private String value;

        private AcctTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AcctTypeEnum fromValue(String value) {
            for (AcctTypeEnum b : AcctTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AcctTypeEnum> {
            public void write(JsonWriter jsonWriter, AcctTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AcctTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AcctTypeEnum.fromValue(value);
            }
        }
    }
}

