/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payments;

import com.adyen.model.payments.AccountInfo;
import com.adyen.model.payments.Address;
import com.adyen.model.payments.Amount;
import com.adyen.model.payments.ApplicationInfo;
import com.adyen.model.payments.BrowserInfo;
import com.adyen.model.payments.ForexQuote;
import com.adyen.model.payments.Installments;
import com.adyen.model.payments.JSON;
import com.adyen.model.payments.MerchantRiskIndicator;
import com.adyen.model.payments.Name;
import com.adyen.model.payments.Recurring;
import com.adyen.model.payments.Split;
import com.adyen.model.payments.ThreeDS2RequestData;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PaymentRequest3d {
    public static final String SERIALIZED_NAME_ACCOUNT_INFO = "accountInfo";
    @SerializedName(value="accountInfo")
    private AccountInfo accountInfo;
    public static final String SERIALIZED_NAME_ADDITIONAL_AMOUNT = "additionalAmount";
    @SerializedName(value="additionalAmount")
    private Amount additionalAmount;
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_APPLICATION_INFO = "applicationInfo";
    @SerializedName(value="applicationInfo")
    private ApplicationInfo applicationInfo;
    public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
    @SerializedName(value="billingAddress")
    private Address billingAddress;
    public static final String SERIALIZED_NAME_BROWSER_INFO = "browserInfo";
    @SerializedName(value="browserInfo")
    private BrowserInfo browserInfo;
    public static final String SERIALIZED_NAME_CAPTURE_DELAY_HOURS = "captureDelayHours";
    @SerializedName(value="captureDelayHours")
    private Integer captureDelayHours;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "dateOfBirth";
    @SerializedName(value="dateOfBirth")
    private OffsetDateTime dateOfBirth;
    public static final String SERIALIZED_NAME_DCC_QUOTE = "dccQuote";
    @SerializedName(value="dccQuote")
    private ForexQuote dccQuote;
    public static final String SERIALIZED_NAME_DELIVERY_ADDRESS = "deliveryAddress";
    @SerializedName(value="deliveryAddress")
    private Address deliveryAddress;
    public static final String SERIALIZED_NAME_DELIVERY_DATE = "deliveryDate";
    @SerializedName(value="deliveryDate")
    private OffsetDateTime deliveryDate;
    public static final String SERIALIZED_NAME_DEVICE_FINGERPRINT = "deviceFingerprint";
    @SerializedName(value="deviceFingerprint")
    private String deviceFingerprint;
    public static final String SERIALIZED_NAME_FRAUD_OFFSET = "fraudOffset";
    @SerializedName(value="fraudOffset")
    private Integer fraudOffset;
    public static final String SERIALIZED_NAME_INSTALLMENTS = "installments";
    @SerializedName(value="installments")
    private Installments installments;
    public static final String SERIALIZED_NAME_MCC = "mcc";
    @SerializedName(value="mcc")
    private String mcc;
    public static final String SERIALIZED_NAME_MD = "md";
    @SerializedName(value="md")
    private String md;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
    @SerializedName(value="merchantOrderReference")
    private String merchantOrderReference;
    public static final String SERIALIZED_NAME_MERCHANT_RISK_INDICATOR = "merchantRiskIndicator";
    @SerializedName(value="merchantRiskIndicator")
    private MerchantRiskIndicator merchantRiskIndicator;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_ORDER_REFERENCE = "orderReference";
    @SerializedName(value="orderReference")
    private String orderReference;
    public static final String SERIALIZED_NAME_PA_RESPONSE = "paResponse";
    @SerializedName(value="paResponse")
    private String paResponse;
    public static final String SERIALIZED_NAME_RECURRING = "recurring";
    @SerializedName(value="recurring")
    private Recurring recurring;
    public static final String SERIALIZED_NAME_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    @SerializedName(value="recurringProcessingModel")
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SELECTED_BRAND = "selectedBrand";
    @SerializedName(value="selectedBrand")
    private String selectedBrand;
    public static final String SERIALIZED_NAME_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
    @SerializedName(value="selectedRecurringDetailReference")
    private String selectedRecurringDetailReference;
    public static final String SERIALIZED_NAME_SESSION_ID = "sessionId";
    @SerializedName(value="sessionId")
    private String sessionId;
    public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
    @SerializedName(value="shopperEmail")
    private String shopperEmail;
    public static final String SERIALIZED_NAME_SHOPPER_I_P = "shopperIP";
    @SerializedName(value="shopperIP")
    private String shopperIP;
    public static final String SERIALIZED_NAME_SHOPPER_INTERACTION = "shopperInteraction";
    @SerializedName(value="shopperInteraction")
    private ShopperInteractionEnum shopperInteraction;
    public static final String SERIALIZED_NAME_SHOPPER_LOCALE = "shopperLocale";
    @SerializedName(value="shopperLocale")
    private String shopperLocale;
    public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
    @SerializedName(value="shopperName")
    private Name shopperName;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static final String SERIALIZED_NAME_SHOPPER_STATEMENT = "shopperStatement";
    @SerializedName(value="shopperStatement")
    private String shopperStatement;
    public static final String SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    @SerializedName(value="socialSecurityNumber")
    private String socialSecurityNumber;
    public static final String SERIALIZED_NAME_SPLITS = "splits";
    @SerializedName(value="splits")
    private List<Split> splits = null;
    public static final String SERIALIZED_NAME_STORE = "store";
    @SerializedName(value="store")
    private String store;
    public static final String SERIALIZED_NAME_TELEPHONE_NUMBER = "telephoneNumber";
    @SerializedName(value="telephoneNumber")
    private String telephoneNumber;
    public static final String SERIALIZED_NAME_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
    @SerializedName(value="threeDS2RequestData")
    private ThreeDS2RequestData threeDS2RequestData;
    public static final String SERIALIZED_NAME_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
    @SerializedName(value="threeDSAuthenticationOnly")
    private Boolean threeDSAuthenticationOnly = false;
    public static final String SERIALIZED_NAME_TOTALS_GROUP = "totalsGroup";
    @SerializedName(value="totalsGroup")
    private String totalsGroup;
    public static final String SERIALIZED_NAME_TRUSTED_SHOPPER = "trustedShopper";
    @SerializedName(value="trustedShopper")
    private Boolean trustedShopper;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaymentRequest3d accountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public PaymentRequest3d additionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAdditionalAmount() {
        return this.additionalAmount;
    }

    public void setAdditionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
    }

    public PaymentRequest3d additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentRequest3d putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular payment request.  The `additionalData` object consists of entries, each of which includes the key and value.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentRequest3d amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentRequest3d applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public PaymentRequest3d billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public PaymentRequest3d browserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    public void setBrowserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
    }

    public PaymentRequest3d captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return this;
    }

    @ApiModelProperty(value="The delay between the authorisation and scheduled auto-capture, specified in hours.")
    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public PaymentRequest3d dateOfBirth(OffsetDateTime dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(value="The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")
    public OffsetDateTime getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(OffsetDateTime dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PaymentRequest3d dccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
        return this;
    }

    @ApiModelProperty(value="")
    public ForexQuote getDccQuote() {
        return this.dccQuote;
    }

    public void setDccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
    }

    public PaymentRequest3d deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public PaymentRequest3d deliveryDate(OffsetDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
        return this;
    }

    @ApiModelProperty(value="The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00")
    public OffsetDateTime getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(OffsetDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public PaymentRequest3d deviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
        return this;
    }

    @ApiModelProperty(value="A string containing the shopper's device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).")
    public String getDeviceFingerprint() {
        return this.deviceFingerprint;
    }

    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    public PaymentRequest3d fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    @ApiModelProperty(value="An integer value that is added to the normal fraud score. The value can be either positive or negative.")
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public PaymentRequest3d installments(Installments installments) {
        this.installments = installments;
        return this;
    }

    @ApiModelProperty(value="")
    public Installments getInstallments() {
        return this.installments;
    }

    public void setInstallments(Installments installments) {
        this.installments = installments;
    }

    public PaymentRequest3d mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")
    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public PaymentRequest3d md(String md) {
        this.md = md;
        return this;
    }

    @ApiModelProperty(required=true, value="The payment session identifier returned by the card issuer.")
    public String getMd() {
        return this.md;
    }

    public void setMd(String md) {
        this.md = md;
    }

    public PaymentRequest3d merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentRequest3d merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return this;
    }

    @ApiModelProperty(value="This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. > We strongly recommend you send the `merchantOrderReference` value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide `retry.orderAttemptNumber`, `retry.chainAttemptNumber`, and `retry.skipRetry` values in `PaymentRequest.additionalData`.")
    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public PaymentRequest3d merchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
        return this;
    }

    @ApiModelProperty(value="")
    public MerchantRiskIndicator getMerchantRiskIndicator() {
        return this.merchantRiskIndicator;
    }

    public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
    }

    public PaymentRequest3d metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PaymentRequest3d putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \"177\" error occurs: \"Metadata size exceeds limit\". * Maximum 20 characters per key. * Maximum 80 characters per value. ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PaymentRequest3d orderReference(String orderReference) {
        this.orderReference = orderReference;
        return this;
    }

    @ApiModelProperty(value="When you are doing multiple partial (gift card) payments, this is the `pspReference` of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the `merchantOrderReference`instead.")
    public String getOrderReference() {
        return this.orderReference;
    }

    public void setOrderReference(String orderReference) {
        this.orderReference = orderReference;
    }

    public PaymentRequest3d paResponse(String paResponse) {
        this.paResponse = paResponse;
        return this;
    }

    @ApiModelProperty(required=true, value="Payment authorisation response returned by the card issuer. The `paResponse` field holds the PaRes value received from the card issuer.")
    public String getPaResponse() {
        return this.paResponse;
    }

    public void setPaResponse(String paResponse) {
        this.paResponse = paResponse;
    }

    public PaymentRequest3d recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @ApiModelProperty(value="")
    public Recurring getRecurring() {
        return this.recurring;
    }

    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public PaymentRequest3d recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @ApiModelProperty(value="Defines a recurring payment type. Allowed values: * `Subscription` \u2013 A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` \u2013 With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` \u2013 An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public PaymentRequest3d reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\"-\"). Maximum length: 80 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentRequest3d selectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
        return this;
    }

    @ApiModelProperty(value="Some payment methods require defining a value for this field to specify how to process the transaction.  For the Bancontact payment method, it can be set to: * `maestro` (default), to be processed like a Maestro card, or * `bcmc`, to be processed like a Bancontact card.")
    public String getSelectedBrand() {
        return this.selectedBrand;
    }

    public void setSelectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
    }

    public PaymentRequest3d selectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="The `recurringDetailReference` you want to use for this payment. The value `LATEST` can be used to select the most recently stored recurring detail.")
    public String getSelectedRecurringDetailReference() {
        return this.selectedRecurringDetailReference;
    }

    public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
    }

    public PaymentRequest3d sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(value="A session ID used to identify a payment session.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public PaymentRequest3d shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The shopper's email address. We recommend that you provide this data, as it is used in velocity fraud checks. > For 3D Secure 2 transactions, schemes require `shopperEmail` for all browser-based and mobile implementations.")
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public PaymentRequest3d shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        return this;
    }

    @ApiModelProperty(value="The shopper's IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). > For 3D Secure 2 transactions, schemes require `shopperIP` for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).")
    public String getShopperIP() {
        return this.shopperIP;
    }

    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
    }

    public PaymentRequest3d shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.")
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public PaymentRequest3d shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @ApiModelProperty(value="The combination of a language code and a country code to specify the language to be used in the payment.")
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public PaymentRequest3d shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public PaymentRequest3d shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public PaymentRequest3d shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @ApiModelProperty(value="The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public PaymentRequest3d socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's social security number.")
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public PaymentRequest3d splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public PaymentRequest3d addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="An array of objects specifying how the payment should be split when using [Adyen for Platforms](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information) or [Issuing](https://docs.adyen.com/issuing/add-manage-funds#split).")
    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public PaymentRequest3d store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The ecommerce or point-of-sale store that is processing the payment. Used in [partner model integrations](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-partners#route-payments) for Adyen for Platforms.")
    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public PaymentRequest3d telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's telephone number.")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public PaymentRequest3d threeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDS2RequestData getThreeDS2RequestData() {
        return this.threeDS2RequestData;
    }

    public void setThreeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
    }

    public PaymentRequest3d threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return this;
    }

    @ApiModelProperty(value="If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")
    public Boolean getThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public PaymentRequest3d totalsGroup(String totalsGroup) {
        this.totalsGroup = totalsGroup;
        return this;
    }

    @ApiModelProperty(value="The reference value to aggregate sales totals in reporting. When not specified, the store field is used (if available).")
    public String getTotalsGroup() {
        return this.totalsGroup;
    }

    public void setTotalsGroup(String totalsGroup) {
        this.totalsGroup = totalsGroup;
    }

    public PaymentRequest3d trustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
        return this;
    }

    @ApiModelProperty(value="Set to true if the payment should be routed to a trusted MID.")
    public Boolean getTrustedShopper() {
        return this.trustedShopper;
    }

    public void setTrustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRequest3d paymentRequest3d = (PaymentRequest3d)o;
        return Objects.equals(this.accountInfo, paymentRequest3d.accountInfo) && Objects.equals(this.additionalAmount, paymentRequest3d.additionalAmount) && Objects.equals(this.additionalData, paymentRequest3d.additionalData) && Objects.equals(this.amount, paymentRequest3d.amount) && Objects.equals(this.applicationInfo, paymentRequest3d.applicationInfo) && Objects.equals(this.billingAddress, paymentRequest3d.billingAddress) && Objects.equals(this.browserInfo, paymentRequest3d.browserInfo) && Objects.equals(this.captureDelayHours, paymentRequest3d.captureDelayHours) && Objects.equals(this.dateOfBirth, paymentRequest3d.dateOfBirth) && Objects.equals(this.dccQuote, paymentRequest3d.dccQuote) && Objects.equals(this.deliveryAddress, paymentRequest3d.deliveryAddress) && Objects.equals(this.deliveryDate, paymentRequest3d.deliveryDate) && Objects.equals(this.deviceFingerprint, paymentRequest3d.deviceFingerprint) && Objects.equals(this.fraudOffset, paymentRequest3d.fraudOffset) && Objects.equals(this.installments, paymentRequest3d.installments) && Objects.equals(this.mcc, paymentRequest3d.mcc) && Objects.equals(this.md, paymentRequest3d.md) && Objects.equals(this.merchantAccount, paymentRequest3d.merchantAccount) && Objects.equals(this.merchantOrderReference, paymentRequest3d.merchantOrderReference) && Objects.equals(this.merchantRiskIndicator, paymentRequest3d.merchantRiskIndicator) && Objects.equals(this.metadata, paymentRequest3d.metadata) && Objects.equals(this.orderReference, paymentRequest3d.orderReference) && Objects.equals(this.paResponse, paymentRequest3d.paResponse) && Objects.equals(this.recurring, paymentRequest3d.recurring) && Objects.equals((Object)this.recurringProcessingModel, (Object)paymentRequest3d.recurringProcessingModel) && Objects.equals(this.reference, paymentRequest3d.reference) && Objects.equals(this.selectedBrand, paymentRequest3d.selectedBrand) && Objects.equals(this.selectedRecurringDetailReference, paymentRequest3d.selectedRecurringDetailReference) && Objects.equals(this.sessionId, paymentRequest3d.sessionId) && Objects.equals(this.shopperEmail, paymentRequest3d.shopperEmail) && Objects.equals(this.shopperIP, paymentRequest3d.shopperIP) && Objects.equals((Object)this.shopperInteraction, (Object)paymentRequest3d.shopperInteraction) && Objects.equals(this.shopperLocale, paymentRequest3d.shopperLocale) && Objects.equals(this.shopperName, paymentRequest3d.shopperName) && Objects.equals(this.shopperReference, paymentRequest3d.shopperReference) && Objects.equals(this.shopperStatement, paymentRequest3d.shopperStatement) && Objects.equals(this.socialSecurityNumber, paymentRequest3d.socialSecurityNumber) && Objects.equals(this.splits, paymentRequest3d.splits) && Objects.equals(this.store, paymentRequest3d.store) && Objects.equals(this.telephoneNumber, paymentRequest3d.telephoneNumber) && Objects.equals(this.threeDS2RequestData, paymentRequest3d.threeDS2RequestData) && Objects.equals(this.threeDSAuthenticationOnly, paymentRequest3d.threeDSAuthenticationOnly) && Objects.equals(this.totalsGroup, paymentRequest3d.totalsGroup) && Objects.equals(this.trustedShopper, paymentRequest3d.trustedShopper);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountInfo, this.additionalAmount, this.additionalData, this.amount, this.applicationInfo, this.billingAddress, this.browserInfo, this.captureDelayHours, this.dateOfBirth, this.dccQuote, this.deliveryAddress, this.deliveryDate, this.deviceFingerprint, this.fraudOffset, this.installments, this.mcc, this.md, this.merchantAccount, this.merchantOrderReference, this.merchantRiskIndicator, this.metadata, this.orderReference, this.paResponse, this.recurring, this.recurringProcessingModel, this.reference, this.selectedBrand, this.selectedRecurringDetailReference, this.sessionId, this.shopperEmail, this.shopperIP, this.shopperInteraction, this.shopperLocale, this.shopperName, this.shopperReference, this.shopperStatement, this.socialSecurityNumber, this.splits, this.store, this.telephoneNumber, this.threeDS2RequestData, this.threeDSAuthenticationOnly, this.totalsGroup, this.trustedShopper});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRequest3d {\n");
        sb.append("    accountInfo: ").append(this.toIndentedString(this.accountInfo)).append("\n");
        sb.append("    additionalAmount: ").append(this.toIndentedString(this.additionalAmount)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    browserInfo: ").append(this.toIndentedString(this.browserInfo)).append("\n");
        sb.append("    captureDelayHours: ").append(this.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    dccQuote: ").append(this.toIndentedString(this.dccQuote)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    deliveryDate: ").append(this.toIndentedString(this.deliveryDate)).append("\n");
        sb.append("    deviceFingerprint: ").append(this.toIndentedString(this.deviceFingerprint)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    installments: ").append(this.toIndentedString(this.installments)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    md: ").append(this.toIndentedString(this.md)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantOrderReference: ").append(this.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    merchantRiskIndicator: ").append(this.toIndentedString(this.merchantRiskIndicator)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    orderReference: ").append(this.toIndentedString(this.orderReference)).append("\n");
        sb.append("    paResponse: ").append(this.toIndentedString(this.paResponse)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    selectedBrand: ").append(this.toIndentedString(this.selectedBrand)).append("\n");
        sb.append("    selectedRecurringDetailReference: ").append(this.toIndentedString(this.selectedRecurringDetailReference)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperIP: ").append(this.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    threeDS2RequestData: ").append(this.toIndentedString(this.threeDS2RequestData)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(this.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        sb.append("    totalsGroup: ").append(this.toIndentedString(this.totalsGroup)).append("\n");
        sb.append("    trustedShopper: ").append(this.toIndentedString(this.trustedShopper)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentRequest3d is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PaymentRequest3d` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_INFO) != null) {
            AccountInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_INFO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_APPLICATION_INFO) != null) {
            ApplicationInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_APPLICATION_INFO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BROWSER_INFO) != null) {
            BrowserInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BROWSER_INFO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DCC_QUOTE) != null) {
            ForexQuote.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DCC_QUOTE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DELIVERY_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DELIVERY_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_FINGERPRINT) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_FINGERPRINT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `deviceFingerprint` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_FINGERPRINT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INSTALLMENTS) != null) {
            Installments.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INSTALLMENTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_MCC) != null && !jsonObj.get(SERIALIZED_NAME_MCC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MCC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MD) != null && !jsonObj.get(SERIALIZED_NAME_MD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `md` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantOrderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MERCHANT_RISK_INDICATOR) != null) {
            MerchantRiskIndicator.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MERCHANT_RISK_INDICATOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `orderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PA_RESPONSE) != null && !jsonObj.get(SERIALIZED_NAME_PA_RESPONSE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `paResponse` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PA_RESPONSE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RECURRING) != null) {
            Recurring.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RECURRING));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `recurringProcessingModel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).toString()));
            }
            RecurringProcessingModelEnum.fromValue(jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTED_BRAND) != null && !jsonObj.get(SERIALIZED_NAME_SELECTED_BRAND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `selectedBrand` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECTED_BRAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTED_RECURRING_DETAIL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SELECTED_RECURRING_DETAIL_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `selectedRecurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECTED_RECURRING_DETAIL_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SESSION_ID) != null && !jsonObj.get(SERIALIZED_NAME_SESSION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sessionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SESSION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_I_P) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_I_P).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperIP` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_I_P).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `shopperInteraction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).toString()));
            }
            ShopperInteractionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperLocale` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperStatement` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `socialSecurityNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).toString()));
        }
        JsonArray jsonArraysplits = jsonObj.getAsJsonArray(SERIALIZED_NAME_SPLITS);
        if (jsonArraysplits != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SPLITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `splits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPLITS).toString()));
            }
            for (int i = 0; i < jsonArraysplits.size(); ++i) {
                Split.validateJsonObject(jsonArraysplits.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE) != null && !jsonObj.get(SERIALIZED_NAME_STORE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `telephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S2_REQUEST_DATA) != null) {
            ThreeDS2RequestData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S2_REQUEST_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOTALS_GROUP) != null && !jsonObj.get(SERIALIZED_NAME_TOTALS_GROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `totalsGroup` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOTALS_GROUP).toString()));
        }
    }

    public static PaymentRequest3d fromJson(String jsonString) throws IOException {
        return (PaymentRequest3d)JSON.getGson().fromJson(jsonString, PaymentRequest3d.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_INFO);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_APPLICATION_INFO);
        openapiFields.add(SERIALIZED_NAME_BILLING_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_BROWSER_INFO);
        openapiFields.add(SERIALIZED_NAME_CAPTURE_DELAY_HOURS);
        openapiFields.add(SERIALIZED_NAME_DATE_OF_BIRTH);
        openapiFields.add(SERIALIZED_NAME_DCC_QUOTE);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_DATE);
        openapiFields.add(SERIALIZED_NAME_DEVICE_FINGERPRINT);
        openapiFields.add(SERIALIZED_NAME_FRAUD_OFFSET);
        openapiFields.add(SERIALIZED_NAME_INSTALLMENTS);
        openapiFields.add(SERIALIZED_NAME_MCC);
        openapiFields.add(SERIALIZED_NAME_MD);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_RISK_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_ORDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_PA_RESPONSE);
        openapiFields.add(SERIALIZED_NAME_RECURRING);
        openapiFields.add(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SELECTED_BRAND);
        openapiFields.add(SERIALIZED_NAME_SELECTED_RECURRING_DETAIL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SESSION_ID);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_EMAIL);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_I_P);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_INTERACTION);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_LOCALE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_NAME);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_STATEMENT);
        openapiFields.add(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER);
        openapiFields.add(SERIALIZED_NAME_SPLITS);
        openapiFields.add(SERIALIZED_NAME_STORE);
        openapiFields.add(SERIALIZED_NAME_TELEPHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S2_REQUEST_DATA);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_AUTHENTICATION_ONLY);
        openapiFields.add(SERIALIZED_NAME_TOTALS_GROUP);
        openapiFields.add(SERIALIZED_NAME_TRUSTED_SHOPPER);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MD);
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_PA_RESPONSE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentRequest3d.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentRequest3d.class));
            return new TypeAdapter<PaymentRequest3d>(){

                public void write(JsonWriter out, PaymentRequest3d value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentRequest3d read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentRequest3d.validateJsonObject(jsonObj);
                    return (PaymentRequest3d)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto"),
        POS("POS");

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ShopperInteractionEnum> {
            public void write(JsonWriter jsonWriter, ShopperInteractionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShopperInteractionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShopperInteractionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecurringProcessingModelEnum {
        CARDONFILE("CardOnFile"),
        SUBSCRIPTION("Subscription"),
        UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RecurringProcessingModelEnum> {
            public void write(JsonWriter jsonWriter, RecurringProcessingModelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RecurringProcessingModelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecurringProcessingModelEnum.fromValue(value);
            }
        }
    }
}

