/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.StoreLocation;
import com.adyen.model.management.StoreSplitConfiguration;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StoreCreationWithMerchantCodeRequest {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private StoreLocation address;
    public static final String SERIALIZED_NAME_BUSINESS_LINE_IDS = "businessLineIds";
    @SerializedName(value="businessLineIds")
    private List<String> businessLineIds = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EXTERNAL_REFERENCE_ID = "externalReferenceId";
    @SerializedName(value="externalReferenceId")
    private String externalReferenceId;
    public static final String SERIALIZED_NAME_MERCHANT_ID = "merchantId";
    @SerializedName(value="merchantId")
    private String merchantId;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phoneNumber";
    @SerializedName(value="phoneNumber")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SHOPPER_STATEMENT = "shopperStatement";
    @SerializedName(value="shopperStatement")
    private String shopperStatement;
    public static final String SERIALIZED_NAME_SPLIT_CONFIGURATION = "splitConfiguration";
    @SerializedName(value="splitConfiguration")
    private StoreSplitConfiguration splitConfiguration;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StoreCreationWithMerchantCodeRequest address(StoreLocation address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public StoreLocation getAddress() {
        return this.address;
    }

    public void setAddress(StoreLocation address) {
        this.address = address;
    }

    public StoreCreationWithMerchantCodeRequest businessLineIds(List<String> businessLineIds) {
        this.businessLineIds = businessLineIds;
        return this;
    }

    public StoreCreationWithMerchantCodeRequest addBusinessLineIdsItem(String businessLineIdsItem) {
        if (this.businessLineIds == null) {
            this.businessLineIds = new ArrayList<String>();
        }
        this.businessLineIds.add(businessLineIdsItem);
        return this;
    }

    @ApiModelProperty(value="The unique identifiers of the [business lines](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/businesslines__resParam_id) that the store is associated with. If not specified, the business line of the merchant account is used. Required when there are multiple business lines under the merchant account.")
    public List<String> getBusinessLineIds() {
        return this.businessLineIds;
    }

    public void setBusinessLineIds(List<String> businessLineIds) {
        this.businessLineIds = businessLineIds;
    }

    public StoreCreationWithMerchantCodeRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="Your description of the store.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StoreCreationWithMerchantCodeRequest externalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    @ApiModelProperty(value="When using the Zip payment method: The location ID that Zip has assigned to your store.")
    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public StoreCreationWithMerchantCodeRequest merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the merchant account that the store belongs to.")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public StoreCreationWithMerchantCodeRequest phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The phone number of the store, including '+' and country code.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public StoreCreationWithMerchantCodeRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference to recognize the store by. Also known as the store code.  Allowed characters: Lowercase and uppercase letters without diacritics, numbers 0 through 9, hyphen (-), and underscore (_).")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public StoreCreationWithMerchantCodeRequest shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @ApiModelProperty(required=true, value="The store name to be shown on the shopper's bank or credit card statement and on the shopper receipt. Maximum length: 22 characters; can't be all numbers.")
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public StoreCreationWithMerchantCodeRequest splitConfiguration(StoreSplitConfiguration splitConfiguration) {
        this.splitConfiguration = splitConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    public StoreSplitConfiguration getSplitConfiguration() {
        return this.splitConfiguration;
    }

    public void setSplitConfiguration(StoreSplitConfiguration splitConfiguration) {
        this.splitConfiguration = splitConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreCreationWithMerchantCodeRequest storeCreationWithMerchantCodeRequest = (StoreCreationWithMerchantCodeRequest)o;
        return Objects.equals(this.address, storeCreationWithMerchantCodeRequest.address) && Objects.equals(this.businessLineIds, storeCreationWithMerchantCodeRequest.businessLineIds) && Objects.equals(this.description, storeCreationWithMerchantCodeRequest.description) && Objects.equals(this.externalReferenceId, storeCreationWithMerchantCodeRequest.externalReferenceId) && Objects.equals(this.merchantId, storeCreationWithMerchantCodeRequest.merchantId) && Objects.equals(this.phoneNumber, storeCreationWithMerchantCodeRequest.phoneNumber) && Objects.equals(this.reference, storeCreationWithMerchantCodeRequest.reference) && Objects.equals(this.shopperStatement, storeCreationWithMerchantCodeRequest.shopperStatement) && Objects.equals(this.splitConfiguration, storeCreationWithMerchantCodeRequest.splitConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.businessLineIds, this.description, this.externalReferenceId, this.merchantId, this.phoneNumber, this.reference, this.shopperStatement, this.splitConfiguration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoreCreationWithMerchantCodeRequest {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    businessLineIds: ").append(this.toIndentedString(this.businessLineIds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    externalReferenceId: ").append(this.toIndentedString(this.externalReferenceId)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    splitConfiguration: ").append(this.toIndentedString(this.splitConfiguration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StoreCreationWithMerchantCodeRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StoreCreationWithMerchantCodeRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS) != null) {
            StoreLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_IDS) != null && !jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `businessLineIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `externalReferenceId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ID) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperStatement` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SPLIT_CONFIGURATION) != null) {
            StoreSplitConfiguration.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SPLIT_CONFIGURATION));
        }
    }

    public static StoreCreationWithMerchantCodeRequest fromJson(String jsonString) throws IOException {
        return (StoreCreationWithMerchantCodeRequest)JSON.getGson().fromJson(jsonString, StoreCreationWithMerchantCodeRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_BUSINESS_LINE_IDS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ID);
        openapiFields.add(SERIALIZED_NAME_PHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_STATEMENT);
        openapiFields.add(SERIALIZED_NAME_SPLIT_CONFIGURATION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PHONE_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_SHOPPER_STATEMENT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StoreCreationWithMerchantCodeRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StoreCreationWithMerchantCodeRequest.class));
            return new TypeAdapter<StoreCreationWithMerchantCodeRequest>(){

                public void write(JsonWriter out, StoreCreationWithMerchantCodeRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StoreCreationWithMerchantCodeRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StoreCreationWithMerchantCodeRequest.validateJsonObject(jsonObj);
                    return (StoreCreationWithMerchantCodeRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

