/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.Currency;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ModelConfiguration {
    public static final String SERIALIZED_NAME_BRAND = "brand";
    @SerializedName(value="brand")
    private String brand;
    public static final String SERIALIZED_NAME_CURRENCIES = "currencies";
    @SerializedName(value="currencies")
    private List<Currency> currencies = new ArrayList<Currency>();
    public static final String SERIALIZED_NAME_SOURCES = "sources";
    @SerializedName(value="sources")
    private List<String> sources = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ModelConfiguration brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(required=true, value="Payment method, like **eftpos_australia** or **mc**. See the [possible values](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api). ")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public ModelConfiguration currencies(List<Currency> currencies) {
        this.currencies = currencies;
        return this;
    }

    public ModelConfiguration addCurrenciesItem(Currency currenciesItem) {
        this.currencies.add(currenciesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Currency, and surcharge percentage or amount.")
    public List<Currency> getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(List<Currency> currencies) {
        this.currencies = currencies;
    }

    public ModelConfiguration sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public ModelConfiguration addSourcesItem(String sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    @ApiModelProperty(value="Funding source. Possible values: * **Credit** * **Debit**")
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelConfiguration configuration = (ModelConfiguration)o;
        return Objects.equals(this.brand, configuration.brand) && Objects.equals(this.currencies, configuration.currencies) && Objects.equals(this.sources, configuration.sources);
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.currencies, this.sources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModelConfiguration {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    currencies: ").append(this.toIndentedString(this.currencies)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ModelConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ModelConfiguration` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BRAND) != null && !jsonObj.get(SERIALIZED_NAME_BRAND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `brand` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BRAND).toString()));
        }
        JsonArray jsonArraycurrencies = jsonObj.getAsJsonArray(SERIALIZED_NAME_CURRENCIES);
        if (jsonArraycurrencies != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CURRENCIES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `currencies` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCIES).toString()));
            }
            for (int i = 0; i < jsonArraycurrencies.size(); ++i) {
                Currency.validateJsonObject(jsonArraycurrencies.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCES) != null && !jsonObj.get(SERIALIZED_NAME_SOURCES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `sources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCES).toString()));
        }
    }

    public static ModelConfiguration fromJson(String jsonString) throws IOException {
        return (ModelConfiguration)JSON.getGson().fromJson(jsonString, ModelConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BRAND);
        openapiFields.add(SERIALIZED_NAME_CURRENCIES);
        openapiFields.add(SERIALIZED_NAME_SOURCES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BRAND);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENCIES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ModelConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ModelConfiguration.class));
            return new TypeAdapter<ModelConfiguration>(){

                public void write(JsonWriter out, ModelConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ModelConfiguration read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ModelConfiguration.validateJsonObject(jsonObj);
                    return (ModelConfiguration)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

