/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExternalTerminalAction {
    public static final String SERIALIZED_NAME_ACTION_TYPE = "actionType";
    @SerializedName(value="actionType")
    private String actionType;
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    private String config;
    public static final String SERIALIZED_NAME_CONFIRMED_AT = "confirmedAt";
    @SerializedName(value="confirmedAt")
    private OffsetDateTime confirmedAt;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_RESULT = "result";
    @SerializedName(value="result")
    private String result;
    public static final String SERIALIZED_NAME_SCHEDULED_AT = "scheduledAt";
    @SerializedName(value="scheduledAt")
    private OffsetDateTime scheduledAt;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_TERMINAL_ID = "terminalId";
    @SerializedName(value="terminalId")
    private String terminalId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ExternalTerminalAction actionType(String actionType) {
        this.actionType = actionType;
        return this;
    }

    @ApiModelProperty(value="The type of terminal action: **InstallAndroidApp**, **UninstallAndroidApp**, **InstallAndroidCertificate**, or **UninstallAndroidCertificate**.")
    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public ExternalTerminalAction config(String config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(value="Technical information about the terminal action.")
    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public ExternalTerminalAction confirmedAt(OffsetDateTime confirmedAt) {
        this.confirmedAt = confirmedAt;
        return this;
    }

    @ApiModelProperty(value="The date and time when the action was carried out.")
    public OffsetDateTime getConfirmedAt() {
        return this.confirmedAt;
    }

    public void setConfirmedAt(OffsetDateTime confirmedAt) {
        this.confirmedAt = confirmedAt;
    }

    public ExternalTerminalAction id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the terminal action.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExternalTerminalAction result(String result) {
        this.result = result;
        return this;
    }

    @ApiModelProperty(value="The result message for the action.")
    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public ExternalTerminalAction scheduledAt(OffsetDateTime scheduledAt) {
        this.scheduledAt = scheduledAt;
        return this;
    }

    @ApiModelProperty(value="The date and time when the action was scheduled to happen.")
    public OffsetDateTime getScheduledAt() {
        return this.scheduledAt;
    }

    public void setScheduledAt(OffsetDateTime scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public ExternalTerminalAction status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the terminal action: **pending**, **successful**, **failed**, **cancelled**, or **tryLater**.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ExternalTerminalAction terminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the terminal that the action applies to.")
    public String getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTerminalAction externalTerminalAction = (ExternalTerminalAction)o;
        return Objects.equals(this.actionType, externalTerminalAction.actionType) && Objects.equals(this.config, externalTerminalAction.config) && Objects.equals(this.confirmedAt, externalTerminalAction.confirmedAt) && Objects.equals(this.id, externalTerminalAction.id) && Objects.equals(this.result, externalTerminalAction.result) && Objects.equals(this.scheduledAt, externalTerminalAction.scheduledAt) && Objects.equals(this.status, externalTerminalAction.status) && Objects.equals(this.terminalId, externalTerminalAction.terminalId);
    }

    public int hashCode() {
        return Objects.hash(this.actionType, this.config, this.confirmedAt, this.id, this.result, this.scheduledAt, this.status, this.terminalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalTerminalAction {\n");
        sb.append("    actionType: ").append(this.toIndentedString(this.actionType)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    confirmedAt: ").append(this.toIndentedString(this.confirmedAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("    scheduledAt: ").append(this.toIndentedString(this.scheduledAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    terminalId: ").append(this.toIndentedString(this.terminalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ExternalTerminalAction is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ExternalTerminalAction` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTION_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ACTION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `actionType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTION_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `config` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIG).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESULT) != null && !jsonObj.get(SERIALIZED_NAME_RESULT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `result` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMINAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_TERMINAL_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `terminalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TERMINAL_ID).toString()));
        }
    }

    public static ExternalTerminalAction fromJson(String jsonString) throws IOException {
        return (ExternalTerminalAction)JSON.getGson().fromJson(jsonString, ExternalTerminalAction.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTION_TYPE);
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_CONFIRMED_AT);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_RESULT);
        openapiFields.add(SERIALIZED_NAME_SCHEDULED_AT);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TERMINAL_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ExternalTerminalAction.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ExternalTerminalAction.class));
            return new TypeAdapter<ExternalTerminalAction>(){

                public void write(JsonWriter out, ExternalTerminalAction value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ExternalTerminalAction read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ExternalTerminalAction.validateJsonObject(jsonObj);
                    return (ExternalTerminalAction)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

