/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.BankAccountInfo;
import com.adyen.model.legalentitymanagement.DocumentReference;
import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TransferInstrument {
    public static final String SERIALIZED_NAME_BANK_ACCOUNT = "bankAccount";
    @SerializedName(value="bankAccount")
    private BankAccountInfo bankAccount;
    public static final String SERIALIZED_NAME_DOCUMENT_DETAILS = "documentDetails";
    @SerializedName(value="documentDetails")
    private List<DocumentReference> documentDetails = null;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_LEGAL_ENTITY_ID = "legalEntityId";
    @SerializedName(value="legalEntityId")
    private String legalEntityId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TransferInstrument() {
    }

    public TransferInstrument(String id) {
        this();
        this.id = id;
    }

    public TransferInstrument bankAccount(BankAccountInfo bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankAccountInfo getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(BankAccountInfo bankAccount) {
        this.bankAccount = bankAccount;
    }

    public TransferInstrument documentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
        return this;
    }

    public TransferInstrument addDocumentDetailsItem(DocumentReference documentDetailsItem) {
        if (this.documentDetails == null) {
            this.documentDetails = new ArrayList<DocumentReference>();
        }
        this.documentDetails.add(documentDetailsItem);
        return this;
    }

    @ApiModelProperty(value="List of documents uploaded for the transfer instrument.")
    public List<DocumentReference> getDocumentDetails() {
        return this.documentDetails;
    }

    public void setDocumentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the transfer instrument.")
    public String getId() {
        return this.id;
    }

    public TransferInstrument legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [legal entity](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id) that owns the transfer instrument.")
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public TransferInstrument type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of transfer instrument.  Possible value: **bankAccount**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferInstrument transferInstrument = (TransferInstrument)o;
        return Objects.equals(this.bankAccount, transferInstrument.bankAccount) && Objects.equals(this.documentDetails, transferInstrument.documentDetails) && Objects.equals(this.id, transferInstrument.id) && Objects.equals(this.legalEntityId, transferInstrument.legalEntityId) && Objects.equals((Object)this.type, (Object)transferInstrument.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bankAccount, this.documentDetails, this.id, this.legalEntityId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferInstrument {\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    documentDetails: ").append(this.toIndentedString(this.documentDetails)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraydocumentDetails;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransferInstrument is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TransferInstrument` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BANK_ACCOUNT) != null) {
            BankAccountInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BANK_ACCOUNT));
        }
        if ((jsonArraydocumentDetails = jsonObj.getAsJsonArray(SERIALIZED_NAME_DOCUMENT_DETAILS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DOCUMENT_DETAILS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `documentDetails` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENT_DETAILS).toString()));
            }
            for (int i = 0; i < jsonArraydocumentDetails.size(); ++i) {
                DocumentReference.validateJsonObject(jsonArraydocumentDetails.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID) != null && !jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `legalEntityId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static TransferInstrument fromJson(String jsonString) throws IOException {
        return (TransferInstrument)JSON.getGson().fromJson(jsonString, TransferInstrument.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BANK_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_DETAILS);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_LEGAL_ENTITY_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BANK_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_LEGAL_ENTITY_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransferInstrument.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransferInstrument.class));
            return new TypeAdapter<TransferInstrument>(){

                public void write(JsonWriter out, TransferInstrument value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransferInstrument read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransferInstrument.validateJsonObject(jsonObj);
                    return (TransferInstrument)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BANKACCOUNT("bankAccount"),
        RECURRINGDETAIL("recurringDetail");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

