/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Address;
import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SoleProprietorship {
    public static final String SERIALIZED_NAME_COUNTRY_OF_GOVERNING_LAW = "countryOfGoverningLaw";
    @SerializedName(value="countryOfGoverningLaw")
    private String countryOfGoverningLaw;
    public static final String SERIALIZED_NAME_DOING_BUSINESS_AS = "doingBusinessAs";
    @SerializedName(value="doingBusinessAs")
    private String doingBusinessAs;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PRINCIPAL_PLACE_OF_BUSINESS = "principalPlaceOfBusiness";
    @SerializedName(value="principalPlaceOfBusiness")
    private Address principalPlaceOfBusiness;
    public static final String SERIALIZED_NAME_REGISTERED_ADDRESS = "registeredAddress";
    @SerializedName(value="registeredAddress")
    private Address registeredAddress;
    public static final String SERIALIZED_NAME_REGISTRATION_NUMBER = "registrationNumber";
    @SerializedName(value="registrationNumber")
    private String registrationNumber;
    public static final String SERIALIZED_NAME_VAT_ABSENCE_REASON = "vatAbsenceReason";
    @SerializedName(value="vatAbsenceReason")
    private VatAbsenceReasonEnum vatAbsenceReason;
    public static final String SERIALIZED_NAME_VAT_NUMBER = "vatNumber";
    @SerializedName(value="vatNumber")
    private String vatNumber;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SoleProprietorship countryOfGoverningLaw(String countryOfGoverningLaw) {
        this.countryOfGoverningLaw = countryOfGoverningLaw;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the governing country.")
    public String getCountryOfGoverningLaw() {
        return this.countryOfGoverningLaw;
    }

    public void setCountryOfGoverningLaw(String countryOfGoverningLaw) {
        this.countryOfGoverningLaw = countryOfGoverningLaw;
    }

    public SoleProprietorship doingBusinessAs(String doingBusinessAs) {
        this.doingBusinessAs = doingBusinessAs;
        return this;
    }

    @ApiModelProperty(value="The registered name, if different from the `name`.")
    public String getDoingBusinessAs() {
        return this.doingBusinessAs;
    }

    public void setDoingBusinessAs(String doingBusinessAs) {
        this.doingBusinessAs = doingBusinessAs;
    }

    public SoleProprietorship name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The legal name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SoleProprietorship principalPlaceOfBusiness(Address principalPlaceOfBusiness) {
        this.principalPlaceOfBusiness = principalPlaceOfBusiness;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getPrincipalPlaceOfBusiness() {
        return this.principalPlaceOfBusiness;
    }

    public void setPrincipalPlaceOfBusiness(Address principalPlaceOfBusiness) {
        this.principalPlaceOfBusiness = principalPlaceOfBusiness;
    }

    public SoleProprietorship registeredAddress(Address registeredAddress) {
        this.registeredAddress = registeredAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getRegisteredAddress() {
        return this.registeredAddress;
    }

    public void setRegisteredAddress(Address registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public SoleProprietorship registrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
        return this;
    }

    @ApiModelProperty(value="The registration number.")
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public SoleProprietorship vatAbsenceReason(VatAbsenceReasonEnum vatAbsenceReason) {
        this.vatAbsenceReason = vatAbsenceReason;
        return this;
    }

    @ApiModelProperty(value="The reason for not providing a VAT number.  Possible values: **industryExemption**, **belowTaxThreshold**.")
    public VatAbsenceReasonEnum getVatAbsenceReason() {
        return this.vatAbsenceReason;
    }

    public void setVatAbsenceReason(VatAbsenceReasonEnum vatAbsenceReason) {
        this.vatAbsenceReason = vatAbsenceReason;
    }

    public SoleProprietorship vatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
        return this;
    }

    @ApiModelProperty(value="The VAT number.")
    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoleProprietorship soleProprietorship = (SoleProprietorship)o;
        return Objects.equals(this.countryOfGoverningLaw, soleProprietorship.countryOfGoverningLaw) && Objects.equals(this.doingBusinessAs, soleProprietorship.doingBusinessAs) && Objects.equals(this.name, soleProprietorship.name) && Objects.equals(this.principalPlaceOfBusiness, soleProprietorship.principalPlaceOfBusiness) && Objects.equals(this.registeredAddress, soleProprietorship.registeredAddress) && Objects.equals(this.registrationNumber, soleProprietorship.registrationNumber) && Objects.equals((Object)this.vatAbsenceReason, (Object)soleProprietorship.vatAbsenceReason) && Objects.equals(this.vatNumber, soleProprietorship.vatNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.countryOfGoverningLaw, this.doingBusinessAs, this.name, this.principalPlaceOfBusiness, this.registeredAddress, this.registrationNumber, this.vatAbsenceReason, this.vatNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SoleProprietorship {\n");
        sb.append("    countryOfGoverningLaw: ").append(this.toIndentedString(this.countryOfGoverningLaw)).append("\n");
        sb.append("    doingBusinessAs: ").append(this.toIndentedString(this.doingBusinessAs)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    principalPlaceOfBusiness: ").append(this.toIndentedString(this.principalPlaceOfBusiness)).append("\n");
        sb.append("    registeredAddress: ").append(this.toIndentedString(this.registeredAddress)).append("\n");
        sb.append("    registrationNumber: ").append(this.toIndentedString(this.registrationNumber)).append("\n");
        sb.append("    vatAbsenceReason: ").append(this.toIndentedString((Object)this.vatAbsenceReason)).append("\n");
        sb.append("    vatNumber: ").append(this.toIndentedString(this.vatNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SoleProprietorship is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SoleProprietorship` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_GOVERNING_LAW) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_GOVERNING_LAW).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `countryOfGoverningLaw` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_GOVERNING_LAW).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOING_BUSINESS_AS) != null && !jsonObj.get(SERIALIZED_NAME_DOING_BUSINESS_AS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `doingBusinessAs` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOING_BUSINESS_AS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PRINCIPAL_PLACE_OF_BUSINESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PRINCIPAL_PLACE_OF_BUSINESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_REGISTERED_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_REGISTERED_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_REGISTRATION_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_REGISTRATION_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `registrationNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REGISTRATION_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VAT_ABSENCE_REASON) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VAT_ABSENCE_REASON).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `vatAbsenceReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VAT_ABSENCE_REASON).toString()));
            }
            VatAbsenceReasonEnum.fromValue(jsonObj.get(SERIALIZED_NAME_VAT_ABSENCE_REASON).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_VAT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_VAT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `vatNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VAT_NUMBER).toString()));
        }
    }

    public static SoleProprietorship fromJson(String jsonString) throws IOException {
        return (SoleProprietorship)JSON.getGson().fromJson(jsonString, SoleProprietorship.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COUNTRY_OF_GOVERNING_LAW);
        openapiFields.add(SERIALIZED_NAME_DOING_BUSINESS_AS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PRINCIPAL_PLACE_OF_BUSINESS);
        openapiFields.add(SERIALIZED_NAME_REGISTERED_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_REGISTRATION_NUMBER);
        openapiFields.add(SERIALIZED_NAME_VAT_ABSENCE_REASON);
        openapiFields.add(SERIALIZED_NAME_VAT_NUMBER);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTRY_OF_GOVERNING_LAW);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_REGISTERED_ADDRESS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SoleProprietorship.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SoleProprietorship.class));
            return new TypeAdapter<SoleProprietorship>(){

                public void write(JsonWriter out, SoleProprietorship value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SoleProprietorship read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SoleProprietorship.validateJsonObject(jsonObj);
                    return (SoleProprietorship)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VatAbsenceReasonEnum {
        INDUSTRYEXEMPTION("industryExemption"),
        BELOWTAXTHRESHOLD("belowTaxThreshold");

        private String value;

        private VatAbsenceReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VatAbsenceReasonEnum fromValue(String value) {
            for (VatAbsenceReasonEnum b : VatAbsenceReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VatAbsenceReasonEnum> {
            public void write(JsonWriter jsonWriter, VatAbsenceReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VatAbsenceReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VatAbsenceReasonEnum.fromValue(value);
            }
        }
    }
}

