/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BankAccountInfo {
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "accountNumber";
    @SerializedName(value="accountNumber")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "accountType";
    @SerializedName(value="accountType")
    private String accountType;
    public static final String SERIALIZED_NAME_BANK_BIC_SWIFT = "bankBicSwift";
    @SerializedName(value="bankBicSwift")
    private String bankBicSwift;
    public static final String SERIALIZED_NAME_BANK_CITY = "bankCity";
    @SerializedName(value="bankCity")
    private String bankCity;
    public static final String SERIALIZED_NAME_BANK_CODE = "bankCode";
    @SerializedName(value="bankCode")
    private String bankCode;
    public static final String SERIALIZED_NAME_BANK_NAME = "bankName";
    @SerializedName(value="bankName")
    private String bankName;
    public static final String SERIALIZED_NAME_BRANCH_CODE = "branchCode";
    @SerializedName(value="branchCode")
    private String branchCode;
    public static final String SERIALIZED_NAME_CHECK_CODE = "checkCode";
    @SerializedName(value="checkCode")
    private String checkCode;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "countryCode";
    @SerializedName(value="countryCode")
    private String countryCode;
    public static final String SERIALIZED_NAME_CURRENCY_CODE = "currencyCode";
    @SerializedName(value="currencyCode")
    private String currencyCode;
    public static final String SERIALIZED_NAME_IBAN = "iban";
    @SerializedName(value="iban")
    private String iban;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BankAccountInfo accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(value="The bank account number (without separators).   When this is provided, the `branchCode` is also required.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public BankAccountInfo accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The type of bank account.")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public BankAccountInfo bankBicSwift(String bankBicSwift) {
        this.bankBicSwift = bankBicSwift;
        return this;
    }

    @ApiModelProperty(value="The bank's BIC or SWIFT code.")
    public String getBankBicSwift() {
        return this.bankBicSwift;
    }

    public void setBankBicSwift(String bankBicSwift) {
        this.bankBicSwift = bankBicSwift;
    }

    public BankAccountInfo bankCity(String bankCity) {
        this.bankCity = bankCity;
        return this;
    }

    @ApiModelProperty(value="The city where the bank is located.")
    public String getBankCity() {
        return this.bankCity;
    }

    public void setBankCity(String bankCity) {
        this.bankCity = bankCity;
    }

    public BankAccountInfo bankCode(String bankCode) {
        this.bankCode = bankCode;
        return this;
    }

    @ApiModelProperty(value="The bank code of the banking institution with which the bank account is registered.")
    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public BankAccountInfo bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @ApiModelProperty(value="The name of the banking institution where the bank account is held.")
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public BankAccountInfo branchCode(String branchCode) {
        this.branchCode = branchCode;
        return this;
    }

    @ApiModelProperty(value="The branch code of the branch under which the bank account is registered.  Required when you provide an `accountNumber`.   In the following countries, this value corresponds to:   * United States: routing number * United Kingdom: sort code * Germany: Bankleitzahl")
    public String getBranchCode() {
        return this.branchCode;
    }

    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    public BankAccountInfo checkCode(String checkCode) {
        this.checkCode = checkCode;
        return this;
    }

    @ApiModelProperty(value="The check code of the bank account.")
    public String getCheckCode() {
        return this.checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public BankAccountInfo countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the bank account is registered. For example, **NL**.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public BankAccountInfo currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The account's three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes). For example, **EUR**.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BankAccountInfo iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(value="The international bank account number as defined in the [ISO-13616](https://www.iso.org/standard/81090.html) standard.")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankAccountInfo bankAccountInfo = (BankAccountInfo)o;
        return Objects.equals(this.accountNumber, bankAccountInfo.accountNumber) && Objects.equals(this.accountType, bankAccountInfo.accountType) && Objects.equals(this.bankBicSwift, bankAccountInfo.bankBicSwift) && Objects.equals(this.bankCity, bankAccountInfo.bankCity) && Objects.equals(this.bankCode, bankAccountInfo.bankCode) && Objects.equals(this.bankName, bankAccountInfo.bankName) && Objects.equals(this.branchCode, bankAccountInfo.branchCode) && Objects.equals(this.checkCode, bankAccountInfo.checkCode) && Objects.equals(this.countryCode, bankAccountInfo.countryCode) && Objects.equals(this.currencyCode, bankAccountInfo.currencyCode) && Objects.equals(this.iban, bankAccountInfo.iban);
    }

    public int hashCode() {
        return Objects.hash(this.accountNumber, this.accountType, this.bankBicSwift, this.bankCity, this.bankCode, this.bankName, this.branchCode, this.checkCode, this.countryCode, this.currencyCode, this.iban);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankAccountInfo {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    bankBicSwift: ").append(this.toIndentedString(this.bankBicSwift)).append("\n");
        sb.append("    bankCity: ").append(this.toIndentedString(this.bankCity)).append("\n");
        sb.append("    bankCode: ").append(this.toIndentedString(this.bankCode)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    branchCode: ").append(this.toIndentedString(this.branchCode)).append("\n");
        sb.append("    checkCode: ").append(this.toIndentedString(this.checkCode)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BankAccountInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BankAccountInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accountNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accountType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_BIC_SWIFT) != null && !jsonObj.get(SERIALIZED_NAME_BANK_BIC_SWIFT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bankBicSwift` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_BIC_SWIFT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_CITY) != null && !jsonObj.get(SERIALIZED_NAME_BANK_CITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bankCity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_CODE) != null && !jsonObj.get(SERIALIZED_NAME_BANK_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bankCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_NAME) != null && !jsonObj.get(SERIALIZED_NAME_BANK_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bankName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BRANCH_CODE) != null && !jsonObj.get(SERIALIZED_NAME_BRANCH_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `branchCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BRANCH_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHECK_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CHECK_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `checkCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHECK_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `countryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currencyCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IBAN) != null && !jsonObj.get(SERIALIZED_NAME_IBAN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `iban` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IBAN).toString()));
        }
    }

    public static BankAccountInfo fromJson(String jsonString) throws IOException {
        return (BankAccountInfo)JSON.getGson().fromJson(jsonString, BankAccountInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_BANK_BIC_SWIFT);
        openapiFields.add(SERIALIZED_NAME_BANK_CITY);
        openapiFields.add(SERIALIZED_NAME_BANK_CODE);
        openapiFields.add(SERIALIZED_NAME_BANK_NAME);
        openapiFields.add(SERIALIZED_NAME_BRANCH_CODE);
        openapiFields.add(SERIALIZED_NAME_CHECK_CODE);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_CURRENCY_CODE);
        openapiFields.add(SERIALIZED_NAME_IBAN);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTRY_CODE);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENCY_CODE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BankAccountInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BankAccountInfo.class));
            return new TypeAdapter<BankAccountInfo>(){

                public void write(JsonWriter out, BankAccountInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BankAccountInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BankAccountInfo.validateJsonObject(jsonObj);
                    return (BankAccountInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

