/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Avs;
import com.adyen.model.checkout.InstallmentsNumber;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.ShopperInput;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ModelConfiguration {
    public static final String SERIALIZED_NAME_AVS = "avs";
    @SerializedName(value="avs")
    private Avs avs;
    public static final String SERIALIZED_NAME_CARD_HOLDER_NAME = "cardHolderName";
    @SerializedName(value="cardHolderName")
    private CardHolderNameEnum cardHolderName;
    public static final String SERIALIZED_NAME_INSTALLMENTS = "installments";
    @SerializedName(value="installments")
    private InstallmentsNumber installments;
    public static final String SERIALIZED_NAME_SHOPPER_INPUT = "shopperInput";
    @SerializedName(value="shopperInput")
    private ShopperInput shopperInput;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ModelConfiguration avs(Avs avs) {
        this.avs = avs;
        return this;
    }

    @ApiModelProperty(value="")
    public Avs getAvs() {
        return this.avs;
    }

    public void setAvs(Avs avs) {
        this.avs = avs;
    }

    public ModelConfiguration cardHolderName(CardHolderNameEnum cardHolderName) {
        this.cardHolderName = cardHolderName;
        return this;
    }

    @ApiModelProperty(value="Determines whether the cardholder name should be provided or not.  Permitted values: * NONE * OPTIONAL * REQUIRED")
    public CardHolderNameEnum getCardHolderName() {
        return this.cardHolderName;
    }

    public void setCardHolderName(CardHolderNameEnum cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public ModelConfiguration installments(InstallmentsNumber installments) {
        this.installments = installments;
        return this;
    }

    @ApiModelProperty(value="")
    public InstallmentsNumber getInstallments() {
        return this.installments;
    }

    public void setInstallments(InstallmentsNumber installments) {
        this.installments = installments;
    }

    public ModelConfiguration shopperInput(ShopperInput shopperInput) {
        this.shopperInput = shopperInput;
        return this;
    }

    @ApiModelProperty(value="")
    public ShopperInput getShopperInput() {
        return this.shopperInput;
    }

    public void setShopperInput(ShopperInput shopperInput) {
        this.shopperInput = shopperInput;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelConfiguration configuration = (ModelConfiguration)o;
        return Objects.equals(this.avs, configuration.avs) && Objects.equals((Object)this.cardHolderName, (Object)configuration.cardHolderName) && Objects.equals(this.installments, configuration.installments) && Objects.equals(this.shopperInput, configuration.shopperInput);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.avs, this.cardHolderName, this.installments, this.shopperInput});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModelConfiguration {\n");
        sb.append("    avs: ").append(this.toIndentedString(this.avs)).append("\n");
        sb.append("    cardHolderName: ").append(this.toIndentedString((Object)this.cardHolderName)).append("\n");
        sb.append("    installments: ").append(this.toIndentedString(this.installments)).append("\n");
        sb.append("    shopperInput: ").append(this.toIndentedString(this.shopperInput)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ModelConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ModelConfiguration` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AVS) != null) {
            Avs.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AVS));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_HOLDER_NAME) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CARD_HOLDER_NAME).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `cardHolderName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_HOLDER_NAME).toString()));
            }
            CardHolderNameEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CARD_HOLDER_NAME).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INSTALLMENTS) != null) {
            InstallmentsNumber.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INSTALLMENTS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_INPUT) != null) {
            ShopperInput.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_INPUT));
        }
    }

    public static ModelConfiguration fromJson(String jsonString) throws IOException {
        return (ModelConfiguration)JSON.getGson().fromJson(jsonString, ModelConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AVS);
        openapiFields.add(SERIALIZED_NAME_CARD_HOLDER_NAME);
        openapiFields.add(SERIALIZED_NAME_INSTALLMENTS);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_INPUT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ModelConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ModelConfiguration.class));
            return new TypeAdapter<ModelConfiguration>(){

                public void write(JsonWriter out, ModelConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ModelConfiguration read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ModelConfiguration.validateJsonObject(jsonObj);
                    return (ModelConfiguration)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CardHolderNameEnum {
        NONE("NONE"),
        OPTIONAL("OPTIONAL"),
        REQUIRED("REQUIRED");

        private String value;

        private CardHolderNameEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CardHolderNameEnum fromValue(String value) {
            for (CardHolderNameEnum b : CardHolderNameEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CardHolderNameEnum> {
            public void write(JsonWriter jsonWriter, CardHolderNameEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CardHolderNameEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CardHolderNameEnum.fromValue(value);
            }
        }
    }
}

