/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.InputDetail;
import com.adyen.model.checkout.PaymentMethodGroup;
import com.adyen.model.checkout.PaymentMethodIssuer;
import com.adyen.util.Util;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PaymentMethod {
    @SerializedName(value="brand")
    private String brand = null;
    @SerializedName(value="brands")
    private List<String> brands = null;
    @SerializedName(value="configuration")
    private Map<String, String> configuration = null;
    @SerializedName(value="issuers")
    private List<PaymentMethodIssuer> issuers = null;
    @SerializedName(value="fundingSource")
    private FundingSourceEnum fundingSource = null;
    @SerializedName(value="group")
    private PaymentMethodGroup group = null;
    @SerializedName(value="inputDetails")
    private List<InputDetail> inputDetails = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="type")
    private String type = null;

    public PaymentMethod brand(String brand) {
        this.brand = brand;
        return this;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public PaymentMethod brands(List<String> brands) {
        this.brands = brands;
        return this;
    }

    public PaymentMethod addBrandsItem(String brandsItem) {
        if (this.brands == null) {
            this.brands = new ArrayList<String>();
        }
        this.brands.add(brandsItem);
        return this;
    }

    public List<String> getBrands() {
        return this.brands;
    }

    public void setBrands(List<String> brands) {
        this.brands = brands;
    }

    public PaymentMethod configuration(Map<String, String> configuration) {
        this.configuration = configuration;
        return this;
    }

    public PaymentMethod putConfigurationItem(String key, String configurationItem) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, String>();
        }
        this.configuration.put(key, configurationItem);
        return this;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public PaymentMethod group(PaymentMethodGroup group) {
        this.group = group;
        return this;
    }

    public PaymentMethodGroup getGroup() {
        return this.group;
    }

    public void setGroup(PaymentMethodGroup group) {
        this.group = group;
    }

    public PaymentMethod inputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
        return this;
    }

    public PaymentMethod addInputDetailsItem(InputDetail inputDetailsItem) {
        if (this.inputDetails == null) {
            this.inputDetails = new ArrayList<InputDetail>();
        }
        this.inputDetails.add(inputDetailsItem);
        return this;
    }

    @Deprecated
    public List<InputDetail> getInputDetails() {
        return this.inputDetails;
    }

    public void setInputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
    }

    public PaymentMethod name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PaymentMethod supportsRecurring(Boolean supportsRecurring) {
        return this;
    }

    public PaymentMethod type(String type) {
        this.type = type;
        return this;
    }

    public PaymentMethod issuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
        return this;
    }

    public PaymentMethod addIssuersItem(PaymentMethodIssuer issuersItem) {
        if (this.issuers == null) {
            this.issuers = new ArrayList<PaymentMethodIssuer>();
        }
        this.issuers.add(issuersItem);
        return this;
    }

    public List<PaymentMethodIssuer> getIssuers() {
        return this.issuers;
    }

    public void setIssuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethod paymentMethod = (PaymentMethod)o;
        return Objects.equals(this.brand, paymentMethod.brand) && Objects.equals(this.brands, paymentMethod.brands) && Objects.equals(this.configuration, paymentMethod.configuration) && Objects.equals((Object)this.fundingSource, (Object)paymentMethod.fundingSource) && Objects.equals(this.group, paymentMethod.group) && Objects.equals(this.inputDetails, paymentMethod.inputDetails) && Objects.equals(this.name, paymentMethod.name) && Objects.equals(this.issuers, paymentMethod.issuers) && Objects.equals(this.type, paymentMethod.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brand, this.brands, this.configuration, this.fundingSource, this.group, this.inputDetails, this.name, this.issuers, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethod {\n");
        sb.append("    brand: ").append(Util.toIndentedString(this.brand)).append("\n");
        sb.append("    brands: ").append(Util.toIndentedString(this.brands)).append("\n");
        sb.append("    configuration: ").append(Util.toIndentedString(this.configuration)).append("\n");
        sb.append("    fundingSource: ").append(Util.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    group: ").append(Util.toIndentedString(this.group)).append("\n");
        sb.append("    issuers: ").append(Util.toIndentedString(this.issuers)).append("\n");
        sb.append("    inputDetails: ").append(Util.toIndentedString(this.inputDetails)).append("\n");
        sb.append("    name: ").append(Util.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(Util.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        DEBIT("debit");

        @JsonValue
        private final String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String text) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

