/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.adyen.util.Util;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

public class Installments {
    @SerializedName(value="plan")
    private PlanEnum plan = null;
    @SerializedName(value="value")
    private Integer value = null;

    public Installments plan(PlanEnum plan) {
        this.plan = plan;
        return this;
    }

    @Schema(description="The installment plan, used for [card installments in Japan](https://docs.adyen.com/payment-methods/cards/credit-card-installments#make-a-payment-japan). By default, this is set to **regular**. Possible values: * **regular** * **revolving** ")
    public PlanEnum getPlan() {
        return this.plan;
    }

    public void setPlan(PlanEnum plan) {
        this.plan = plan;
    }

    public Installments value(Integer value) {
        this.value = value;
        return this;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Installments installments = (Installments)o;
        return Objects.equals((Object)this.plan, (Object)installments.plan) && Objects.equals(this.value, installments.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.plan, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Installments {\n");
        sb.append("    plan: ").append(Util.toIndentedString((Object)this.plan)).append("\n");
        sb.append("    value: ").append(Util.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PlanEnum {
        REGULAR("regular"),
        REVOLVING("revolving");

        @JsonValue
        private final String value;

        private PlanEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PlanEnum fromValue(String input) {
            for (PlanEnum b : PlanEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PlanEnum> {
            public void write(JsonWriter jsonWriter, PlanEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public PlanEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PlanEnum.fromValue(value);
            }
        }
    }
}

