/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.deserializer.PaymentMethodDetailsDeserializerJackson;
import com.adyen.deserializer.PaymentMethodDetailsTypeAdapter;
import com.adyen.model.AccountInfo;
import com.adyen.model.Address;
import com.adyen.model.Amount;
import com.adyen.model.BrowserInfo;
import com.adyen.model.ForexQuote;
import com.adyen.model.Installments;
import com.adyen.model.MerchantRiskIndicator;
import com.adyen.model.Name;
import com.adyen.model.Split;
import com.adyen.model.ThreeDS2RequestData;
import com.adyen.model.applicationinfo.ApplicationInfo;
import com.adyen.model.checkout.CheckoutOrder;
import com.adyen.model.checkout.Company;
import com.adyen.model.checkout.DefaultPaymentMethodDetails;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Mandate;
import com.adyen.model.checkout.PaymentMethodDetails;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.ThreeDSecureData;
import com.adyen.serializer.DateSerializer;
import com.adyen.serializer.DateTimeGMTSerializer;
import com.adyen.util.Util;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PaymentsRequest {
    @SerializedName(value="accountInfo")
    private AccountInfo accountInfo = null;
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    @SerializedName(value="amount")
    private Amount amount = null;
    @SerializedName(value="billingAddress")
    private Address billingAddress = null;
    @SerializedName(value="captureDelayHours")
    private Integer captureDelayHours = null;
    @SerializedName(value="channel")
    private ChannelEnum channel = null;
    @SerializedName(value="company")
    private Company company = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="dateOfBirth")
    @JsonAdapter(value=DateSerializer.class)
    private Date dateOfBirth = null;
    @SerializedName(value="dccQuote")
    private ForexQuote dccQuote = null;
    @SerializedName(value="deliveryAddress")
    private Address deliveryAddress = null;
    @SerializedName(value="deliveryDate")
    @JsonAdapter(value=DateTimeGMTSerializer.class)
    private Date deliveryDate = null;
    @SerializedName(value="enableOneClick")
    private Boolean enableOneClick = null;
    @SerializedName(value="enablePayOut")
    private Boolean enablePayOut = null;
    @SerializedName(value="enableRecurring")
    private Boolean enableRecurring = null;
    @SerializedName(value="entityType")
    private EntityTypeEnum entityType = null;
    @SerializedName(value="fraudOffset")
    private Integer fraudOffset = null;
    @SerializedName(value="installments")
    private Installments installments = null;
    @SerializedName(value="lineItems")
    private List<LineItem> lineItems = null;
    @SerializedName(value="mcc")
    private String mcc = null;
    @SerializedName(value="merchantAccount")
    private String merchantAccount = null;
    @SerializedName(value="merchantOrderReference")
    private String merchantOrderReference = null;
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    @SerializedName(value="orderReference")
    private String orderReference = null;
    @SerializedName(value="paymentMethod")
    @JsonAdapter(value=PaymentMethodDetailsTypeAdapter.class)
    @JsonDeserialize(using=PaymentMethodDetailsDeserializerJackson.class)
    private PaymentMethodDetails paymentMethod = null;
    @SerializedName(value="reference")
    private String reference = null;
    @SerializedName(value="returnUrl")
    private String returnUrl = null;
    @SerializedName(value="sessionValidity")
    private String sessionValidity = null;
    @SerializedName(value="shopperEmail")
    private String shopperEmail = null;
    @SerializedName(value="shopperIP")
    private String shopperIP = null;
    @SerializedName(value="shopperInteraction")
    private ShopperInteractionEnum shopperInteraction = null;
    @SerializedName(value="shopperLocale")
    private String shopperLocale = null;
    @SerializedName(value="shopperName")
    private Name shopperName = null;
    @SerializedName(value="shopperReference")
    private String shopperReference = null;
    @SerializedName(value="shopperStatement")
    private String shopperStatement = null;
    @SerializedName(value="socialSecurityNumber")
    private String socialSecurityNumber = null;
    @SerializedName(value="telephoneNumber")
    private String telephoneNumber = null;
    @SerializedName(value="browserInfo")
    private BrowserInfo browserInfo = null;
    @SerializedName(value="deviceFingerprint")
    private String deviceFingerprint = null;
    @SerializedName(value="applicationInfo")
    private ApplicationInfo applicationInfo = new ApplicationInfo();
    @SerializedName(value="splits")
    private List<Split> splits = null;
    @SerializedName(value="merchantRiskIndicator")
    private MerchantRiskIndicator merchantRiskIndicator = null;
    @SerializedName(value="threeDS2RequestData")
    private ThreeDS2RequestData threeDS2RequestData = null;
    @SerializedName(value="trustedShopper")
    private Boolean trustedShopper = null;
    @SerializedName(value="origin")
    private String origin;
    @SerializedName(value="recurringProcessingModel")
    private RecurringProcessingModelEnum recurringProcessingModel = null;
    @SerializedName(value="mpiData")
    private ThreeDSecureData mpiData = null;
    @SerializedName(value="redirectFromIssuerMethod")
    private String redirectFromIssuerMethod = null;
    @SerializedName(value="redirectToIssuerMethod")
    private String redirectToIssuerMethod = null;
    @SerializedName(value="order")
    private CheckoutOrder order = null;
    @SerializedName(value="storePaymentMethod")
    private Boolean storePaymentMethod = null;
    @SerializedName(value="store")
    private String store = null;
    @SerializedName(value="threeDSAuthenticationOnly")
    private Boolean threeDSAuthenticationOnly = null;
    @SerializedName(value="riskData")
    private RiskData riskData = null;
    @SerializedName(value="conversionId")
    private String conversionId = null;
    @SerializedName(value="recurringExpiry")
    private String recurringExpiry = null;
    @SerializedName(value="recurringFrequency")
    private String recurringFrequency = null;
    @SerializedName(value="mandate")
    private Mandate mandate = null;

    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    public PaymentsRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public MerchantRiskIndicator getMerchantRiskIndicator() {
        return this.merchantRiskIndicator;
    }

    public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
    }

    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public Boolean getEnableOneClick() {
        return this.enableOneClick;
    }

    public Boolean getEnablePayOut() {
        return this.enablePayOut;
    }

    public Boolean getEnableRecurring() {
        return this.enableRecurring;
    }

    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public Boolean getTrustedShopper() {
        return this.trustedShopper;
    }

    public void setTrustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
    }

    public ThreeDS2RequestData getThreeDS2RequestData() {
        return this.threeDS2RequestData;
    }

    public void setThreeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
    }

    public PaymentsRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentsRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentsRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentsRequest setAmountData(String amount, String currency) {
        Amount amountData = Util.createAmount(amount, currency);
        this.setAmount(amountData);
        return this;
    }

    public PaymentsRequest billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public PaymentsRequest captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return this;
    }

    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public PaymentsRequest channel(ChannelEnum channel) {
        this.channel = channel;
        return this;
    }

    public ChannelEnum getChannel() {
        return this.channel;
    }

    public void setChannel(ChannelEnum channel) {
        this.channel = channel;
    }

    public PaymentsRequest company(Company company) {
        this.company = company;
        return this;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public PaymentsRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PaymentsRequest dateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PaymentsRequest dccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
        return this;
    }

    public ForexQuote getDccQuote() {
        return this.dccQuote;
    }

    public void setDccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
    }

    public PaymentsRequest deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public PaymentsRequest deliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
        return this;
    }

    public Date getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public PaymentsRequest enableOneClick(Boolean enableOneClick) {
        this.enableOneClick = enableOneClick;
        return this;
    }

    public Boolean isEnableOneClick() {
        return this.enableOneClick;
    }

    public void setEnableOneClick(Boolean enableOneClick) {
        this.enableOneClick = enableOneClick;
    }

    public PaymentsRequest enablePayOut(Boolean enablePayOut) {
        this.enablePayOut = enablePayOut;
        return this;
    }

    public Boolean isEnablePayOut() {
        return this.enablePayOut;
    }

    public void setEnablePayOut(Boolean enablePayOut) {
        this.enablePayOut = enablePayOut;
    }

    public PaymentsRequest enableRecurring(Boolean enableRecurring) {
        this.enableRecurring = enableRecurring;
        return this;
    }

    public Boolean isEnableRecurring() {
        return this.enableRecurring;
    }

    public void setEnableRecurring(Boolean enableRecurring) {
        this.enableRecurring = enableRecurring;
    }

    public PaymentsRequest entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public PaymentsRequest fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public PaymentsRequest installments(Installments installments) {
        this.installments = installments;
        return this;
    }

    public Installments getInstallments() {
        return this.installments;
    }

    public void setInstallments(Installments installments) {
        this.installments = installments;
    }

    public PaymentsRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public PaymentsRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PaymentsRequest mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public PaymentsRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentsRequest merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return this;
    }

    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public PaymentsRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PaymentsRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PaymentsRequest orderReference(String orderReference) {
        this.orderReference = orderReference;
        return this;
    }

    public String getOrderReference() {
        return this.orderReference;
    }

    public void setOrderReference(String orderReference) {
        this.orderReference = orderReference;
    }

    public PaymentMethodDetails getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethodDetails paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentsRequest paymentMethod(PaymentMethodDetails paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public PaymentsRequest store(String store) {
        this.store = store;
        return this;
    }

    public PaymentsRequest mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public PaymentsRequest addEncryptedCardData(String encryptedCardNumber, String encryptedExpiryMonth, String encryptedExpiryYear, String encryptedSecurityCode) {
        return this.addEncryptedCardData(encryptedCardNumber, encryptedExpiryMonth, encryptedExpiryYear, encryptedSecurityCode, null, null);
    }

    public PaymentsRequest addEncryptedCardData(String encryptedCardNumber, String encryptedExpiryMonth, String encryptedExpiryYear, String encryptedSecurityCode, String holderName) {
        return this.addEncryptedCardData(encryptedCardNumber, encryptedExpiryMonth, encryptedExpiryYear, encryptedSecurityCode, holderName, null);
    }

    public PaymentsRequest addEncryptedCardData(String encryptedCardNumber, String encryptedExpiryMonth, String encryptedExpiryYear, String encryptedSecurityCode, String holderName, Boolean storeDetails) {
        DefaultPaymentMethodDetails paymentMethodDetails = new DefaultPaymentMethodDetails();
        paymentMethodDetails.type("scheme").encryptedCardNumber(encryptedCardNumber).encryptedExpiryMonth(encryptedExpiryMonth).encryptedExpiryYear(encryptedExpiryYear);
        if (encryptedSecurityCode != null) {
            paymentMethodDetails.setEncryptedSecurityCode(encryptedSecurityCode);
        }
        if (holderName != null) {
            paymentMethodDetails.setHolderName(holderName);
        }
        if (storeDetails != null) {
            paymentMethodDetails.setStoreDetails(storeDetails);
        }
        this.paymentMethod = paymentMethodDetails;
        return this;
    }

    public PaymentsRequest addCardData(String cardNumber, String expiryMonth, String expiryYear, String securityCode, String holderName) {
        return this.addCardData(cardNumber, expiryMonth, expiryYear, securityCode, holderName, null);
    }

    public PaymentsRequest addCardData(String cardNumber, String expiryMonth, String expiryYear, String securityCode, String holderName, Boolean storeDetails) {
        DefaultPaymentMethodDetails paymentMethodDetails = new DefaultPaymentMethodDetails();
        paymentMethodDetails.type("scheme").number(cardNumber).expiryMonth(expiryMonth).expiryYear(expiryYear);
        if (securityCode != null) {
            paymentMethodDetails.setCvc(securityCode);
        }
        if (holderName != null) {
            paymentMethodDetails.setHolderName(holderName);
        }
        if (storeDetails != null) {
            paymentMethodDetails.setStoreDetails(storeDetails);
        }
        this.paymentMethod = paymentMethodDetails;
        return this;
    }

    public PaymentsRequest addOneClickData(String recurringDetailReference, String encryptedSecurityCode) {
        DefaultPaymentMethodDetails paymentMethodDetails = new DefaultPaymentMethodDetails();
        paymentMethodDetails.type("scheme").setStoredPaymentMethodId(recurringDetailReference);
        paymentMethodDetails.type("scheme").encryptedSecurityCode(encryptedSecurityCode);
        this.paymentMethod = paymentMethodDetails;
        return this;
    }

    public PaymentsRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentsRequest returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public PaymentsRequest sessionValidity(String sessionValidity) {
        this.sessionValidity = sessionValidity;
        return this;
    }

    public String getSessionValidity() {
        return this.sessionValidity;
    }

    public void setSessionValidity(String sessionValidity) {
        this.sessionValidity = sessionValidity;
    }

    public PaymentsRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public PaymentsRequest shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        return this;
    }

    public String getShopperIP() {
        return this.shopperIP;
    }

    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
    }

    public PaymentsRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public PaymentsRequest shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    public String getShopperLocale() {
        return this.shopperLocale;
    }

    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public PaymentsRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public PaymentsRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public PaymentsRequest shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    public String getShopperStatement() {
        return this.shopperStatement;
    }

    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public PaymentsRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public PaymentsRequest telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    public void setBrowserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
    }

    public PaymentsRequest browserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
        return this;
    }

    public PaymentsRequest addBrowserInfoData(String userAgent, String acceptHeader) {
        BrowserInfo browserInfo = new BrowserInfo();
        browserInfo.setAcceptHeader(acceptHeader);
        browserInfo.setUserAgent(userAgent);
        this.setBrowserInfo(browserInfo);
        return this;
    }

    public String getDeviceFingerprint() {
        return this.deviceFingerprint;
    }

    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    public PaymentsRequest deviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
        return this;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public PaymentsRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public PaymentsRequest origin(String origin) {
        this.origin = origin;
        return this;
    }

    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public PaymentsRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    public String getRedirectFromIssuerMethod() {
        return this.redirectFromIssuerMethod;
    }

    public void setRedirectFromIssuerMethod(String redirectFromIssuerMethod) {
        this.redirectFromIssuerMethod = redirectFromIssuerMethod;
    }

    public PaymentsRequest redirectFromIssuerMethod(String redirectFromIssuerMethod) {
        this.redirectFromIssuerMethod = redirectFromIssuerMethod;
        return this;
    }

    public String getRedirectToIssuerMethod() {
        return this.redirectToIssuerMethod;
    }

    public void setRedirectToIssuerMethod(String redirectToIssuerMethod) {
        this.redirectToIssuerMethod = redirectToIssuerMethod;
    }

    public PaymentsRequest redirectToIssuerMethod(String redirectToIssuerMethod) {
        this.redirectToIssuerMethod = redirectToIssuerMethod;
        return this;
    }

    public CheckoutOrder getOrder() {
        return this.order;
    }

    public void setOrder(CheckoutOrder order) {
        this.order = order;
    }

    public PaymentsRequest order(CheckoutOrder order) {
        this.order = order;
        return this;
    }

    public Boolean getStorePaymentMethod() {
        return this.storePaymentMethod;
    }

    public void setStorePaymentMethod(Boolean storePaymentMethod) {
        this.storePaymentMethod = storePaymentMethod;
    }

    public PaymentsRequest storePaymentMethod(Boolean storePaymentMethod) {
        this.storePaymentMethod = storePaymentMethod;
        return this;
    }

    public PaymentsRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return this;
    }

    public Boolean isThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public PaymentsRequest riskData(RiskData riskData) {
        this.riskData = riskData;
        return this;
    }

    public RiskData getRiskData() {
        return this.riskData;
    }

    public void setRiskData(RiskData riskData) {
        this.riskData = riskData;
    }

    public PaymentsRequest conversionId(String conversionId) {
        this.conversionId = conversionId;
        return this;
    }

    public String getConversionId() {
        return this.conversionId;
    }

    public void setConversionId(String conversionId) {
        this.conversionId = conversionId;
    }

    public String getRecurringExpiry() {
        return this.recurringExpiry;
    }

    public void setRecurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
    }

    public String getRecurringFrequency() {
        return this.recurringFrequency;
    }

    public void setRecurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentsRequest paymentsRequest = (PaymentsRequest)o;
        return Objects.equals(this.accountInfo, paymentsRequest.accountInfo) && Objects.equals(this.additionalData, paymentsRequest.additionalData) && Objects.equals(this.amount, paymentsRequest.amount) && Objects.equals(this.applicationInfo, paymentsRequest.applicationInfo) && Objects.equals(this.billingAddress, paymentsRequest.billingAddress) && Objects.equals(this.browserInfo, paymentsRequest.browserInfo) && Objects.equals(this.captureDelayHours, paymentsRequest.captureDelayHours) && Objects.equals((Object)this.channel, (Object)paymentsRequest.channel) && Objects.equals(this.company, paymentsRequest.company) && Objects.equals(this.conversionId, paymentsRequest.conversionId) && Objects.equals(this.countryCode, paymentsRequest.countryCode) && Objects.equals(this.dateOfBirth, paymentsRequest.dateOfBirth) && Objects.equals(this.dccQuote, paymentsRequest.dccQuote) && Objects.equals(this.deliveryAddress, paymentsRequest.deliveryAddress) && Objects.equals(this.deliveryDate, paymentsRequest.deliveryDate) && Objects.equals(this.deviceFingerprint, paymentsRequest.deviceFingerprint) && Objects.equals(this.enableOneClick, paymentsRequest.enableOneClick) && Objects.equals(this.enablePayOut, paymentsRequest.enablePayOut) && Objects.equals(this.enableRecurring, paymentsRequest.enableRecurring) && Objects.equals((Object)this.entityType, (Object)paymentsRequest.entityType) && Objects.equals(this.fraudOffset, paymentsRequest.fraudOffset) && Objects.equals(this.installments, paymentsRequest.installments) && Objects.equals(this.lineItems, paymentsRequest.lineItems) && Objects.equals(this.mcc, paymentsRequest.mcc) && Objects.equals(this.merchantAccount, paymentsRequest.merchantAccount) && Objects.equals(this.merchantOrderReference, paymentsRequest.merchantOrderReference) && Objects.equals(this.merchantRiskIndicator, paymentsRequest.merchantRiskIndicator) && Objects.equals(this.metadata, paymentsRequest.metadata) && Objects.equals(this.mpiData, paymentsRequest.mpiData) && Objects.equals(this.order, paymentsRequest.order) && Objects.equals(this.orderReference, paymentsRequest.orderReference) && Objects.equals(this.origin, paymentsRequest.origin) && Objects.equals(this.paymentMethod, paymentsRequest.paymentMethod) && Objects.equals(this.recurringExpiry, paymentsRequest.recurringExpiry) && Objects.equals(this.recurringFrequency, paymentsRequest.recurringFrequency) && Objects.equals((Object)this.recurringProcessingModel, (Object)paymentsRequest.recurringProcessingModel) && Objects.equals(this.redirectFromIssuerMethod, paymentsRequest.redirectFromIssuerMethod) && Objects.equals(this.redirectToIssuerMethod, paymentsRequest.redirectToIssuerMethod) && Objects.equals(this.reference, paymentsRequest.reference) && Objects.equals(this.returnUrl, paymentsRequest.returnUrl) && Objects.equals(this.riskData, paymentsRequest.riskData) && Objects.equals(this.sessionValidity, paymentsRequest.sessionValidity) && Objects.equals(this.shopperEmail, paymentsRequest.shopperEmail) && Objects.equals(this.shopperIP, paymentsRequest.shopperIP) && Objects.equals((Object)this.shopperInteraction, (Object)paymentsRequest.shopperInteraction) && Objects.equals(this.shopperLocale, paymentsRequest.shopperLocale) && Objects.equals(this.shopperName, paymentsRequest.shopperName) && Objects.equals(this.shopperReference, paymentsRequest.shopperReference) && Objects.equals(this.shopperStatement, paymentsRequest.shopperStatement) && Objects.equals(this.socialSecurityNumber, paymentsRequest.socialSecurityNumber) && Objects.equals(this.splits, paymentsRequest.splits) && Objects.equals(this.store, paymentsRequest.store) && Objects.equals(this.storePaymentMethod, paymentsRequest.storePaymentMethod) && Objects.equals(this.telephoneNumber, paymentsRequest.telephoneNumber) && Objects.equals(this.threeDS2RequestData, paymentsRequest.threeDS2RequestData) && Objects.equals(this.threeDSAuthenticationOnly, paymentsRequest.threeDSAuthenticationOnly) && Objects.equals(this.trustedShopper, paymentsRequest.trustedShopper) && Objects.equals(this.mandate, paymentsRequest.mandate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountInfo, this.additionalData, this.amount, this.applicationInfo, this.billingAddress, this.browserInfo, this.captureDelayHours, this.channel, this.company, this.conversionId, this.countryCode, this.dateOfBirth, this.dccQuote, this.deliveryAddress, this.deliveryDate, this.deviceFingerprint, this.enableOneClick, this.enablePayOut, this.enableRecurring, this.entityType, this.fraudOffset, this.installments, this.lineItems, this.mcc, this.merchantAccount, this.merchantOrderReference, this.merchantRiskIndicator, this.metadata, this.mpiData, this.order, this.orderReference, this.origin, this.paymentMethod, this.recurringExpiry, this.recurringFrequency, this.recurringProcessingModel, this.redirectFromIssuerMethod, this.redirectToIssuerMethod, this.reference, this.returnUrl, this.riskData, this.sessionValidity, this.shopperEmail, this.shopperIP, this.shopperInteraction, this.shopperLocale, this.shopperName, this.shopperReference, this.shopperStatement, this.socialSecurityNumber, this.splits, this.store, this.storePaymentMethod, this.telephoneNumber, this.threeDS2RequestData, this.threeDSAuthenticationOnly, this.trustedShopper, this.mandate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentsRequest {\n");
        sb.append("    accountInfo: ").append(Util.toIndentedString(this.accountInfo)).append("\n");
        sb.append("    additionalData: ").append(Util.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(Util.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(Util.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    billingAddress: ").append(Util.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    browserInfo: ").append(Util.toIndentedString(this.browserInfo)).append("\n");
        sb.append("    captureDelayHours: ").append(Util.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    channel: ").append(Util.toIndentedString((Object)this.channel)).append("\n");
        sb.append("    company: ").append(Util.toIndentedString(this.company)).append("\n");
        sb.append("    conversionId: ").append(Util.toIndentedString(this.conversionId)).append("\n");
        sb.append("    countryCode: ").append(Util.toIndentedString(this.countryCode)).append("\n");
        sb.append("    dateOfBirth: ").append(Util.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    dccQuote: ").append(Util.toIndentedString(this.dccQuote)).append("\n");
        sb.append("    deliveryAddress: ").append(Util.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    deliveryDate: ").append(Util.toIndentedString(this.deliveryDate)).append("\n");
        sb.append("    deviceFingerprint: ").append(Util.toIndentedString(this.deviceFingerprint)).append("\n");
        sb.append("    enableOneClick: ").append(Util.toIndentedString(this.enableOneClick)).append("\n");
        sb.append("    enablePayOut: ").append(Util.toIndentedString(this.enablePayOut)).append("\n");
        sb.append("    enableRecurring: ").append(Util.toIndentedString(this.enableRecurring)).append("\n");
        sb.append("    entityType: ").append(Util.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    fraudOffset: ").append(Util.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    installments: ").append(Util.toIndentedString(this.installments)).append("\n");
        sb.append("    lineItems: ").append(Util.toIndentedString(this.lineItems)).append("\n");
        sb.append("    mcc: ").append(Util.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantAccount: ").append(Util.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantOrderReference: ").append(Util.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    merchantRiskIndicator: ").append(Util.toIndentedString(this.merchantRiskIndicator)).append("\n");
        sb.append("    metadata: ").append(Util.toIndentedString(this.metadata)).append("\n");
        sb.append("    mpiData: ").append(Util.toIndentedString(this.mpiData)).append("\n");
        sb.append("    order: ").append(Util.toIndentedString(this.order)).append("\n");
        sb.append("    orderReference: ").append(Util.toIndentedString(this.orderReference)).append("\n");
        sb.append("    origin: ").append(Util.toIndentedString(this.origin)).append("\n");
        sb.append("    paymentMethod: ").append(Util.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    recurringExpiry: ").append(Util.toIndentedString(this.recurringExpiry)).append("\n");
        sb.append("    recurringFrequency: ").append(Util.toIndentedString(this.recurringFrequency)).append("\n");
        sb.append("    recurringProcessingModel: ").append(Util.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    redirectFromIssuerMethod: ").append(Util.toIndentedString(this.redirectFromIssuerMethod)).append("\n");
        sb.append("    redirectToIssuerMethod: ").append(Util.toIndentedString(this.redirectToIssuerMethod)).append("\n");
        sb.append("    reference: ").append(Util.toIndentedString(this.reference)).append("\n");
        sb.append("    returnUrl: ").append(Util.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    riskData: ").append(Util.toIndentedString(this.riskData)).append("\n");
        sb.append("    sessionValidity: ").append(Util.toIndentedString(this.sessionValidity)).append("\n");
        sb.append("    shopperEmail: ").append(Util.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperIP: ").append(Util.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    shopperInteraction: ").append(Util.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperLocale: ").append(Util.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(Util.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(Util.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(Util.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    socialSecurityNumber: ").append(Util.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    splits: ").append(Util.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(Util.toIndentedString(this.store)).append("\n");
        sb.append("    storePaymentMethod: ").append(Util.toIndentedString(this.storePaymentMethod)).append("\n");
        sb.append("    telephoneNumber: ").append(Util.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    threeDS2RequestData: ").append(Util.toIndentedString(this.threeDS2RequestData)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(Util.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        sb.append("    trustedShopper: ").append(Util.toIndentedString(this.trustedShopper)).append("\n");
        sb.append("    mandate: ").append(Util.toIndentedString(this.mandate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto"),
        POS("POS");

        @JsonValue
        private final String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        public static ShopperInteractionEnum fromValue(String text) {
            return Arrays.stream(ShopperInteractionEnum.values()).filter(s -> s.value.equals(text)).findFirst().orElse(null);
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static class Adapter
        extends TypeAdapter<ShopperInteractionEnum> {
            public void write(JsonWriter jsonWriter, ShopperInteractionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShopperInteractionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShopperInteractionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    public static enum RecurringProcessingModelEnum {
        SUBSCRIPTION("Subscription"),
        CARD_ON_FILE("CardOnFile"),
        UNSCHEDULED_CARD_ON_FILE("UnscheduledCardOnFile");

        @JsonValue
        private final String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EntityTypeEnum {
        NATURALPERSON("NaturalPerson"),
        COMPANYNAME("CompanyName");

        @JsonValue
        private final String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        public static EntityTypeEnum fromValue(String text) {
            return Arrays.stream(EntityTypeEnum.values()).filter(s -> s.value.equals(text)).findFirst().orElse(null);
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static class Adapter
        extends TypeAdapter<EntityTypeEnum> {
            public void write(JsonWriter jsonWriter, EntityTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EntityTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EntityTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChannelEnum {
        IOS("iOS"),
        ANDROID("Android"),
        WEB("Web");

        @JsonValue
        private final String value;

        private ChannelEnum(String value) {
            this.value = value;
        }

        public static ChannelEnum fromValue(String text) {
            return Arrays.stream(ChannelEnum.values()).filter(s -> s.value.equals(text)).findFirst().orElse(null);
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static class Adapter
        extends TypeAdapter<ChannelEnum> {
            public void write(JsonWriter jsonWriter, ChannelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChannelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChannelEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

