/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpay.notification;

import com.adyen.model.marketpay.notification.ExchangeMessage;
import com.adyen.model.marketpay.notification.ExchangeMessageContainer;
import com.adyen.util.Util;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TestNotificationConfigurationResponse {
    @SerializedName(value="errorMessages")
    private List<String> errorMessages = null;
    @SerializedName(value="submittedAsync")
    private Boolean submittedAsync = null;
    @SerializedName(value="okMessages")
    private List<String> okMessages = null;
    @SerializedName(value="exchangeMessages")
    @JsonProperty(value="exchangeMessages")
    private List<ExchangeMessageContainer> exchangeMessageContainers = null;
    private transient List<ExchangeMessage> exchangeMessages = null;
    @SerializedName(value="notificationId")
    private Long notificationId = null;
    @SerializedName(value="eventTypes")
    private List<EventTypesEnum> eventTypes = null;
    @SerializedName(value="pspReference")
    private String pspReference = null;

    public TestNotificationConfigurationResponse errorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
        return this;
    }

    public TestNotificationConfigurationResponse addErrorMessagesItem(String errorMessagesItem) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList<String>();
        }
        this.errorMessages.add(errorMessagesItem);
        return this;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public TestNotificationConfigurationResponse submittedAsync(Boolean submittedAsync) {
        this.submittedAsync = submittedAsync;
        return this;
    }

    public Boolean getSubmittedAsync() {
        return this.submittedAsync;
    }

    public void setSubmittedAsync(Boolean submittedAsync) {
        this.submittedAsync = submittedAsync;
    }

    public TestNotificationConfigurationResponse okMessages(List<String> okMessages) {
        this.okMessages = okMessages;
        return this;
    }

    public TestNotificationConfigurationResponse addOkMessagesItem(String okMessagesItem) {
        if (this.okMessages == null) {
            this.okMessages = new ArrayList<String>();
        }
        this.okMessages.add(okMessagesItem);
        return this;
    }

    public List<String> getOkMessages() {
        return this.okMessages;
    }

    public void setOkMessages(List<String> okMessages) {
        this.okMessages = okMessages;
    }

    public List<ExchangeMessage> getExchangeMessages() {
        if (this.exchangeMessages == null && this.exchangeMessageContainers != null && !this.exchangeMessageContainers.isEmpty()) {
            this.exchangeMessages = this.exchangeMessageContainers.stream().map(s -> s.getExchangeMessage()).collect(Collectors.toList());
        }
        return this.exchangeMessages;
    }

    public void setExchangeMessages(List<ExchangeMessage> exchangeMessages) {
        this.exchangeMessages = exchangeMessages;
        this.exchangeMessageContainers = exchangeMessages.stream().map(s -> this.createExchangeMessageContainerFromExchangeMessage((ExchangeMessage)s)).collect(Collectors.toList());
    }

    private ExchangeMessageContainer createExchangeMessageContainerFromExchangeMessage(ExchangeMessage exchangeMessage) {
        ExchangeMessageContainer exchangeMessageContainer = new ExchangeMessageContainer();
        exchangeMessageContainer.setExchangeMessage(exchangeMessage);
        return exchangeMessageContainer;
    }

    public TestNotificationConfigurationResponse notificationId(Long notificationId) {
        this.notificationId = notificationId;
        return this;
    }

    public Long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(Long notificationId) {
        this.notificationId = notificationId;
    }

    public TestNotificationConfigurationResponse eventTypes(List<EventTypesEnum> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public TestNotificationConfigurationResponse addEventTypesItem(EventTypesEnum eventTypesItem) {
        if (this.eventTypes == null) {
            this.eventTypes = new ArrayList<EventTypesEnum>();
        }
        this.eventTypes.add(eventTypesItem);
        return this;
    }

    public List<EventTypesEnum> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(List<EventTypesEnum> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public TestNotificationConfigurationResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestNotificationConfigurationResponse testNotificationConfigurationResponse = (TestNotificationConfigurationResponse)o;
        return Objects.equals(this.errorMessages, testNotificationConfigurationResponse.errorMessages) && Objects.equals(this.submittedAsync, testNotificationConfigurationResponse.submittedAsync) && Objects.equals(this.okMessages, testNotificationConfigurationResponse.okMessages) && Objects.equals(this.exchangeMessageContainers, testNotificationConfigurationResponse.exchangeMessageContainers) && Objects.equals(this.notificationId, testNotificationConfigurationResponse.notificationId) && Objects.equals(this.eventTypes, testNotificationConfigurationResponse.eventTypes) && Objects.equals(this.pspReference, testNotificationConfigurationResponse.pspReference);
    }

    public int hashCode() {
        return Objects.hash(this.errorMessages, this.submittedAsync, this.okMessages, this.exchangeMessageContainers, this.notificationId, this.eventTypes, this.pspReference);
    }

    public String toString() {
        this.getExchangeMessages();
        StringBuilder sb = new StringBuilder();
        sb.append("class TestNotificationConfigurationResponse {\n");
        sb.append("    errorMessages: ").append(Util.toIndentedString(this.errorMessages)).append("\n");
        sb.append("    submittedAsync: ").append(Util.toIndentedString(this.submittedAsync)).append("\n");
        sb.append("    okMessages: ").append(Util.toIndentedString(this.okMessages)).append("\n");
        sb.append("    exchangeMessages: ").append(Util.toIndentedString(this.exchangeMessages)).append("\n");
        sb.append("    notificationId: ").append(Util.toIndentedString(this.notificationId)).append("\n");
        sb.append("    eventTypes: ").append(Util.toIndentedString(this.eventTypes)).append("\n");
        sb.append("    pspReference: ").append(Util.toIndentedString(this.pspReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum EventTypesEnum {
        ACCOUNT_CREATED("ACCOUNT_CREATED"),
        ACCOUNT_HOLDER_CREATED("ACCOUNT_HOLDER_CREATED"),
        ACCOUNT_HOLDER_LIMIT_REACHED("ACCOUNT_HOLDER_LIMIT_REACHED"),
        ACCOUNT_HOLDER_PAYOUT("ACCOUNT_HOLDER_PAYOUT"),
        ACCOUNT_HOLDER_STATUS_CHANGE("ACCOUNT_HOLDER_STATUS_CHANGE"),
        ACCOUNT_HOLDER_UPDATED("ACCOUNT_HOLDER_UPDATED"),
        ACCOUNT_HOLDER_VERIFICATION("ACCOUNT_HOLDER_VERIFICATION"),
        ACCOUNT_UPDATED("ACCOUNT_UPDATED"),
        BENEFICIARY_SETUP("BENEFICIARY_SETUP"),
        COMPENSATE_NEGATIVE_BALANCE("COMPENSATE_NEGATIVE_BALANCE"),
        PAYMENT_FAILURE("PAYMENT_FAILURE"),
        REPORT_AVAILABLE("REPORT_AVAILABLE"),
        SCHEDULED_REFUNDS("SCHEDULED_REFUNDS"),
        TRANSFER_FUNDS("TRANSFER_FUNDS");

        private String value;

        private EventTypesEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

