/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.deserializer;

import com.adyen.model.marketpay.notification.AccountCreatedNotification;
import com.adyen.model.marketpay.notification.AccountHolderCreatedNotification;
import com.adyen.model.marketpay.notification.AccountHolderLimitReachedNotification;
import com.adyen.model.marketpay.notification.AccountHolderPayoutNotification;
import com.adyen.model.marketpay.notification.AccountHolderStatusChangeNotification;
import com.adyen.model.marketpay.notification.AccountHolderUpdatedNotification;
import com.adyen.model.marketpay.notification.AccountHolderVerificationNotification;
import com.adyen.model.marketpay.notification.BeneficiarySetupNotification;
import com.adyen.model.marketpay.notification.CompensateNegativeBalanceNotification;
import com.adyen.model.marketpay.notification.GenericNotification;
import com.adyen.model.marketpay.notification.PaymentFailureNotification;
import com.adyen.model.marketpay.notification.ReportAvailableNotification;
import com.adyen.model.marketpay.notification.ScheduledRefundsNotification;
import com.adyen.model.marketpay.notification.TransferFundsNotification;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class MarketPayNotificationMessageDeserializer
implements JsonDeserializer<GenericNotification> {
    public GenericNotification deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonElement jsonType = jsonObject.get("eventType");
        String eventType = jsonType.getAsString();
        if (GenericNotification.EventTypeEnum.ACCOUNT_CREATED.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, AccountCreatedNotification.class);
        }
        if (GenericNotification.EventTypeEnum.ACCOUNT_HOLDER_CREATED.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, AccountHolderCreatedNotification.class);
        }
        if (GenericNotification.EventTypeEnum.ACCOUNT_HOLDER_LIMIT_REACHED.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, AccountHolderLimitReachedNotification.class);
        }
        if (GenericNotification.EventTypeEnum.ACCOUNT_HOLDER_VERIFICATION.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, AccountHolderVerificationNotification.class);
        }
        if (GenericNotification.EventTypeEnum.ACCOUNT_HOLDER_STATUS_CHANGE.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, AccountHolderStatusChangeNotification.class);
        }
        if (GenericNotification.EventTypeEnum.ACCOUNT_HOLDER_PAYOUT.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, AccountHolderPayoutNotification.class);
        }
        if (GenericNotification.EventTypeEnum.ACCOUNT_HOLDER_UPDATED.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, AccountHolderUpdatedNotification.class);
        }
        if (GenericNotification.EventTypeEnum.BENEFICIARY_SETUP.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, BeneficiarySetupNotification.class);
        }
        if (GenericNotification.EventTypeEnum.SCHEDULED_REFUNDS.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, ScheduledRefundsNotification.class);
        }
        if (GenericNotification.EventTypeEnum.COMPENSATE_NEGATIVE_BALANCE.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, CompensateNegativeBalanceNotification.class);
        }
        if (GenericNotification.EventTypeEnum.PAYMENT_FAILURE.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, PaymentFailureNotification.class);
        }
        if (GenericNotification.EventTypeEnum.REPORT_AVAILABLE.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, ReportAvailableNotification.class);
        }
        if (GenericNotification.EventTypeEnum.TRANSFER_FUNDS.toString().equalsIgnoreCase(eventType)) {
            return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, TransferFundsNotification.class);
        }
        return (GenericNotification)jsonDeserializationContext.deserialize(jsonElement, GenericNotification.class);
    }
}

