/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.adyen.Util.Util;
import com.adyen.model.AbstractPaymentRequest;
import com.adyen.model.Amount;
import com.adyen.model.BankAccount;
import com.adyen.model.Card;
import com.adyen.model.ThreeDSecureData;
import com.adyen.model.additionalData.InvoiceLine;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Objects;

public class PaymentRequest
extends AbstractPaymentRequest<PaymentRequest> {
    private static final String ADDITIONAL_DATA = "/authorise-3d-adyen-response";
    @SerializedName(value="card")
    private Card card = null;
    @SerializedName(value="mpiData")
    private ThreeDSecureData mpiData = null;
    @SerializedName(value="bankAccount")
    private BankAccount bankAccount = null;
    private List<InvoiceLine> invoiceLines = null;

    public PaymentRequest setAmountData(String amount, String currency) {
        Amount amountData = Util.createAmount(amount, currency);
        this.setAmount(amountData);
        return this;
    }

    public PaymentRequest setCSEToken(String cseToken) {
        this.getOrCreateAdditionalData().put("card.encrypted.json", cseToken);
        return this;
    }

    public PaymentRequest setCardData(String cardNumber, String cardHolder, String expiryMonth, String expiryYear, String cvc) {
        Card card = new Card();
        card.setExpiryMonth(expiryMonth);
        card.setExpiryYear(expiryYear);
        card.setHolderName(cardHolder);
        card.setNumber(cardNumber);
        card.setCvc(cvc);
        this.setCard(card);
        return this;
    }

    public PaymentRequest setInvoiceLines(List<InvoiceLine> invoiceLines) {
        Integer count = 1;
        for (InvoiceLine invoiceLine : invoiceLines) {
            StringBuilder sb = new StringBuilder();
            sb.append("openinvoicedata.line");
            sb.append(Integer.toString(count));
            String lineNumber = sb.toString();
            this.getOrCreateAdditionalData().put(lineNumber + ".currencyCode", invoiceLine.getCurrencyCode());
            this.getOrCreateAdditionalData().put(lineNumber + ".description", invoiceLine.getDescription());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemAmount", invoiceLine.getItemAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemVatAmount", invoiceLine.getItemVATAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemVatPercentage", invoiceLine.getItemVatPercentage().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".numberOfItems", Integer.toString(invoiceLine.getNumberOfItems()));
            this.getOrCreateAdditionalData().put(lineNumber + ".vatCategory", invoiceLine.getVatCategory().toString());
            if (invoiceLine.getItemId() != null && !invoiceLine.getItemId().isEmpty()) {
                this.getOrCreateAdditionalData().put(lineNumber + ".itemId", invoiceLine.getItemId());
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.getOrCreateAdditionalData().put("openinvoicedata.numberOfLines", Integer.toString(invoiceLines.size()));
        return this;
    }

    public PaymentRequest card(Card card) {
        this.card = card;
        return this;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public PaymentRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public PaymentRequest bankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRequest paymentRequest = (PaymentRequest)o;
        return super.equals(paymentRequest) && Objects.equals(this.card, paymentRequest.card) && Objects.equals(this.mpiData, paymentRequest.mpiData) && Objects.equals(this.bankAccount, paymentRequest.bankAccount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.card, this.mpiData, this.bankAccount, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRequest {\n");
        sb.append(super.toString());
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

