/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.S3Verified;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.ChecksumType;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.fasterxml.jackson.annotation.JsonProperty;

@S3Verified(year=2025)
public record Checksum(@JsonProperty(value="ChecksumCRC32") String checksumCRC32, @JsonProperty(value="ChecksumCRC32C") String checksumCRC32C, @JsonProperty(value="ChecksumCRC64NVME") String checksumCRC64NVME, @JsonProperty(value="ChecksumSHA1") String checksumSHA1, @JsonProperty(value="ChecksumSHA256") String checksumSHA256, @JsonProperty(value="ChecksumType") ChecksumType checksumType) {
    public static Checksum from(S3ObjectMetadata s3ObjectMetadata) {
        ChecksumAlgorithm checksumAlgorithm = s3ObjectMetadata.checksumAlgorithm();
        if (checksumAlgorithm != null) {
            return new Checksum(checksumAlgorithm == ChecksumAlgorithm.CRC32 ? s3ObjectMetadata.checksum() : null, checksumAlgorithm == ChecksumAlgorithm.CRC32C ? s3ObjectMetadata.checksum() : null, checksumAlgorithm == ChecksumAlgorithm.CRC64NVME ? s3ObjectMetadata.checksum() : null, checksumAlgorithm == ChecksumAlgorithm.SHA1 ? s3ObjectMetadata.checksum() : null, checksumAlgorithm == ChecksumAlgorithm.SHA256 ? s3ObjectMetadata.checksum() : null, s3ObjectMetadata.checksumType());
        }
        return null;
    }
}

