/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CompletedPart;
import com.adobe.testing.s3mock.dto.MultipartUpload;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Part;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.MultipartUploadInfo;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.store.StoreBase;
import com.adobe.testing.s3mock.util.DigestUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRange;

public class MultipartStore
extends StoreBase {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartStore.class);
    private static final String PART_SUFFIX = ".part";
    private static final String MULTIPART_UPLOAD_META_FILE = "multipartMetadata.json";
    static final String MULTIPARTS_FOLDER = "multiparts";
    private final Map<UUID, Object> lockStore = new ConcurrentHashMap<UUID, Object>();
    private final boolean retainFilesOnExit;
    private final ObjectStore objectStore;
    private final ObjectMapper objectMapper;

    public MultipartStore(boolean retainFilesOnExit, ObjectStore objectStore, ObjectMapper objectMapper) {
        this.retainFilesOnExit = retainFilesOnExit;
        this.objectStore = objectStore;
        this.objectMapper = objectMapper;
    }

    public MultipartUpload createMultipartUpload(BucketMetadata bucket, String key, UUID id, String contentType, Map<String, String> storeHeaders, Owner owner, Owner initiator, Map<String, String> userMetadata, Map<String, String> encryptionHeaders, StorageClass storageClass, String checksum, ChecksumAlgorithm checksumAlgorithm) {
        String uploadId = UUID.randomUUID().toString();
        if (!this.createPartsFolder(bucket, uploadId)) {
            LOG.error("Directories for storing multipart uploads couldn't be created. bucket={}, key={}, id={}, uploadId={}", new Object[]{bucket, key, id, uploadId});
            throw new IllegalStateException("Directories for storing multipart uploads couldn't be created.");
        }
        MultipartUpload upload = new MultipartUpload(key, uploadId, owner, initiator, storageClass, new Date());
        MultipartUploadInfo multipartUploadInfo = new MultipartUploadInfo(upload, contentType, userMetadata, storeHeaders, encryptionHeaders, bucket.name(), storageClass, checksum, checksumAlgorithm);
        this.lockStore.putIfAbsent(UUID.fromString(uploadId), new Object());
        this.writeMetafile(bucket, multipartUploadInfo);
        return upload;
    }

    public List<MultipartUpload> listMultipartUploads(BucketMetadata bucketMetadata, String prefix) {
        List<MultipartUpload> list;
        block9: {
            Path multipartsFolder = this.getMultipartsFolder(bucketMetadata);
            if (!multipartsFolder.toFile().exists()) {
                return Collections.emptyList();
            }
            DirectoryStream<Path> paths = Files.newDirectoryStream(multipartsFolder);
            try {
                list = Streams.of(paths).map(path -> {
                    String fileName = path.getFileName().toString();
                    return this.getUploadMetadata(bucketMetadata, fileName).upload();
                }).filter(multipartUpload -> StringUtils.isBlank((CharSequence)prefix) || multipartUpload.key().startsWith(prefix)).toList();
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not load buckets from data directory ", e);
                }
            }
            paths.close();
        }
        return list;
    }

    public MultipartUploadInfo getMultipartUploadInfo(BucketMetadata bucketMetadata, String uploadId) {
        return this.getUploadMetadata(bucketMetadata, uploadId);
    }

    public MultipartUpload getMultipartUpload(BucketMetadata bucketMetadata, String uploadId) {
        MultipartUploadInfo uploadMetadata = this.getUploadMetadata(bucketMetadata, uploadId);
        if (uploadMetadata != null) {
            return uploadMetadata.upload();
        }
        throw new IllegalArgumentException("No MultipartUpload found with uploadId: " + uploadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortMultipartUpload(BucketMetadata bucket, UUID id, String uploadId) {
        MultipartUploadInfo multipartUploadInfo = this.getMultipartUploadInfo(bucket, uploadId);
        if (multipartUploadInfo != null) {
            Object object = this.lockStore.get(UUID.fromString(uploadId));
            synchronized (object) {
                try {
                    FileUtils.deleteDirectory((File)this.getPartsFolder(bucket, uploadId).toFile());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not delete multipart-directory " + uploadId, e);
                }
                this.lockStore.remove(UUID.fromString(uploadId));
            }
        }
    }

    public String putPart(BucketMetadata bucket, UUID id, String uploadId, String partNumber, Path path, Map<String, String> encryptionHeaders) {
        File file = this.inputPathToFile(path, this.getPartPath(bucket, uploadId, partNumber), this.retainFilesOnExit);
        return DigestUtil.hexDigest(encryptionHeaders.get("x-amz-server-side-encryption-aws-kms-key-id"), file);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(BucketMetadata bucket, String key, UUID id, String uploadId, List<CompletedPart> parts, Map<String, String> encryptionHeaders, MultipartUploadInfo uploadInfo, String location) {
        if (uploadInfo == null) {
            throw new IllegalArgumentException("Unknown upload " + uploadId);
        }
        Path partFolder = this.getPartsFolder(bucket, uploadId);
        List<Path> partsPaths = parts.stream().map(part -> Paths.get(partFolder.toString(), part.partNumber() + PART_SUFFIX)).toList();
        Path tempFile = null;
        try {
            CompleteMultipartUploadResult completeMultipartUploadResult;
            block13: {
                InputStream inputStream = MultipartStore.toInputStream(partsPaths);
                try {
                    tempFile = Files.createTempFile("completeMultipartUpload", "", new FileAttribute[0]);
                    inputStream.transferTo(Files.newOutputStream(tempFile, new OpenOption[0]));
                    String checksumFor = this.checksumFor(partsPaths, uploadInfo);
                    String etag = DigestUtil.hexDigestMultipart(partsPaths);
                    this.objectStore.storeS3ObjectMetadata(bucket, id, key, uploadInfo.contentType(), uploadInfo.storeHeaders(), tempFile, uploadInfo.userMetadata(), encryptionHeaders, etag, Collections.emptyList(), uploadInfo.checksumAlgorithm(), checksumFor, uploadInfo.upload().owner(), uploadInfo.storageClass());
                    FileUtils.deleteDirectory((File)partFolder.toFile());
                    completeMultipartUploadResult = new CompleteMultipartUploadResult(location, uploadInfo.bucket(), key, etag, uploadInfo, checksumFor);
                    if (inputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("Error finishing multipart upload bucket=%s, key=%s, id=%s, uploadId=%s", bucket, key, id, uploadId), e);
                    }
                }
                inputStream.close();
            }
            return completeMultipartUploadResult;
        }
        finally {
            if (tempFile != null) {
                tempFile.toFile().delete();
            }
        }
    }

    private String checksumFor(List<Path> paths, MultipartUploadInfo uploadInfo) {
        if (uploadInfo.checksumAlgorithm() != null) {
            return DigestUtil.checksumMultipart(paths, uploadInfo.checksumAlgorithm().toAlgorithm());
        }
        return null;
    }

    public List<Part> getMultipartUploadParts(BucketMetadata bucket, UUID id, String uploadId) {
        List<Part> list;
        block8: {
            Path partsPath = this.getPartsFolder(bucket, uploadId);
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(partsPath, path -> path.getFileName().toString().endsWith(PART_SUFFIX));
            try {
                list = StreamSupport.stream(directoryStream.spliterator(), false).map(path -> {
                    String name = path.getFileName().toString();
                    String prefix = name.substring(0, name.indexOf(46));
                    int partNumber = Integer.parseInt(prefix);
                    String partMd5 = DigestUtil.hexDigest(path.toFile());
                    Date lastModified = new Date(path.toFile().lastModified());
                    return new Part(partNumber, partMd5, lastModified, path.toFile().length());
                }).sorted(Comparator.comparing(Part::partNumber)).toList();
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format("Could not read all parts. bucket=%s, id=%s, uploadId=%s", bucket, id, uploadId), e);
                }
            }
            directoryStream.close();
        }
        return list;
    }

    public String copyPart(BucketMetadata bucket, UUID id, HttpRange copyRange, String partNumber, BucketMetadata destinationBucket, UUID destinationId, String uploadId, Map<String, String> encryptionHeaders) {
        this.verifyMultipartUploadPreparation(destinationBucket, destinationId, uploadId);
        return this.copyPartToFile(bucket, id, copyRange, this.createPartFile(destinationBucket, destinationId, uploadId, partNumber));
    }

    private static InputStream toInputStream(List<Path> paths) {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        for (Path path : paths) {
            try {
                result.add(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't access path " + String.valueOf(path), e);
            }
        }
        return new SequenceInputStream(Collections.enumeration(result));
    }

    private String copyPartToFile(BucketMetadata bucket, UUID id, HttpRange copyRange, File partFile) {
        block16: {
            long from = 0L;
            S3ObjectMetadata s3ObjectMetadata = this.objectStore.getS3ObjectMetadata(bucket, id);
            long len = s3ObjectMetadata.dataPath().toFile().length();
            if (copyRange != null) {
                from = copyRange.getRangeStart(len);
                len = copyRange.getRangeEnd(len) - copyRange.getRangeStart(len) + 1L;
            }
            try (FileInputStream sourceStream = FileUtils.openInputStream((File)s3ObjectMetadata.dataPath().toFile());
                 OutputStream targetStream = Files.newOutputStream(partFile.toPath(), new OpenOption[0]);){
                long skip = sourceStream.skip(from);
                if (skip == from) {
                    IOUtils.copy((InputStream)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)sourceStream)).setMaxCount(len)).get(), (OutputStream)targetStream);
                    break block16;
                }
                throw new IllegalStateException("Could not skip exact byte range");
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not copy object. bucket=%s, id=%s, range=%s, partFile=%s", bucket, id, copyRange, partFile), e);
            }
        }
        return DigestUtil.hexDigest(partFile);
    }

    private File createPartFile(BucketMetadata bucket, UUID id, String uploadId, String partNumber) {
        if (id == null) {
            return null;
        }
        File partFile = this.getPartPath(bucket, uploadId, partNumber).toFile();
        try {
            if (!partFile.exists() && !partFile.createNewFile()) {
                throw new IllegalStateException(String.format("Could not create buffer file. bucket=%s, id=%s, uploadId=%s, partNumber=%s", bucket, id, uploadId, partNumber));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not create buffer file. bucket=%s, id=%s, uploadId=%s, partNumber=%s", bucket, id, uploadId, partNumber), e);
        }
        return partFile;
    }

    private void verifyMultipartUploadPreparation(BucketMetadata bucket, UUID id, String uploadId) {
        Path partsFolder = null;
        MultipartUploadInfo multipartUploadInfo = this.getMultipartUploadInfo(bucket, uploadId);
        if (id != null) {
            partsFolder = this.getPartsFolder(bucket, uploadId);
        }
        if (multipartUploadInfo == null || partsFolder == null || !partsFolder.toFile().exists() || !partsFolder.toFile().isDirectory()) {
            throw new IllegalStateException(String.format("Multipart Request was not prepared. bucket=%s, id=%s, uploadId=%s, partsFolder=%s", bucket, id, uploadId, partsFolder));
        }
    }

    private boolean createPartsFolder(BucketMetadata bucket, String uploadId) {
        File partsFolder = this.getPartsFolder(bucket, uploadId).toFile();
        boolean created = partsFolder.mkdirs();
        if (created && !this.retainFilesOnExit) {
            partsFolder.deleteOnExit();
        }
        return created;
    }

    private Path getMultipartsFolder(BucketMetadata bucket) {
        return Paths.get(bucket.path().toString(), MULTIPARTS_FOLDER);
    }

    private Path getPartsFolder(BucketMetadata bucket, String uploadId) {
        return this.getMultipartsFolder(bucket).resolve(uploadId);
    }

    private Path getPartPath(BucketMetadata bucket, String uploadId, String partNumber) {
        return this.getPartsFolder(bucket, uploadId).resolve(partNumber + PART_SUFFIX);
    }

    private Path getUploadMetadataPath(BucketMetadata bucket, String uploadId) {
        return this.getPartsFolder(bucket, uploadId).resolve(MULTIPART_UPLOAD_META_FILE);
    }

    private MultipartUploadInfo getUploadMetadata(BucketMetadata bucket, String uploadId) {
        Path metaPath = this.getUploadMetadataPath(bucket, uploadId);
        if (Files.exists(metaPath, new LinkOption[0])) {
            Object object = this.lockStore.get(UUID.fromString(uploadId));
            synchronized (object) {
                try {
                    return (MultipartUploadInfo)this.objectMapper.readValue(metaPath.toFile(), MultipartUploadInfo.class);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read upload metadata-file " + uploadId, e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetafile(BucketMetadata bucket, MultipartUploadInfo uploadInfo) {
        String uploadId = uploadInfo.upload().uploadId();
        try {
            Object object = this.lockStore.get(UUID.fromString(uploadId));
            synchronized (object) {
                File metaFile = this.getUploadMetadataPath(bucket, uploadId).toFile();
                if (!this.retainFilesOnExit) {
                    metaFile.deleteOnExit();
                }
                this.objectMapper.writeValue(metaFile, (Object)uploadInfo);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write upload metadata-file " + uploadId, e);
        }
    }
}

