/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import software.amazon.awssdk.utils.BinaryUtils;

public final class DigestUtil {
    private static final String DIGEST_COULD_NOT_BE_CALCULATED = "Digest could not be calculated.";

    private DigestUtil() {
    }

    public static String hexDigestMultipart(List<Path> paths) {
        return DigestUtils.md5Hex((byte[])DigestUtil.md5(null, paths)) + "-" + paths.size();
    }

    public static String hexDigest(byte[] bytes) {
        return DigestUtils.md5Hex((byte[])bytes);
    }

    public static String hexDigest(File file) {
        String string;
        block8: {
            FileInputStream is = FileUtils.openInputStream((File)file);
            try {
                string = DigestUtil.hexDigest(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(DIGEST_COULD_NOT_BE_CALCULATED, e);
                }
            }
            is.close();
        }
        return string;
    }

    public static String hexDigest(String salt, File file) {
        String string;
        block8: {
            FileInputStream is = FileUtils.openInputStream((File)file);
            try {
                string = DigestUtil.hexDigest(salt, is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(DIGEST_COULD_NOT_BE_CALCULATED, e);
                }
            }
            is.close();
        }
        return string;
    }

    public static String hexDigest(InputStream inputStream) {
        return DigestUtil.hexDigest(null, inputStream);
    }

    public static String hexDigest(String salt, InputStream inputStream) {
        return Hex.encodeHexString((byte[])DigestUtil.md5(salt, inputStream));
    }

    public static String base64Digest(InputStream inputStream) {
        return DigestUtil.base64Digest(null, inputStream);
    }

    public static String base64Digest(String salt, InputStream inputStream) {
        return Base64.encodeBase64String((byte[])DigestUtil.md5(salt, inputStream));
    }

    public static String base64Digest(byte[] binaryData) {
        return BinaryUtils.toBase64((byte[])binaryData);
    }

    private static byte[] md5(String salt, InputStream inputStream) {
        MessageDigest messageDigest = DigestUtil.messageDigest(salt);
        try {
            return DigestUtils.updateDigest((MessageDigest)messageDigest, (InputStream)inputStream).digest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not update digest.", e);
        }
    }

    private static byte[] md5(String salt, List<Path> paths) {
        byte[] allMd5s = new byte[]{};
        for (Path path : paths) {
            try {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    allMd5s = ArrayUtils.addAll((byte[])allMd5s, (byte[])DigestUtil.md5(salt, inputStream));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read from path " + String.valueOf(path), e);
            }
        }
        return allMd5s;
    }

    private static MessageDigest messageDigest(String salt) {
        MessageDigest messageDigest = DigestUtils.getMd5Digest();
        messageDigest.reset();
        if (salt != null) {
            DigestUtils.updateDigest((MessageDigest)messageDigest, (byte[])salt.getBytes(StandardCharsets.UTF_8));
        }
        return messageDigest;
    }
}

