/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import androidx.annotation.Nullable;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

class TargetUtils {
    private static final String CLASS_NAME = "TargetUtils";
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final double SECONDS_PER_MINUTE = 60.0;

    TargetUtils() {
    }

    static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    static double getUTCTimeOffsetMinutes() {
        TimeZone tz = TimeZone.getDefault();
        Date now = new Date();
        return (double)tz.getOffset(now.getTime()) / 1000.0 / 60.0;
    }

    @Nullable
    static Map<String, String> toStringMap(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        Iterator keyItr = jsonObject.keys();
        HashMap<String, String> map = new HashMap<String, String>();
        while (keyItr.hasNext()) {
            String name = (String)keyItr.next();
            try {
                map.put(name, jsonObject.getString(name));
            }
            catch (JSONException e) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"The value of [%s] is not a string: %s", (Object[])new Object[]{name, e});
            }
        }
        if (TargetUtils.isNullOrEmpty(map)) {
            return null;
        }
        return map;
    }

    static Map<String, String> extractQueryParameters(String queryString) {
        String[] paramArray;
        if (StringUtils.isNullOrEmpty((String)queryString)) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String currentParam : paramArray = queryString.split("&")) {
            String[] currentParamArray;
            if (StringUtils.isNullOrEmpty((String)currentParam) || (currentParamArray = currentParam.split("=", 2)).length != 2 || currentParamArray[0].isEmpty() || currentParamArray[1].isEmpty()) continue;
            String key = currentParamArray[0];
            String value = currentParamArray[1];
            parameters.put(key, value);
        }
        return parameters;
    }
}

