/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.target.TargetUtils;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TargetOrder {
    private static final String CLASS_NAME = "TargetOrder";
    private final String id;
    private final double total;
    private final List<String> purchasedProductIds;

    public TargetOrder(String id, double total, List<String> purchasedProductIds) {
        this.id = id;
        this.total = total;
        this.purchasedProductIds = purchasedProductIds;
    }

    public String getId() {
        return this.id;
    }

    public double getTotal() {
        return this.total;
    }

    public List<String> getPurchasedProductIds() {
        return this.purchasedProductIds;
    }

    Map<String, Object> toEventData() {
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        orderMap.put("id", this.id);
        orderMap.put("total", this.total);
        orderMap.put("purchasedProductIds", this.purchasedProductIds);
        return orderMap;
    }

    static TargetOrder fromEventData(Map<String, Object> data) {
        if (TargetUtils.isNullOrEmpty(data)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetOrder object, provided data Map is empty or null.", (Object[])new Object[0]);
            return null;
        }
        try {
            String id = DataReader.getString(data, (String)"id");
            if (StringUtils.isNullOrEmpty((String)id)) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetOrder object, provided data Map doesn't contain valid order ID.", (Object[])new Object[0]);
                return null;
            }
            double total = DataReader.getDouble(data, (String)"total");
            List purchasedProductIds = DataReader.getStringList(data, (String)"purchasedProductIds");
            return new TargetOrder(id, total, purchasedProductIds);
        }
        catch (DataReaderException e) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetOrder object, provided data contains invalid fields (%s).", (Object[])new Object[]{e.getLocalizedMessage()});
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetOrder that = (TargetOrder)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.total != that.total) {
            return false;
        }
        return this.purchasedProductIds != null ? this.purchasedProductIds.equals(that.purchasedProductIds) : that.purchasedProductIds == null;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.total, this.purchasedProductIds);
    }
}

