/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.AdobeCallbackWithError;
import com.adobe.marketing.mobile.AdobeError;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.target.AdobeTargetDetailedCallback;
import com.adobe.marketing.mobile.target.TargetExtension;
import com.adobe.marketing.mobile.target.TargetParameters;
import com.adobe.marketing.mobile.target.TargetPrefetch;
import com.adobe.marketing.mobile.target.TargetRequest;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import com.adobe.marketing.mobile.util.MapUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class Target {
    public static final Class<? extends Extension> EXTENSION = TargetExtension.class;
    static final String LOG_TAG = "Target";
    private static final String CLASS_NAME = "Target";
    public static final String EXTENSION_VERSION = "3.0.2";
    private static final String NULL_MBOX_MESSAGE = "Mbox name must not be empty or null";
    private static final String NULL_MBOXES_MESSAGE = "List of Mbox names must not be empty or null";
    private static final String NULL_REQUEST_MESSAGE = "The provided request list for mboxes is empty or null";
    private static final String NO_VALID_REQUEST_MESSAGE = "The provided request list for mboxes does not contain valid requests";
    private static final String NULL_RAW_REQUEST_MESSAGE = "The provided request map is empty or null";
    private static final long DEFAULT_TIMEOUT_MS = 5000L;
    private static boolean isResponseListenerRegistered = false;
    private static final ConcurrentHashMap<String, TargetRequest> pendingTargetRequestsMap = new ConcurrentHashMap();

    private Target() {
    }

    @NonNull
    public static String extensionVersion() {
        return EXTENSION_VERSION;
    }

    public static void prefetchContent(@NonNull List<TargetPrefetch> mboxPrefetchList, @Nullable TargetParameters parameters, final @Nullable AdobeCallback<String> callback) {
        AdobeCallbackWithError callbackWithError;
        AdobeCallbackWithError adobeCallbackWithError = callbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        if (mboxPrefetchList == null || mboxPrefetchList.isEmpty()) {
            String error = String.format("Failed to prefetch Target request (%s).", NULL_REQUEST_MESSAGE);
            Log.warning((String)"Target", (String)"Target", (String)error, (Object[])new Object[0]);
            if (callbackWithError != null) {
                callbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
            } else if (callback != null) {
                callback.call((Object)error);
            }
            return;
        }
        ArrayList<Map<String, Object>> flattenedPrefetchRequests = new ArrayList<Map<String, Object>>();
        for (TargetPrefetch prefetch : mboxPrefetchList) {
            if (prefetch == null) continue;
            flattenedPrefetchRequests.add(prefetch.toEventData());
        }
        if (flattenedPrefetchRequests.isEmpty()) {
            String error = String.format("Failed to prefetch Target request (%s).", NO_VALID_REQUEST_MESSAGE);
            Log.warning((String)"Target", (String)"Target", (String)error, (Object[])new Object[0]);
            if (callbackWithError != null) {
                callbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
            } else if (callback != null) {
                callback.call((Object)error);
            }
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("prefetch", flattenedPrefetchRequests);
        if (parameters != null) {
            eventData.put("targetparams", parameters.toEventData());
        }
        Event event = new Event.Builder("TargetPrefetchRequest", "com.adobe.eventType.target", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void fail(AdobeError adobeError) {
                if (callbackWithError != null) {
                    callbackWithError.fail(adobeError);
                }
            }

            public void call(Event event) {
                Map eventData = event.getEventData();
                if (MapUtils.isNullOrEmpty((Map)eventData)) {
                    if (callbackWithError != null) {
                        callbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
                    }
                    return;
                }
                String prefetchError = DataReader.optString((Map)eventData, (String)"prefetcherror", null);
                callback.call((Object)prefetchError);
            }
        });
    }

    public static void retrieveLocationContent(@NonNull List<TargetRequest> mboxRequestList, @Nullable TargetParameters parameters) {
        if (mboxRequestList == null || mboxRequestList.isEmpty()) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to retrieve Target location content (%s).", (Object[])new Object[]{NULL_REQUEST_MESSAGE});
            return;
        }
        ArrayList<TargetRequest> mboxRequestListCopy = new ArrayList<TargetRequest>(mboxRequestList);
        ArrayList<Map<String, Object>> flattenedLocationRequests = new ArrayList<Map<String, Object>>();
        HashMap<String, TargetRequest> tempIdToRequestMap = new HashMap<String, TargetRequest>();
        for (TargetRequest request : mboxRequestListCopy) {
            if (request == null) continue;
            AdobeCallback<String> callback = request.getContentCallback();
            AdobeTargetDetailedCallback contentWithDataCallback = request.getContentWithDataCallback();
            String mboxName = request.getMboxName();
            if (StringUtils.isNullOrEmpty((String)mboxName)) {
                Log.warning((String)"Target", (String)"Target", (String)"Failed to retrieve Target location content (%s), returning default content.", (Object[])new Object[]{NULL_MBOX_MESSAGE});
                String defaultContent = request.getDefaultContent();
                if (contentWithDataCallback != null) {
                    contentWithDataCallback.call(defaultContent, null);
                    continue;
                }
                if (callback == null) continue;
                callback.call((Object)defaultContent);
                continue;
            }
            String responsePairId = UUID.randomUUID().toString();
            request.setResponsePairId(responsePairId);
            tempIdToRequestMap.put(responsePairId, request);
            flattenedLocationRequests.add(request.toEventData());
        }
        if (flattenedLocationRequests.isEmpty()) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to retrieve Target location content (%s).", (Object[])new Object[]{NO_VALID_REQUEST_MESSAGE});
            return;
        }
        Target.registerResponseContentEventListener();
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("request", flattenedLocationRequests);
        if (parameters != null) {
            eventData.put("targetparams", parameters.toEventData());
        }
        Event event = new Event.Builder("TargetLoadRequest", "com.adobe.eventType.target", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        for (Map.Entry entry : tempIdToRequestMap.entrySet()) {
            pendingTargetRequestsMap.put(event.getUniqueIdentifier() + "-" + (String)entry.getKey(), (TargetRequest)entry.getValue());
        }
        MobileCore.dispatchEvent((Event)event);
    }

    public static void displayedLocations(@NonNull List<String> mboxNames, @Nullable TargetParameters targetParameters) {
        if (mboxNames == null || mboxNames.size() == 0) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to send display notification (%s).", (Object[])new Object[]{NULL_MBOXES_MESSAGE});
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("islocationdisplayed", true);
        eventData.put("names", mboxNames);
        if (targetParameters != null) {
            eventData.put("targetparams", targetParameters.toEventData());
        }
        Event event = new Event.Builder("TargetLocationsDisplayed", "com.adobe.eventType.target", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void clickedLocation(@NonNull String mboxName, @Nullable TargetParameters parameters) {
        if (StringUtils.isNullOrEmpty((String)mboxName)) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to send click notification (%s).", (Object[])new Object[]{NULL_MBOX_MESSAGE});
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("islocationclicked", true);
        eventData.put("name", mboxName);
        if (parameters != null) {
            eventData.put("targetparams", parameters.toEventData());
        }
        Event event = new Event.Builder("TargetLocationClicked", "com.adobe.eventType.target", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void getThirdPartyId(final @NonNull AdobeCallback<String> callback) {
        if (callback == null) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to get Target session ID, provided AdobeCallback (callback) is null.", (Object[])new Object[0]);
            return;
        }
        Event event = new Event.Builder("TargetGetThirdPartyIdentifier", "com.adobe.eventType.target", "com.adobe.eventSource.requestIdentity").build();
        final AdobeCallbackWithError callbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void fail(AdobeError adobeError) {
                if (callbackWithError != null) {
                    callbackWithError.fail(adobeError);
                }
            }

            public void call(Event event) {
                Map eventData = event.getEventData();
                if (MapUtils.isNullOrEmpty((Map)eventData)) {
                    if (callbackWithError != null) {
                        callbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
                    }
                    return;
                }
                String responseData = (String)eventData.get("thirdpartyid");
                callback.call((Object)responseData);
            }
        });
    }

    public static void setThirdPartyId(@Nullable String thirdPartyId) {
        HashMap<String, String> eventData = new HashMap<String, String>();
        eventData.put("thirdpartyid", thirdPartyId);
        Event event = new Event.Builder("TargetSetThirdPartyIdentifier", "com.adobe.eventType.target", "com.adobe.eventSource.requestIdentity").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void getTntId(final @NonNull AdobeCallback<String> callback) {
        if (callback == null) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to get Target session ID, provided AdobeCallback (callback) is null.", (Object[])new Object[0]);
            return;
        }
        Event event = new Event.Builder("TargetGetTnTIdentifier", "com.adobe.eventType.target", "com.adobe.eventSource.requestIdentity").build();
        final AdobeCallbackWithError callbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void fail(AdobeError adobeError) {
                if (callbackWithError != null) {
                    callbackWithError.fail(adobeError);
                }
            }

            public void call(Event event) {
                Map eventData = event.getEventData();
                if (MapUtils.isNullOrEmpty((Map)eventData)) {
                    if (callbackWithError != null) {
                        callbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
                    }
                    return;
                }
                String responseData = (String)eventData.get("tntid");
                callback.call((Object)responseData);
            }
        });
    }

    public static void setTntId(@Nullable String tntId) {
        HashMap<String, String> eventData = new HashMap<String, String>();
        eventData.put("tntid", tntId);
        Event event = new Event.Builder("TargetSetTnTIdentifier", "com.adobe.eventType.target", "com.adobe.eventSource.requestIdentity").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void getSessionId(final @NonNull AdobeCallback<String> callback) {
        if (callback == null) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to get Target session ID, provided AdobeCallback (callback) is null.", (Object[])new Object[0]);
            return;
        }
        Event event = new Event.Builder("TargetGetSessionIdentifier", "com.adobe.eventType.target", "com.adobe.eventSource.requestIdentity").build();
        final AdobeCallbackWithError callbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void fail(AdobeError adobeError) {
                if (callbackWithError != null) {
                    callbackWithError.fail(adobeError);
                }
            }

            public void call(Event event) {
                Map eventData = event.getEventData();
                if (MapUtils.isNullOrEmpty((Map)eventData)) {
                    if (callbackWithError != null) {
                        callbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
                    }
                    return;
                }
                String responseData = (String)eventData.get("sessionid");
                callback.call((Object)responseData);
            }
        });
    }

    public static void setSessionId(@Nullable String sessionId) {
        HashMap<String, String> eventData = new HashMap<String, String>();
        eventData.put("sessionid", sessionId);
        Event event = new Event.Builder("TargetSetSessionIdentifier", "com.adobe.eventType.target", "com.adobe.eventSource.requestIdentity").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void resetExperience() {
        HashMap<String, Boolean> eventData = new HashMap<String, Boolean>();
        eventData.put("resetexperience", true);
        Event event = new Event.Builder("TargetRequestReset", "com.adobe.eventType.target", "com.adobe.eventSource.requestReset").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void clearPrefetchCache() {
        HashMap<String, Boolean> eventData = new HashMap<String, Boolean>();
        eventData.put("clearcache", true);
        Event event = new Event.Builder("TargetClearPrefetchCache", "com.adobe.eventType.target", "com.adobe.eventSource.requestReset").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void setPreviewRestartDeepLink(@NonNull Uri deepLink) {
        if (deepLink == null) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to set preview restart deeplink as the provided value is null.", (Object[])new Object[0]);
            return;
        }
        HashMap<String, String> eventData = new HashMap<String, String>();
        eventData.put("restartdeeplink", deepLink.toString());
        Event event = new Event.Builder("TargetSetPreviewRestartDeeplink", "com.adobe.eventType.target", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void executeRawRequest(@NonNull Map<String, Object> request, final @NonNull AdobeCallback<Map<String, Object>> callback) {
        AdobeCallbackWithError callbackWithError;
        AdobeCallbackWithError adobeCallbackWithError = callbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        if (MapUtils.isNullOrEmpty(request)) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to execute raw Target request (%s).", (Object[])new Object[]{NULL_RAW_REQUEST_MESSAGE});
            if (callbackWithError != null) {
                callbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
            } else if (callback != null) {
                callback.call(null);
            }
            return;
        }
        if (!request.containsKey("execute") && !request.containsKey("prefetch")) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to execute raw Target request, provided request doesn't contain prefetch or execute data.", (Object[])new Object[0]);
            if (callbackWithError != null) {
                callbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
            } else if (callback != null) {
                callback.call(null);
            }
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>(request);
        eventData.put("israwevent", true);
        Event event = new Event.Builder("TargetRawRequest", "com.adobe.eventType.target", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void fail(AdobeError adobeError) {
                if (callbackWithError != null) {
                    callbackWithError.fail(adobeError);
                }
            }

            public void call(Event event) {
                Map eventData = event.getEventData();
                if (MapUtils.isNullOrEmpty((Map)eventData)) {
                    if (callbackWithError != null) {
                        callbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
                    }
                    return;
                }
                Map responseData = DataReader.optTypedMap(Object.class, (Map)eventData, (String)"responsedata", null);
                callback.call((Object)responseData);
            }
        });
    }

    public static void sendRawNotifications(@NonNull Map<String, Object> request) {
        if (MapUtils.isNullOrEmpty(request)) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to send raw Target notification(s) (%s).", (Object[])new Object[]{NULL_RAW_REQUEST_MESSAGE});
            return;
        }
        if (!request.containsKey("notifications")) {
            Log.warning((String)"Target", (String)"Target", (String)"Failed to send raw Target notification(s), provided request doesn't contain notifications data.", (Object[])new Object[0]);
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>(request);
        eventData.put("israwevent", true);
        Event event = new Event.Builder("TargetRawNotifications", "com.adobe.eventType.target", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    private static void registerResponseContentEventListener() {
        if (!isResponseListenerRegistered) {
            MobileCore.registerEventListener((String)"com.adobe.eventType.target", (String)"com.adobe.eventSource.responseContent", event -> {
                if (!event.getName().equals("TargetRequestResponse")) {
                    return;
                }
                Map eventData = event.getEventData();
                if (MapUtils.isNullOrEmpty((Map)eventData)) {
                    Log.debug((String)"Target", (String)"Target", (String)"Cannot find target request, response event data is null or empty.", (Object[])new Object[0]);
                    return;
                }
                String id = null;
                try {
                    id = DataReader.getString((Map)eventData, (String)"responseEventId");
                }
                catch (DataReaderException e) {
                    Log.debug((String)"Target", (String)"Target", (String)"Cannot find target request, responseEventId is invalid (%s).", (Object[])new Object[]{e.getLocalizedMessage()});
                }
                if (StringUtils.isNullOrEmpty((String)id)) {
                    Log.debug((String)"Target", (String)"Target", (String)"Cannot find target request, responseEventId is not available.", (Object[])new Object[0]);
                    return;
                }
                String responsePairId = null;
                try {
                    responsePairId = DataReader.getString((Map)eventData, (String)"responsePairId");
                }
                catch (DataReaderException e) {
                    Log.debug((String)"Target", (String)"Target", (String)"Cannot find target request, responsePairId is invalid (%s).", (Object[])new Object[]{e.getLocalizedMessage()});
                }
                if (StringUtils.isNullOrEmpty((String)responsePairId)) {
                    Log.debug((String)"Target", (String)"Target", (String)"Cannot find target request, responsePairId is not available.", (Object[])new Object[0]);
                    return;
                }
                String requestSearchId = id + "-" + responsePairId;
                TargetRequest request = pendingTargetRequestsMap.get(requestSearchId);
                if (request == null) {
                    Log.warning((String)"Target", (String)"Target", (String)"Missing target request for (%s)", (Object[])new Object[]{requestSearchId});
                    return;
                }
                AdobeCallback<String> callback = request.getContentCallback();
                AdobeTargetDetailedCallback contentWithDataCallback = request.getContentWithDataCallback();
                try {
                    if (contentWithDataCallback != null) {
                        Map<String, Object> mboxPayloadMap = Target.createMboxPayloadMap(DataReader.optTypedMap(Object.class, (Map)eventData, (String)"data", null), request);
                        String content = DataReader.optString((Map)eventData, (String)"content", (String)request.getDefaultContent());
                        contentWithDataCallback.call(content, mboxPayloadMap);
                    } else if (callback != null) {
                        callback.call((Object)DataReader.optString((Map)eventData, (String)"content", (String)request.getDefaultContent()));
                    }
                }
                catch (Exception e) {
                    Log.warning((String)"Target", (String)"Target", (String)"Exception (%s) when calling provided AdobeCallback.", (Object[])new Object[]{e.getLocalizedMessage()});
                }
            });
            isResponseListenerRegistered = true;
        }
    }

    private static Map<String, Object> createMboxPayloadMap(Map<String, Object> data, TargetRequest request) {
        Map clickMetricA4TParams;
        Map responseTokens;
        if (MapUtils.isNullOrEmpty(data)) {
            Log.debug((String)"Target", (String)"Target", (String)"The data payload map containing response tokens and analytics payload is not present for the mbox location (%s)", (Object[])new Object[]{request.getMboxName()});
            return null;
        }
        HashMap<String, Object> mboxPayload = new HashMap<String, Object>();
        Map a4tParams = DataReader.optStringMap(data, (String)"analytics.payload", null);
        if (a4tParams != null) {
            Log.trace((String)"Target", (String)"Target", (String)"A4t params map is present for mbox location (%s)", (Object[])new Object[]{request.getMboxName()});
            mboxPayload.put("analytics.payload", a4tParams);
        }
        if ((responseTokens = DataReader.optTypedMap(Object.class, data, (String)"responseTokens", null)) != null) {
            Log.trace((String)"Target", (String)"Target", (String)"Response tokens map is present for mbox location (%s)", (Object[])new Object[]{request.getMboxName()});
            mboxPayload.put("responseTokens", responseTokens);
        }
        if ((clickMetricA4TParams = DataReader.optStringMap(data, (String)"clickmetric.analytics.payload", null)) != null) {
            Log.trace((String)"Target", (String)"Target", (String)"Click metrics map is present for mbox location (%s)", (Object[])new Object[]{request.getMboxName()});
            mboxPayload.put("clickmetric.analytics.payload", clickMetricA4TParams);
        }
        if (mboxPayload.isEmpty()) {
            Log.debug((String)"Target", (String)"Target", (String)"Neither response tokens are activated on Target UI nor activity is A4T enabled, returning null data payload for mbox location (%s)", (Object[])new Object[]{request.getMboxName()});
            return null;
        }
        return mboxPayload;
    }

    @VisibleForTesting
    static void resetListeners() {
        isResponseListenerRegistered = false;
    }

    static final class EventDataKeys {
        static final String MBOX_NAME = "name";
        static final String MBOX_NAMES = "names";
        static final String TARGET_PARAMETERS = "targetparams";
        static final String EXECUTE = "execute";
        static final String PREFETCH = "prefetch";
        static final String LOAD_REQUEST = "request";
        static final String PREFETCH_ERROR = "prefetcherror";
        static final String IS_LOCATION_DISPLAYED = "islocationdisplayed";
        static final String IS_LOCATION_CLICKED = "islocationclicked";
        static final String THIRD_PARTY_ID = "thirdpartyid";
        static final String TNT_ID = "tntid";
        static final String SESSION_ID = "sessionid";
        static final String RESET_EXPERIENCE = "resetexperience";
        static final String CLEAR_PREFETCH_CACHE = "clearcache";
        static final String PREVIEW_RESTART_DEEP_LINK = "restartdeeplink";
        static final String IS_RAW_EVENT = "israwevent";
        static final String NOTIFICATIONS = "notifications";
        static final String RESPONSE_DATA = "responsedata";
        static final String TARGET_RESPONSE_EVENT_ID = "responseEventId";
        static final String TARGET_RESPONSE_PAIR_ID = "responsePairId";
        static final String ANALYTICS_PAYLOAD = "analytics.payload";
        static final String RESPONSE_TOKENS = "responseTokens";
        static final String CLICK_METRIC_ANALYTICS_PAYLOAD = "clickmetric.analytics.payload";
        static final String TARGET_CONTENT = "content";
        static final String TARGET_DATA_PAYLOAD = "data";

        private EventDataKeys() {
        }
    }

    static final class EventName {
        static final String PREFETCH_REQUEST = "TargetPrefetchRequest";
        static final String LOAD_REQUEST = "TargetLoadRequest";
        static final String LOCATIONS_DISPLAYED = "TargetLocationsDisplayed";
        static final String LOCATION_CLICKED = "TargetLocationClicked";
        static final String TARGET_REQUEST_RESPONSE = "TargetRequestResponse";
        static final String GET_THIRD_PARTY_ID = "TargetGetThirdPartyIdentifier";
        static final String SET_THIRD_PARTY_ID = "TargetSetThirdPartyIdentifier";
        static final String GET_TNT_ID = "TargetGetTnTIdentifier";
        static final String SET_TNT_ID = "TargetSetTnTIdentifier";
        static final String GET_SESSION_ID = "TargetGetSessionIdentifier";
        static final String SET_SESSION_ID = "TargetSetSessionIdentifier";
        static final String REQUEST_RESET = "TargetRequestReset";
        static final String CLEAR_PREFETCH_CACHE = "TargetClearPrefetchCache";
        static final String SET_PREVIEW_DEEPLINK = "TargetSetPreviewRestartDeeplink";
        static final String TARGET_RAW_REQUEST = "TargetRawRequest";
        static final String TARGET_RAW_NOTIFICATIONS = "TargetRawNotifications";

        private EventName() {
        }
    }

    static final class EventType {
        static final String TARGET = "com.adobe.eventType.target";

        private EventType() {
        }
    }

    static final class EventSource {
        static final String REQUEST_CONTENT = "com.adobe.eventSource.requestContent";
        static final String RESPONSE_CONTENT = "com.adobe.eventSource.responseContent";
        static final String REQUEST_IDENTITY = "com.adobe.eventSource.requestIdentity";
        static final String REQUEST_RESET = "com.adobe.eventSource.requestReset";

        private EventSource() {
        }
    }
}

