/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.util;

import android.os.Bundle;
import com.adobe.marketing.mobile.notificationbuilder.internal.util.NotificationData;
import com.adobe.marketing.mobile.util.DataReader;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/MapData;", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;", "data", "", "", "(Ljava/util/Map;)V", "getBoolean", "", "key", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getBundle", "Landroid/os/Bundle;", "getInteger", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "getString", "notificationbuilder_phoneRelease"})
public final class MapData
implements NotificationData {
    @NotNull
    private final Map<String, String> data;

    public MapData(@NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data = data;
    }

    @Override
    @Nullable
    public String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return DataReader.optString(this.data, (String)key, null);
    }

    @Override
    @Nullable
    public Integer getInteger(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = DataReader.optString(this.data, (String)key, null);
        return string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = DataReader.optString(this.data, (String)key, null);
        return string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
    }

    @Override
    @Nullable
    public Long getLong(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = DataReader.optString(this.data, (String)key, null);
        return string != null ? StringsKt.toLongOrNull((String)string) : null;
    }

    @Override
    @NotNull
    public Bundle getBundle() {
        Bundle bundle = new Bundle();
        for (String key : this.data.keySet()) {
            bundle.putString(key, this.data.get(key));
        }
        return bundle;
    }

    @Override
    @NotNull
    public String getRequiredString(@NotNull String key) {
        return NotificationData.DefaultImpls.getRequiredString(this, key);
    }
}

