/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.templates;

import com.adobe.marketing.mobile.notificationbuilder.internal.templates.AEPPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.util.NotificationData;
import com.adobe.marketing.mobile.services.Log;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000b\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0014\u0010\u001c\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\r\u00a8\u0006 "}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductCatalogPushTemplate;", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/AEPPushTemplate;", "data", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;", "(Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;)V", "catalogItems", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductCatalogPushTemplate$CatalogItem;", "getCatalogItems$notificationbuilder_phoneRelease", "()Ljava/util/List;", "ctaButtonColor", "", "getCtaButtonColor$notificationbuilder_phoneRelease", "()Ljava/lang/String;", "ctaButtonText", "getCtaButtonText$notificationbuilder_phoneRelease", "ctaButtonTextColor", "getCtaButtonTextColor$notificationbuilder_phoneRelease", "ctaButtonUri", "getCtaButtonUri$notificationbuilder_phoneRelease", "currentIndex", "", "getCurrentIndex$notificationbuilder_phoneRelease", "()I", "setCurrentIndex$notificationbuilder_phoneRelease", "(I)V", "displayLayout", "getDisplayLayout$notificationbuilder_phoneRelease", "rawCatalogItems", "getRawCatalogItems$notificationbuilder_phoneRelease", "CatalogItem", "Companion", "notificationbuilder_phoneRelease"})
public final class ProductCatalogPushTemplate
extends AEPPushTemplate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String ctaButtonText;
    @NotNull
    private final String ctaButtonColor;
    @NotNull
    private final String ctaButtonTextColor;
    @NotNull
    private final String ctaButtonUri;
    @NotNull
    private final String displayLayout;
    @NotNull
    private final String rawCatalogItems;
    @NotNull
    private final List<CatalogItem> catalogItems;
    private int currentIndex;
    @NotNull
    private static final String SELF_TAG = "ProductCatalogPushTemplate";

    public ProductCatalogPushTemplate(@NotNull NotificationData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data, null);
        this.ctaButtonText = data.getRequiredString("adb_cta_txt");
        this.ctaButtonColor = data.getRequiredString("adb_cta_clr");
        this.ctaButtonTextColor = data.getRequiredString("adb_cta_txt_clr");
        this.ctaButtonUri = data.getRequiredString("adb_cta_uri");
        this.displayLayout = data.getRequiredString("adb_display");
        this.rawCatalogItems = data.getRequiredString("adb_items");
        this.catalogItems = ProductCatalogPushTemplate.Companion.parseCatalogItemsFromString(this.rawCatalogItems);
        Integer n = data.getInteger("catalogItemIndex");
        this.currentIndex = n != null ? n : 0;
    }

    @NotNull
    public final String getCtaButtonText$notificationbuilder_phoneRelease() {
        return this.ctaButtonText;
    }

    @NotNull
    public final String getCtaButtonColor$notificationbuilder_phoneRelease() {
        return this.ctaButtonColor;
    }

    @NotNull
    public final String getCtaButtonTextColor$notificationbuilder_phoneRelease() {
        return this.ctaButtonTextColor;
    }

    @NotNull
    public final String getCtaButtonUri$notificationbuilder_phoneRelease() {
        return this.ctaButtonUri;
    }

    @NotNull
    public final String getDisplayLayout$notificationbuilder_phoneRelease() {
        return this.displayLayout;
    }

    @NotNull
    public final String getRawCatalogItems$notificationbuilder_phoneRelease() {
        return this.rawCatalogItems;
    }

    @NotNull
    public final List<CatalogItem> getCatalogItems$notificationbuilder_phoneRelease() {
        return this.catalogItems;
    }

    public final int getCurrentIndex$notificationbuilder_phoneRelease() {
        return this.currentIndex;
    }

    public final void setCurrentIndex$notificationbuilder_phoneRelease(int n) {
        this.currentIndex = n;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductCatalogPushTemplate$CatalogItem;", "", "title", "", "body", "img", "price", "uri", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "getImg", "getPrice", "getTitle", "getUri", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "notificationbuilder_phoneRelease"})
    public static final class CatalogItem {
        @NotNull
        private final String title;
        @NotNull
        private final String body;
        @NotNull
        private final String img;
        @NotNull
        private final String price;
        @NotNull
        private final String uri;

        public CatalogItem(@NotNull String title, @NotNull String body, @NotNull String img, @NotNull String price, @NotNull String uri) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)img, (String)"img");
            Intrinsics.checkNotNullParameter((Object)price, (String)"price");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.title = title;
            this.body = body;
            this.img = img;
            this.price = price;
            this.uri = uri;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final String getImg() {
            return this.img;
        }

        @NotNull
        public final String getPrice() {
            return this.price;
        }

        @NotNull
        public final String getUri() {
            return this.uri;
        }

        @NotNull
        public final String component1() {
            return this.title;
        }

        @NotNull
        public final String component2() {
            return this.body;
        }

        @NotNull
        public final String component3() {
            return this.img;
        }

        @NotNull
        public final String component4() {
            return this.price;
        }

        @NotNull
        public final String component5() {
            return this.uri;
        }

        @NotNull
        public final CatalogItem copy(@NotNull String title, @NotNull String body, @NotNull String img, @NotNull String price, @NotNull String uri) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)img, (String)"img");
            Intrinsics.checkNotNullParameter((Object)price, (String)"price");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return new CatalogItem(title, body, img, price, uri);
        }

        public static /* synthetic */ CatalogItem copy$default(CatalogItem catalogItem, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = catalogItem.title;
            }
            if ((n & 2) != 0) {
                string2 = catalogItem.body;
            }
            if ((n & 4) != 0) {
                string3 = catalogItem.img;
            }
            if ((n & 8) != 0) {
                string4 = catalogItem.price;
            }
            if ((n & 0x10) != 0) {
                string5 = catalogItem.uri;
            }
            return catalogItem.copy(string, string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "CatalogItem(title=" + this.title + ", body=" + this.body + ", img=" + this.img + ", price=" + this.price + ", uri=" + this.uri + ')';
        }

        public int hashCode() {
            int result = this.title.hashCode();
            result = result * 31 + this.body.hashCode();
            result = result * 31 + this.img.hashCode();
            result = result * 31 + this.price.hashCode();
            result = result * 31 + this.uri.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CatalogItem)) {
                return false;
            }
            CatalogItem catalogItem = (CatalogItem)other;
            if (!Intrinsics.areEqual((Object)this.title, (Object)catalogItem.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.body, (Object)catalogItem.body)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.img, (Object)catalogItem.img)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.price, (Object)catalogItem.price)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uri, (Object)catalogItem.uri);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductCatalogPushTemplate$Companion;", "", "()V", "SELF_TAG", "", "parseCatalogItemsFromString", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductCatalogPushTemplate$CatalogItem;", "catalogItemsString", "notificationbuilder_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        private final List<CatalogItem> parseCatalogItemsFromString(String catalogItemsString) {
            List catalogItems = new ArrayList();
            JSONArray jsonArray = null;
            try {
                jsonArray = new JSONArray(catalogItemsString);
            }
            catch (JSONException e) {
                Log.error((String)"PushTemplates", (String)ProductCatalogPushTemplate.SELF_TAG, (String)("Exception occurred when creating json array from the catalog items string: " + e.getLocalizedMessage()), (Object[])new Object[0]);
                throw new IllegalArgumentException("Catalog items string containing a valid json array was not found.");
            }
            if (jsonArray.length() != 3) {
                throw new IllegalArgumentException("3 catalog items are required for a Product Catalog notification.");
            }
            int n = jsonArray.length();
            for (int i = 0; i < n; ++i) {
                try {
                    JSONObject item = jsonArray.getJSONObject(i);
                    String title = item.getString("title");
                    String body = item.getString("body");
                    String image = item.getString("img");
                    String price = item.getString("price");
                    String uri = item.getString("uri");
                    Intrinsics.checkNotNullExpressionValue((Object)title, (String)"title");
                    Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
                    Intrinsics.checkNotNullExpressionValue((Object)image, (String)"image");
                    Intrinsics.checkNotNullExpressionValue((Object)price, (String)"price");
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                    catalogItems.add(new CatalogItem(title, body, image, price, uri));
                    continue;
                }
                catch (JSONException e) {
                    Log.error((String)"PushTemplates", (String)ProductCatalogPushTemplate.SELF_TAG, (String)("Failed to parse catalog item at index " + i + ": " + e.getLocalizedMessage()), (Object[])new Object[0]);
                    throw new IllegalArgumentException("3 catalog items are required for a Product Catalog notification.");
                }
            }
            return catalogItems;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

