/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.templates;

import com.adobe.marketing.mobile.notificationbuilder.PushTemplateConstants;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.AEPPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.util.NotificationData;
import com.adobe.marketing.mobile.services.Log;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/MultiIconPushTemplate;", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/AEPPushTemplate;", "data", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;", "(Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;)V", "SELF_TAG", "", "cancelIcon", "getCancelIcon$notificationbuilder_phoneRelease", "()Ljava/lang/String;", "setCancelIcon$notificationbuilder_phoneRelease", "(Ljava/lang/String;)V", "templateItemList", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/MultiIconPushTemplate$MultiIconTemplateItem;", "getTemplateItemList$notificationbuilder_phoneRelease", "()Ljava/util/List;", "getIconItemFromJsonObject", "jsonObject", "Lorg/json/JSONObject;", "getTemplateItemList", "templateIconListJsonString", "MultiIconTemplateItem", "notificationbuilder_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nMultiIconPushTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiIconPushTemplate.kt\ncom/adobe/marketing/mobile/notificationbuilder/internal/templates/MultiIconPushTemplate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class MultiIconPushTemplate
extends AEPPushTemplate {
    @NotNull
    private final String SELF_TAG;
    @NotNull
    private final List<MultiIconTemplateItem> templateItemList;
    @Nullable
    private String cancelIcon;

    public MultiIconPushTemplate(@NotNull NotificationData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data, null);
        this.SELF_TAG = "MultiIconNotificationTemplate";
        String itemsJson = data.getRequiredString("adb_items");
        List<MultiIconTemplateItem> list = this.getTemplateItemList(itemsJson);
        if (list == null) {
            throw new IllegalArgumentException("Required field \"adb_items\" is invalid.");
        }
        this.templateItemList = list;
        if (this.templateItemList.size() < 3 || this.templateItemList.size() > 5) {
            throw new IllegalArgumentException("\"adb_items\" field must have 3 to 5 valid items");
        }
        this.cancelIcon = data.getString("adb_cancel_image");
        CharSequence charSequence = this.cancelIcon;
        if (charSequence == null || charSequence.length() == 0) {
            this.cancelIcon = "cross";
        }
    }

    @NotNull
    public final List<MultiIconTemplateItem> getTemplateItemList$notificationbuilder_phoneRelease() {
        return this.templateItemList;
    }

    @Nullable
    public final String getCancelIcon$notificationbuilder_phoneRelease() {
        return this.cancelIcon;
    }

    public final void setCancelIcon$notificationbuilder_phoneRelease(@Nullable String string) {
        this.cancelIcon = string;
    }

    private final List<MultiIconTemplateItem> getTemplateItemList(String templateIconListJsonString) {
        CharSequence charSequence = templateIconListJsonString;
        if (charSequence == null || charSequence.length() == 0) {
            Log.warning((String)"PushTemplates", (String)this.SELF_TAG, (String)"Exception in converting rating uri json string to json array, Error : templateIconList Json String is null or empty", (Object[])new Object[0]);
            return null;
        }
        List iconItemsList = new ArrayList();
        try {
            JSONArray jsonArray = new JSONArray(templateIconListJsonString);
            int n = jsonArray.length();
            for (int i = 0; i < n; ++i) {
                MultiIconTemplateItem it;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonObject");
                MultiIconTemplateItem multiIconAction = this.getIconItemFromJsonObject(jsonObject);
                if (multiIconAction == null) continue;
                boolean bl = false;
                iconItemsList.add(it);
            }
        }
        catch (JSONException e) {
            Log.debug((String)"PushTemplates", (String)this.SELF_TAG, (String)("Exception in converting template action json string to json array, Error : " + e.getLocalizedMessage()), (Object[])new Object[0]);
            return null;
        }
        return iconItemsList;
    }

    private final MultiIconTemplateItem getIconItemFromJsonObject(JSONObject jsonObject) {
        MultiIconTemplateItem multiIconTemplateItem;
        try {
            PushTemplateConstants.ActionType actionType;
            PushTemplateConstants.ActionType actionType2;
            String imageUri = jsonObject.getString("img");
            CharSequence charSequence = imageUri;
            if (charSequence == null || charSequence.length() == 0) {
                Log.debug((String)"PushTemplates", (String)this.SELF_TAG, (String)"Image uri is empty, cannot create icon item.", (Object[])new Object[0]);
                return null;
            }
            String uri = null;
            String actionTypeString = jsonObject.getString("type");
            CharSequence charSequence2 = actionTypeString;
            if (charSequence2 == null || charSequence2.length() == 0) {
                actionType2 = PushTemplateConstants.ActionType.NONE;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)actionTypeString, (String)"actionTypeString");
                actionType2 = actionType = PushTemplateConstants.ActionType.valueOf(actionTypeString);
            }
            if ((actionType == PushTemplateConstants.ActionType.WEBURL || actionType == PushTemplateConstants.ActionType.DEEPLINK) && ((charSequence2 = (CharSequence)(uri = jsonObject.getString("uri"))) == null || charSequence2.length() == 0)) {
                Log.debug((String)"PushTemplates", (String)this.SELF_TAG, (String)("Uri is empty for action type " + (Object)((Object)actionType) + ", cannot create icon item."), (Object[])new Object[0]);
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)imageUri, (String)"imageUri");
            multiIconTemplateItem = new MultiIconTemplateItem(imageUri, actionType, uri);
        }
        catch (Exception e) {
            multiIconTemplateItem = null;
        }
        return multiIconTemplateItem;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/MultiIconPushTemplate$MultiIconTemplateItem;", "", "iconUrl", "", "actionType", "Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;", "actionUri", "(Ljava/lang/String;Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;Ljava/lang/String;)V", "getActionType", "()Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;", "getActionUri", "()Ljava/lang/String;", "getIconUrl", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "notificationbuilder_phoneRelease"})
    public static final class MultiIconTemplateItem {
        @NotNull
        private final String iconUrl;
        @NotNull
        private final PushTemplateConstants.ActionType actionType;
        @Nullable
        private final String actionUri;

        public MultiIconTemplateItem(@NotNull String iconUrl, @NotNull PushTemplateConstants.ActionType actionType, @Nullable String actionUri) {
            Intrinsics.checkNotNullParameter((Object)iconUrl, (String)"iconUrl");
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            this.iconUrl = iconUrl;
            this.actionType = actionType;
            this.actionUri = actionUri;
        }

        @NotNull
        public final String getIconUrl() {
            return this.iconUrl;
        }

        @NotNull
        public final PushTemplateConstants.ActionType getActionType() {
            return this.actionType;
        }

        @Nullable
        public final String getActionUri() {
            return this.actionUri;
        }

        @NotNull
        public final String component1() {
            return this.iconUrl;
        }

        @NotNull
        public final PushTemplateConstants.ActionType component2() {
            return this.actionType;
        }

        @Nullable
        public final String component3() {
            return this.actionUri;
        }

        @NotNull
        public final MultiIconTemplateItem copy(@NotNull String iconUrl, @NotNull PushTemplateConstants.ActionType actionType, @Nullable String actionUri) {
            Intrinsics.checkNotNullParameter((Object)iconUrl, (String)"iconUrl");
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            return new MultiIconTemplateItem(iconUrl, actionType, actionUri);
        }

        public static /* synthetic */ MultiIconTemplateItem copy$default(MultiIconTemplateItem multiIconTemplateItem, String string, PushTemplateConstants.ActionType actionType, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = multiIconTemplateItem.iconUrl;
            }
            if ((n & 2) != 0) {
                actionType = multiIconTemplateItem.actionType;
            }
            if ((n & 4) != 0) {
                string2 = multiIconTemplateItem.actionUri;
            }
            return multiIconTemplateItem.copy(string, actionType, string2);
        }

        @NotNull
        public String toString() {
            return "MultiIconTemplateItem(iconUrl=" + this.iconUrl + ", actionType=" + (Object)((Object)this.actionType) + ", actionUri=" + this.actionUri + ')';
        }

        public int hashCode() {
            int result = this.iconUrl.hashCode();
            result = result * 31 + this.actionType.hashCode();
            result = result * 31 + (this.actionUri == null ? 0 : this.actionUri.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MultiIconTemplateItem)) {
                return false;
            }
            MultiIconTemplateItem multiIconTemplateItem = (MultiIconTemplateItem)other;
            if (!Intrinsics.areEqual((Object)this.iconUrl, (Object)multiIconTemplateItem.iconUrl)) {
                return false;
            }
            if (this.actionType != multiIconTemplateItem.actionType) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.actionUri, (Object)multiIconTemplateItem.actionUri);
        }
    }
}

