/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.templates;

import com.adobe.marketing.mobile.notificationbuilder.internal.templates.AEPPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.AutoCarouselPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.ManualCarouselPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.util.NotificationData;
import com.adobe.marketing.mobile.services.Log;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/CarouselPushTemplate;", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/AEPPushTemplate;", "data", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;", "(Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;)V", "carouselItems", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/CarouselPushTemplate$CarouselItem;", "getCarouselItems$notificationbuilder_phoneRelease", "()Ljava/util/List;", "carouselLayout", "", "getCarouselLayout$notificationbuilder_phoneRelease", "()Ljava/lang/String;", "carouselMode", "getCarouselMode$notificationbuilder_phoneRelease", "rawCarouselItems", "getRawCarouselItems$notificationbuilder_phoneRelease", "CarouselItem", "Companion", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/AutoCarouselPushTemplate;", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ManualCarouselPushTemplate;", "notificationbuilder_phoneRelease"})
public abstract class CarouselPushTemplate
extends AEPPushTemplate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String carouselMode;
    @NotNull
    private final List<CarouselItem> carouselItems;
    @NotNull
    private final String carouselLayout;
    @NotNull
    private final String rawCarouselItems;
    @NotNull
    private static final String SELF_TAG = "CarouselPushTemplate";

    private CarouselPushTemplate(NotificationData data) {
        super(data, null);
        this.carouselLayout = data.getRequiredString("adb_car_layout");
        this.rawCarouselItems = data.getRequiredString("adb_items");
        String string = data.getString("adb_car_mode");
        if (string == null) {
            string = "auto";
        }
        this.carouselMode = string;
        this.carouselItems = CarouselPushTemplate.Companion.parseCarouselItemsFromString(this.rawCarouselItems);
    }

    @NotNull
    public final String getCarouselMode$notificationbuilder_phoneRelease() {
        return this.carouselMode;
    }

    @NotNull
    public final List<CarouselItem> getCarouselItems$notificationbuilder_phoneRelease() {
        return this.carouselItems;
    }

    @NotNull
    public final String getCarouselLayout$notificationbuilder_phoneRelease() {
        return this.carouselLayout;
    }

    @NotNull
    public final String getRawCarouselItems$notificationbuilder_phoneRelease() {
        return this.rawCarouselItems;
    }

    public /* synthetic */ CarouselPushTemplate(NotificationData data, DefaultConstructorMarker $constructor_marker) {
        this(data);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/CarouselPushTemplate$CarouselItem;", "", "imageUri", "", "captionText", "interactionUri", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCaptionText", "()Ljava/lang/String;", "getImageUri", "getInteractionUri", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "notificationbuilder_phoneRelease"})
    public static final class CarouselItem {
        @NotNull
        private final String imageUri;
        @Nullable
        private final String captionText;
        @Nullable
        private final String interactionUri;

        public CarouselItem(@NotNull String imageUri, @Nullable String captionText, @Nullable String interactionUri) {
            Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
            this.imageUri = imageUri;
            this.captionText = captionText;
            this.interactionUri = interactionUri;
        }

        @NotNull
        public final String getImageUri() {
            return this.imageUri;
        }

        @Nullable
        public final String getCaptionText() {
            return this.captionText;
        }

        @Nullable
        public final String getInteractionUri() {
            return this.interactionUri;
        }

        @NotNull
        public final String component1() {
            return this.imageUri;
        }

        @Nullable
        public final String component2() {
            return this.captionText;
        }

        @Nullable
        public final String component3() {
            return this.interactionUri;
        }

        @NotNull
        public final CarouselItem copy(@NotNull String imageUri, @Nullable String captionText, @Nullable String interactionUri) {
            Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
            return new CarouselItem(imageUri, captionText, interactionUri);
        }

        public static /* synthetic */ CarouselItem copy$default(CarouselItem carouselItem, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = carouselItem.imageUri;
            }
            if ((n & 2) != 0) {
                string2 = carouselItem.captionText;
            }
            if ((n & 4) != 0) {
                string3 = carouselItem.interactionUri;
            }
            return carouselItem.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "CarouselItem(imageUri=" + this.imageUri + ", captionText=" + this.captionText + ", interactionUri=" + this.interactionUri + ')';
        }

        public int hashCode() {
            int result = this.imageUri.hashCode();
            result = result * 31 + (this.captionText == null ? 0 : this.captionText.hashCode());
            result = result * 31 + (this.interactionUri == null ? 0 : this.interactionUri.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CarouselItem)) {
                return false;
            }
            CarouselItem carouselItem = (CarouselItem)other;
            if (!Intrinsics.areEqual((Object)this.imageUri, (Object)carouselItem.imageUri)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.captionText, (Object)carouselItem.captionText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.interactionUri, (Object)carouselItem.interactionUri);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/CarouselPushTemplate$Companion;", "", "()V", "SELF_TAG", "", "invoke", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/CarouselPushTemplate;", "data", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;", "parseCarouselItemsFromString", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/CarouselPushTemplate$CarouselItem;", "carouselItemsString", "notificationbuilder_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CarouselPushTemplate invoke(@NotNull NotificationData data) {
            String carouselMode;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = data.getString("adb_car_mode");
            if (string == null) {
                string = "auto";
            }
            return Intrinsics.areEqual((Object)(carouselMode = string), (Object)"auto") ? (CarouselPushTemplate)new AutoCarouselPushTemplate(data) : (CarouselPushTemplate)new ManualCarouselPushTemplate(data);
        }

        private final List<CarouselItem> parseCarouselItemsFromString(String carouselItemsString) {
            List carouselItems = new ArrayList();
            CharSequence charSequence = carouselItemsString;
            if (charSequence == null || charSequence.length() == 0) {
                Log.debug((String)"PushTemplates", (String)CarouselPushTemplate.SELF_TAG, (String)"No carousel items found in the push template.", (Object[])new Object[0]);
                return carouselItems;
            }
            try {
                JSONArray jsonArray = new JSONArray(carouselItemsString);
                int n = jsonArray.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject item = jsonArray.getJSONObject(i);
                    String imageUri = item.getString("img");
                    String captionText = item.optString("txt", "");
                    String interactionUri = item.optString("uri", "");
                    Intrinsics.checkNotNullExpressionValue((Object)imageUri, (String)"imageUri");
                    carouselItems.add(new CarouselItem(imageUri, captionText, interactionUri));
                }
            }
            catch (JSONException e) {
                Log.debug((String)"PushTemplates", (String)CarouselPushTemplate.SELF_TAG, (String)("Failed to parse carousel items from the push template: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            }
            return carouselItems;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

