/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.templates;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.notificationbuilder.PushTemplateConstants;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.AEPPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.util.NotificationData;
import com.adobe.marketing.mobile.services.Log;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0001\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/BasicPushTemplate;", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/AEPPushTemplate;", "data", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;", "(Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;)V", "SELF_TAG", "", "actionButtonsList", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/BasicPushTemplate$ActionButton;", "getActionButtonsList$notificationbuilder_phoneRelease", "()Ljava/util/List;", "actionButtonsString", "getActionButtonsString$notificationbuilder_phoneRelease", "()Ljava/lang/String;", "remindLaterDuration", "", "getRemindLaterDuration$notificationbuilder_phoneRelease", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "remindLaterText", "getRemindLaterText$notificationbuilder_phoneRelease", "remindLaterTimestamp", "", "getRemindLaterTimestamp$notificationbuilder_phoneRelease", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getActionButtonsFromString", "actionButtons", "getActionButtonsFromString$notificationbuilder_phoneRelease", "ActionButton", "notificationbuilder_phoneRelease"})
public final class BasicPushTemplate
extends AEPPushTemplate {
    @NotNull
    private final String SELF_TAG;
    @Nullable
    private final String actionButtonsString;
    @Nullable
    private final List<ActionButton> actionButtonsList;
    @Nullable
    private final String remindLaterText;
    @Nullable
    private final Long remindLaterTimestamp;
    @Nullable
    private final Integer remindLaterDuration;

    public BasicPushTemplate(@NotNull NotificationData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data, null);
        this.SELF_TAG = "BasicPushTemplate";
        this.actionButtonsString = data.getString("adb_act");
        this.actionButtonsList = this.getActionButtonsFromString$notificationbuilder_phoneRelease(this.actionButtonsString);
        this.remindLaterText = data.getString("adb_rem_txt");
        this.remindLaterTimestamp = data.getLong("adb_rem_ts");
        this.remindLaterDuration = data.getInteger("adb_rem_sec");
    }

    @Nullable
    public final String getActionButtonsString$notificationbuilder_phoneRelease() {
        return this.actionButtonsString;
    }

    @Nullable
    public final List<ActionButton> getActionButtonsList$notificationbuilder_phoneRelease() {
        return this.actionButtonsList;
    }

    @Nullable
    public final String getRemindLaterText$notificationbuilder_phoneRelease() {
        return this.remindLaterText;
    }

    @Nullable
    public final Long getRemindLaterTimestamp$notificationbuilder_phoneRelease() {
        return this.remindLaterTimestamp;
    }

    @Nullable
    public final Integer getRemindLaterDuration$notificationbuilder_phoneRelease() {
        return this.remindLaterDuration;
    }

    @VisibleForTesting
    @Nullable
    public final List<ActionButton> getActionButtonsFromString$notificationbuilder_phoneRelease(@Nullable String actionButtons) {
        if (actionButtons == null) {
            Log.debug((String)"PushTemplates", (String)this.SELF_TAG, (String)"Exception in converting actionButtons json string to json object, Error : actionButtons is null", (Object[])new Object[0]);
            return null;
        }
        List actionButtonList = new ArrayList();
        try {
            JSONArray jsonArray = new JSONArray(actionButtons);
            int n = jsonArray.length();
            for (int i = 0; i < n; ++i) {
                ActionButton button;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonObject");
                if (ActionButton.Companion.getActionButtonFromJSONObject(jsonObject) == null) continue;
                actionButtonList.add(button);
            }
        }
        catch (JSONException e) {
            Log.warning((String)"PushTemplates", (String)this.SELF_TAG, (String)("Exception in converting actionButtons json string to json object, Error : " + e.getLocalizedMessage()), (Object[])new Object[0]);
            return null;
        }
        return actionButtonList;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/BasicPushTemplate$ActionButton;", "", "label", "", "link", "type", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "getLink", "Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;", "getType", "()Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;", "Companion", "notificationbuilder_phoneRelease"})
    public static final class ActionButton {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String label;
        @Nullable
        private final String link;
        @NotNull
        private final PushTemplateConstants.ActionType type;
        @NotNull
        private static final String SELF_TAG = "ActionButton";

        /*
         * WARNING - void declaration
         */
        public ActionButton(@NotNull String label, @Nullable String link, @Nullable String type) {
            PushTemplateConstants.ActionType actionType;
            ActionButton actionButton;
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.label = label;
            this.link = link;
            ActionButton actionButton2 = this;
            try {
                actionButton = actionButton2;
                String string = type;
                if (string == null) {
                    string = "NONE";
                }
                actionType = PushTemplateConstants.ActionType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void e;
                actionButton = actionButton2;
                Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)("Invalid action button type provided, defaulting to NONE. Error : " + e.getLocalizedMessage()), (Object[])new Object[0]);
                actionType = PushTemplateConstants.ActionType.NONE;
            }
            actionButton.type = actionType;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @Nullable
        public final String getLink() {
            return this.link;
        }

        @NotNull
        public final PushTemplateConstants.ActionType getType() {
            return this.type;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/BasicPushTemplate$ActionButton$Companion;", "", "()V", "SELF_TAG", "", "getActionButtonFromJSONObject", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/BasicPushTemplate$ActionButton;", "jsonObject", "Lorg/json/JSONObject;", "notificationbuilder_phoneRelease"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final ActionButton getActionButtonFromJSONObject(@NotNull JSONObject jsonObject) {
                ActionButton actionButton;
                Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
                try {
                    String label = jsonObject.getString("label");
                    Intrinsics.checkNotNullExpressionValue((Object)label, (String)"label");
                    if (((CharSequence)label).length() == 0) {
                        Log.debug((String)"PushTemplates", (String)ActionButton.SELF_TAG, (String)"Label is empty", (Object[])new Object[0]);
                        return null;
                    }
                    String uri = null;
                    String type = jsonObject.getString("type");
                    if (Intrinsics.areEqual((Object)type, (Object)"WEBURL") || Intrinsics.areEqual((Object)type, (Object)"DEEPLINK")) {
                        uri = jsonObject.optString("uri");
                    }
                    Log.trace((String)"PushTemplates", (String)ActionButton.SELF_TAG, (String)("Creating an ActionButton with label (" + label + "), uri (" + uri + "), and type (" + type + ")."), (Object[])new Object[0]);
                    actionButton = new ActionButton(label, uri, type);
                }
                catch (JSONException e) {
                    Log.warning((String)"PushTemplates", (String)ActionButton.SELF_TAG, (String)("Exception in converting actionButtons json string to json object, Error : " + e.getLocalizedMessage() + '.'), (Object[])new Object[0]);
                    actionButton = null;
                }
                return actionButton;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

