/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.extensions;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.os.Bundle;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.notificationbuilder.PushTemplateConstants;
import com.adobe.marketing.mobile.notificationbuilder.internal.PendingIntentUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.PushTemplateImageUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.AppResourceExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.BasicPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a@\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u001a*\u0010\u0012\u001a\u00020\u0007*\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0000\u001aD\u0010\u0016\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u001a&\u0010\u001a\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000bH\u0000\u001a(\u0010\u001b\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0016\u0010\u001e\u001a\u00020\u001f*\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001e\u0010!\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"SELF_TAG", "", "isValidIcon", "", "icon", "", "addActionButtons", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "actionButtons", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/BasicPushTemplate$ActionButton;", "intentExtras", "Landroid/os/Bundle;", "setLargeIcon", "imageUrl", "title", "bodyText", "setNotificationClickAction", "actionUri", "actionType", "Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;", "setNotificationDeleteAction", "setSmallIcon", "smallIcon", "iconColor", "setSmallIconColor", "", "iconColorHex", "setSound", "customSound", "notificationbuilder_phoneRelease"})
public final class NotificationCompatBuilderExtensionsKt {
    @NotNull
    private static final String SELF_TAG = "RemoteViewExtensions";

    @NotNull
    public static final NotificationCompat.Builder setSmallIcon(@NotNull NotificationCompat.Builder $this$setSmallIcon, @NotNull Context context, @Nullable String smallIcon, @Nullable String iconColor) {
        Intrinsics.checkNotNullParameter((Object)$this$setSmallIcon, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int iconFromPayload = AppResourceExtensionsKt.getIconWithResourceName(context, smallIcon);
        int iconFromMobileCore = MobileCore.getSmallIconResourceID();
        int iconResourceId = 0;
        if (NotificationCompatBuilderExtensionsKt.isValidIcon(iconFromPayload)) {
            iconResourceId = iconFromPayload;
        } else if (NotificationCompatBuilderExtensionsKt.isValidIcon(iconFromMobileCore)) {
            iconResourceId = iconFromMobileCore;
        } else {
            int iconFromApp = AppResourceExtensionsKt.getDefaultAppIcon(context);
            if (NotificationCompatBuilderExtensionsKt.isValidIcon(iconFromApp)) {
                iconResourceId = iconFromApp;
            } else {
                Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)"No valid small icon found. Notification will not be displayed.", (Object[])new Object[0]);
                return $this$setSmallIcon;
            }
        }
        $this$setSmallIcon.setSmallIcon(iconResourceId);
        NotificationCompatBuilderExtensionsKt.setSmallIconColor($this$setSmallIcon, iconColor);
        return $this$setSmallIcon;
    }

    private static final void setSmallIconColor(NotificationCompat.Builder $this$setSmallIconColor, String iconColorHex) {
        CharSequence charSequence = iconColorHex;
        if (charSequence == null || charSequence.length() == 0) {
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Empty icon color hex string found, custom color will not be applied to the notification icon.", (Object[])new Object[0]);
            return;
        }
        try {
            int color = Color.parseColor((String)('#' + iconColorHex));
            $this$setSmallIconColor.setColorized(true).setColor(color);
        }
        catch (IllegalArgumentException exception) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)"Unrecognized hex string passed to Color.parseColor(), custom color will not be applied to the notification icon.", (Object[])new Object[0]);
        }
    }

    @NotNull
    public static final NotificationCompat.Builder setSound(@NotNull NotificationCompat.Builder $this$setSound, @NotNull Context context, @Nullable String customSound) {
        Intrinsics.checkNotNullParameter((Object)$this$setSound, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = customSound;
        if (charSequence == null || charSequence.length() == 0) {
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"No custom sound found in the push template, using the default notification sound.", (Object[])new Object[0]);
            $this$setSound.setSound(RingtoneManager.getDefaultUri((int)2));
            return $this$setSound;
        }
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Setting sound from bundle named " + customSound + '.'), (Object[])new Object[0]);
        $this$setSound.setSound(AppResourceExtensionsKt.getSoundUriForResourceName(context, customSound));
        return $this$setSound;
    }

    @NotNull
    public static final NotificationCompat.Builder setLargeIcon(@NotNull NotificationCompat.Builder $this$setLargeIcon, @Nullable String imageUrl, @Nullable String title, @Nullable String bodyText) {
        Intrinsics.checkNotNullParameter((Object)$this$setLargeIcon, (String)"<this>");
        CharSequence charSequence = imageUrl;
        if (charSequence == null || charSequence.length() == 0) {
            return $this$setLargeIcon;
        }
        int downloadedIconCount = PushTemplateImageUtils.INSTANCE.cacheImages$notificationbuilder_phoneRelease(CollectionsKt.listOf((Object)imageUrl));
        if (downloadedIconCount == 0) {
            return $this$setLargeIcon;
        }
        Bitmap bitmap = PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(imageUrl);
        $this$setLargeIcon.setLargeIcon(bitmap);
        NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
        bigPictureStyle.bigPicture(bitmap);
        bigPictureStyle.bigLargeIcon(null);
        bigPictureStyle.setBigContentTitle((CharSequence)title);
        bigPictureStyle.setSummaryText((CharSequence)bodyText);
        $this$setLargeIcon.setStyle((NotificationCompat.Style)bigPictureStyle);
        return $this$setLargeIcon;
    }

    @NotNull
    public static final NotificationCompat.Builder setNotificationClickAction(@NotNull NotificationCompat.Builder $this$setNotificationClickAction, @NotNull Context context, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable String actionUri, @Nullable PushTemplateConstants.ActionType actionType, @Nullable Bundle intentExtras) {
        Intrinsics.checkNotNullParameter((Object)$this$setNotificationClickAction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PendingIntent pendingIntent = PendingIntentUtils.INSTANCE.createPendingIntentForTrackerActivity$notificationbuilder_phoneRelease(context, trackerActivityClass, actionUri, null, actionType, intentExtras);
        $this$setNotificationClickAction.setContentIntent(pendingIntent);
        return $this$setNotificationClickAction;
    }

    @NotNull
    public static final NotificationCompat.Builder setNotificationDeleteAction(@NotNull NotificationCompat.Builder $this$setNotificationDeleteAction, @NotNull Context context, @Nullable Class<? extends Activity> trackerActivityClass) {
        Intrinsics.checkNotNullParameter((Object)$this$setNotificationDeleteAction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent deleteIntent = new Intent("Notification Dismissed");
        Class<? extends Activity> clazz = trackerActivityClass;
        if (clazz != null) {
            Class<? extends Activity> it = clazz;
            boolean bl = false;
            deleteIntent.setClass(context.getApplicationContext(), trackerActivityClass);
        }
        deleteIntent.setFlags(0x20000000);
        PendingIntent intent = PendingIntent.getActivity((Context)context, (int)new Random().nextInt(), (Intent)deleteIntent, (int)0xC000000);
        $this$setNotificationDeleteAction.setDeleteIntent(intent);
        return $this$setNotificationDeleteAction;
    }

    @NotNull
    public static final NotificationCompat.Builder addActionButtons(@NotNull NotificationCompat.Builder $this$addActionButtons, @NotNull Context context, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable List<BasicPushTemplate.ActionButton> actionButtons, @Nullable Bundle intentExtras) {
        Intrinsics.checkNotNullParameter((Object)$this$addActionButtons, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Collection collection = actionButtons;
        if (collection == null || collection.isEmpty()) {
            return $this$addActionButtons;
        }
        for (BasicPushTemplate.ActionButton eachButton : actionButtons) {
            PendingIntent pendingIntent = eachButton.getType() == PushTemplateConstants.ActionType.DEEPLINK || eachButton.getType() == PushTemplateConstants.ActionType.WEBURL ? PendingIntentUtils.INSTANCE.createPendingIntentForTrackerActivity$notificationbuilder_phoneRelease(context, trackerActivityClass, eachButton.getLink(), eachButton.getLabel(), eachButton.getType(), intentExtras) : PendingIntentUtils.INSTANCE.createPendingIntentForTrackerActivity$notificationbuilder_phoneRelease(context, trackerActivityClass, null, eachButton.getLabel(), eachButton.getType(), intentExtras);
            $this$addActionButtons.addAction(0, (CharSequence)eachButton.getLabel(), pendingIntent);
        }
        return $this$addActionButtons;
    }

    private static final boolean isValidIcon(int icon) {
        return icon > 0;
    }
}

