/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.R;
import com.adobe.marketing.mobile.notificationbuilder.internal.PushTemplateImageUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.AEPPushNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationManagerExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.RemoteViewsExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.ProductRatingPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\fJ<\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JD\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/ProductRatingNotificationBuilder;", "", "()V", "SELF_TAG", "", "construct", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "pushTemplate", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductRatingPushTemplate;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "broadcastReceiverClass", "Landroid/content/BroadcastReceiver;", "createRatingButtonPendingIntent", "Landroid/app/PendingIntent;", "channelId", "ratingButtonSelection", "", "populateRatingIcons", "", "expandedLayout", "Landroid/widget/RemoteViews;", "packageName", "channelIdToUse", "notificationbuilder_phoneRelease"})
public final class ProductRatingNotificationBuilder {
    @NotNull
    public static final ProductRatingNotificationBuilder INSTANCE = new ProductRatingNotificationBuilder();
    @NotNull
    private static final String SELF_TAG = "ProductRatingNotificationBuilder";

    private ProductRatingNotificationBuilder() {
    }

    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull ProductRatingPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass) throws NotificationConstructionFailedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Building a rating template push notification.", (Object[])new Object[0]);
        String packageName = context.getPackageName();
        RemoteViews smallLayout = new RemoteViews(packageName, R.layout.push_template_collapsed);
        RemoteViews expandedLayout = new RemoteViews(packageName, R.layout.push_template_product_rating_expanded);
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        String channelIdToUse = NotificationManagerExtensionsKt.createNotificationChannelIfRequired(notificationManager, context, pushTemplate);
        NotificationCompat.Builder notificationBuilder = AEPPushNotificationBuilder.INSTANCE.construct(context, pushTemplate, channelIdToUse, trackerActivityClass, smallLayout, expandedLayout, R.id.rating_expanded_layout);
        String imageUri = pushTemplate.getImageUrl$notificationbuilder_phoneRelease();
        int downloadedImageCount = PushTemplateImageUtils.INSTANCE.cacheImages$notificationbuilder_phoneRelease(CollectionsKt.listOf((Object)imageUri));
        if (downloadedImageCount == 0) {
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"No image found for rating push template.", (Object[])new Object[0]);
            expandedLayout.setViewVisibility(R.id.expanded_template_image, 8);
        } else {
            expandedLayout.setImageViewBitmap(R.id.expanded_template_image, PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(imageUri));
        }
        this.populateRatingIcons(context, broadcastReceiverClass, expandedLayout, pushTemplate, packageName, channelIdToUse);
        if (pushTemplate.getRatingSelected$notificationbuilder_phoneRelease() > -1) {
            expandedLayout.setViewVisibility(R.id.rating_confirm, 0);
            RemoteViewsExtensionsKt.setNotificationTitleTextColor(expandedLayout, pushTemplate.getTitleTextColor$notificationbuilder_phoneRelease(), R.id.rating_confirm);
            Bundle ratingConfirmedIntentExtras = new Bundle(pushTemplate.getData().getBundle());
            ratingConfirmedIntentExtras.putString("adb_sticky", "false");
            ProductRatingPushTemplate.RatingAction selectedRatingAction = pushTemplate.getRatingActionList$notificationbuilder_phoneRelease().get(pushTemplate.getRatingSelected$notificationbuilder_phoneRelease());
            RemoteViewsExtensionsKt.setRemoteViewClickAction(expandedLayout, context, trackerActivityClass, R.id.rating_confirm, selectedRatingAction.getLink(), String.valueOf(pushTemplate.getRatingSelected$notificationbuilder_phoneRelease()), pushTemplate.getRatingActionList$notificationbuilder_phoneRelease().get(pushTemplate.getRatingSelected$notificationbuilder_phoneRelease()).getType(), ratingConfirmedIntentExtras);
        } else {
            expandedLayout.setViewVisibility(R.id.rating_confirm, 4);
        }
        return notificationBuilder;
    }

    private final void populateRatingIcons(Context context, Class<? extends BroadcastReceiver> broadcastReceiverClass, RemoteViews expandedLayout, ProductRatingPushTemplate pushTemplate, String packageName, String channelIdToUse) {
        int n = pushTemplate.getRatingActionList$notificationbuilder_phoneRelease().size();
        for (int i = 0; i < n; ++i) {
            RemoteViews ratingIconLayout = new RemoteViews(packageName, R.layout.push_template_product_rating_icon_layout);
            int ratingIconImageView = R.id.rating_icon_image;
            if (i <= pushTemplate.getRatingSelected$notificationbuilder_phoneRelease()) {
                if (!RemoteViewsExtensionsKt.setRemoteViewImage(ratingIconLayout, pushTemplate.getRatingSelectedIcon$notificationbuilder_phoneRelease(), ratingIconImageView)) {
                    throw new NotificationConstructionFailedException("Image for selected rating icon is invalid.");
                }
            } else if (!RemoteViewsExtensionsKt.setRemoteViewImage(ratingIconLayout, pushTemplate.getRatingUnselectedIcon$notificationbuilder_phoneRelease(), ratingIconImageView)) {
                throw new NotificationConstructionFailedException("Image for unselected rating icon is invalid.");
            }
            expandedLayout.addView(R.id.rating_icons_container, ratingIconLayout);
            PendingIntent ratingButtonPendingIntent = this.createRatingButtonPendingIntent(context, broadcastReceiverClass, channelIdToUse, pushTemplate, i);
            ratingIconLayout.setOnClickPendingIntent(ratingIconImageView, ratingButtonPendingIntent);
        }
    }

    private final PendingIntent createRatingButtonPendingIntent(Context context, Class<? extends BroadcastReceiver> broadcastReceiverClass, String channelId, ProductRatingPushTemplate pushTemplate, int ratingButtonSelection) {
        if (broadcastReceiverClass == null) {
            return null;
        }
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Creating a rating click pending intent from a push template object.", (Object[])new Object[0]);
        Intent ratingButtonClickIntent = AEPPushNotificationBuilder.INSTANCE.createIntent$notificationbuilder_phoneRelease("rating_icon_clicked", pushTemplate);
        Class<? extends BroadcastReceiver> it = broadcastReceiverClass;
        boolean bl = false;
        ratingButtonClickIntent.setClass(context.getApplicationContext(), broadcastReceiverClass);
        ratingButtonClickIntent.putExtra("ratingSelected", String.valueOf(ratingButtonSelection));
        ratingButtonClickIntent.putExtra("adb_channel_id", channelId);
        String string = pushTemplate.getTag$notificationbuilder_phoneRelease();
        return PendingIntent.getBroadcast((Context)context, (int)((string != null ? string.hashCode() : 0) + ratingButtonSelection), (Intent)ratingButtonClickIntent, (int)0xA000000);
    }
}

