/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import com.adobe.marketing.mobile.notificationbuilder.PushTemplateConstants;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NetworkCallback;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.services.caching.CacheEntry;
import com.adobe.marketing.mobile.services.caching.CacheExpiry;
import com.adobe.marketing.mobile.services.caching.CacheResult;
import com.adobe.marketing.mobile.services.caching.CacheService;
import com.adobe.marketing.mobile.util.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u001d\u0010\u0012\u001a\u00020\u00042\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0014H\u0000\u00a2\u0006\u0002\b\u0015J&\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00072\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\r0\u0019H\u0002J\u000f\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u001cJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u001eJ\u001e\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/PushTemplateImageUtils;", "", "()V", "DOWNLOAD_TIMEOUT_SECS", "", "FULL_BITMAP_QUALITY", "SELF_TAG", "", "bitmapToInputStream", "Ljava/io/InputStream;", "bitmap", "Landroid/graphics/Bitmap;", "cacheBitmapInputStream", "", "cacheService", "Lcom/adobe/marketing/mobile/services/caching/CacheService;", "bitmapInputStream", "imageUrl", "cacheImages", "urlList", "", "cacheImages$notificationbuilder_phoneRelease", "downloadImage", "url", "completionCallback", "Lkotlin/Function1;", "Lcom/adobe/marketing/mobile/services/HttpConnecting;", "getAssetCacheLocation", "getAssetCacheLocation$notificationbuilder_phoneRelease", "getCachedImage", "getCachedImage$notificationbuilder_phoneRelease", "handleDownloadResponse", "connection", "scaleBitmap", "downloadedBitmap", "notificationbuilder_phoneRelease"})
public final class PushTemplateImageUtils {
    @NotNull
    public static final PushTemplateImageUtils INSTANCE = new PushTemplateImageUtils();
    @NotNull
    private static final String SELF_TAG = "PushTemplateImageUtil";
    private static final int FULL_BITMAP_QUALITY = 100;
    private static final int DOWNLOAD_TIMEOUT_SECS = 10;

    private PushTemplateImageUtils() {
    }

    public final int cacheImages$notificationbuilder_phoneRelease(@NotNull List<String> urlList) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(urlList, (String)"urlList");
        String assetCacheLocation = this.getAssetCacheLocation$notificationbuilder_phoneRelease();
        if (urlList.isEmpty() || (charSequence = (CharSequence)assetCacheLocation) == null || charSequence.length() == 0) {
            return 0;
        }
        CacheService cacheService = ServiceProvider.getInstance().getCacheService();
        AtomicInteger downloadedImageCount = new AtomicInteger(0);
        AtomicBoolean latchAborted = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(urlList.size());
        for (String url : urlList) {
            if (url == null || !UrlUtils.isValidUrl((String)url)) {
                latch.countDown();
                continue;
            }
            CacheResult cacheResult = cacheService.get(assetCacheLocation, url);
            if (cacheResult != null) {
                Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Found cached image for " + url), (Object[])new Object[0]);
                downloadedImageCount.incrementAndGet();
                latch.countDown();
                continue;
            }
            this.downloadImage(url, (Function1<? super HttpConnecting, Unit>)((Function1)new Function1<HttpConnecting, Unit>(latchAborted, url, latch, downloadedImageCount, cacheService){
                final /* synthetic */ AtomicBoolean $latchAborted;
                final /* synthetic */ String $url;
                final /* synthetic */ CountDownLatch $latch;
                final /* synthetic */ AtomicInteger $downloadedImageCount;
                final /* synthetic */ CacheService $cacheService;
                {
                    this.$latchAborted = $latchAborted;
                    this.$url = $url;
                    this.$latch = $latch;
                    this.$downloadedImageCount = $downloadedImageCount;
                    this.$cacheService = $cacheService;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@Nullable HttpConnecting connection) {
                    block10: {
                        if (!this.$latchAborted.get()) {
                            Bitmap image;
                            Bitmap bitmap = image = PushTemplateImageUtils.access$handleDownloadResponse(PushTemplateImageUtils.INSTANCE, this.$url, connection);
                            if (bitmap != null) {
                                Bitmap bitmap2 = bitmap;
                                AtomicInteger atomicInteger = this.$downloadedImageCount;
                                String string = this.$url;
                                CacheService cacheService = this.$cacheService;
                                Bitmap it = bitmap2;
                                boolean bl = false;
                                Bitmap pushImage = PushTemplateImageUtils.access$scaleBitmap(PushTemplateImageUtils.INSTANCE, it);
                                try {
                                    Object object = PushTemplateImageUtils.access$bitmapToInputStream(PushTemplateImageUtils.INSTANCE, pushImage);
                                    Throwable throwable = null;
                                    try {
                                        InputStream bitmapInputStream = (InputStream)object;
                                        boolean bl2 = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)cacheService, (String)"cacheService");
                                        PushTemplateImageUtils.access$cacheBitmapInputStream(PushTemplateImageUtils.INSTANCE, cacheService, bitmapInputStream, string);
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                                    }
                                    object = atomicInteger.incrementAndGet();
                                }
                                catch (IOException exception) {
                                    Log.warning((String)"PushTemplates", (String)"PushTemplateImageUtil", (String)("Exception occurred creating an input stream from a bitmap for {" + string + "}: " + exception.getLocalizedMessage() + '.'), (Object[])new Object[0]);
                                    Unit unit = Unit.INSTANCE;
                                }
                            }
                            this.$latch.countDown();
                        }
                        HttpConnecting httpConnecting = connection;
                        if (httpConnecting == null) break block10;
                        httpConnecting.close();
                    }
                }
            }));
        }
        try {
            if (latch.await(10L, TimeUnit.SECONDS)) {
                Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"All image downloads have completed.", (Object[])new Object[0]);
            } else {
                Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)"Timed out waiting for image downloads to complete.", (Object[])new Object[0]);
                latchAborted.set(true);
            }
        }
        catch (InterruptedException e) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)("Interrupted while waiting for image downloads to complete: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            latchAborted.set(true);
        }
        return downloadedImageCount.get();
    }

    private final void downloadImage(String url, Function1<? super HttpConnecting, Unit> completionCallback) {
        NetworkRequest networkRequest = new NetworkRequest(url, HttpMethod.GET, null, null, 10, 10);
        NetworkCallback networkCallback = arg_0 -> PushTemplateImageUtils.downloadImage$lambda$0(completionCallback, arg_0);
        ServiceProvider.getInstance().getNetworkService().connectAsync(networkRequest, networkCallback);
    }

    @Nullable
    public final Bitmap getCachedImage$notificationbuilder_phoneRelease(@Nullable String url) {
        CharSequence charSequence;
        String assetCacheLocation = this.getAssetCacheLocation$notificationbuilder_phoneRelease();
        if (url == null || !UrlUtils.isValidUrl((String)url) || (charSequence = (CharSequence)assetCacheLocation) == null || charSequence.length() == 0) {
            return null;
        }
        CacheResult cacheResult = ServiceProvider.getInstance().getCacheService().get(assetCacheLocation, url);
        if (cacheResult == null) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)("Image not found in cache for " + url), (Object[])new Object[0]);
            return null;
        }
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Found cached image for " + url), (Object[])new Object[0]);
        return BitmapFactory.decodeStream((InputStream)cacheResult.getData());
    }

    private final Bitmap handleDownloadResponse(String url, HttpConnecting connection) {
        Bitmap bitmap;
        block2: {
            if (connection == null) {
                Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)("Failed to download push notification image from url (" + url + "), received a null connection."), (Object[])new Object[0]);
                return null;
            }
            if (connection.getResponseCode() != 200) {
                Log.debug((String)"PushTemplates", (String)SELF_TAG, (String)("Failed to download push notification image from url (" + url + "). Response code was: " + connection.getResponseCode() + '.'), (Object[])new Object[0]);
                return null;
            }
            Bitmap bitmap2 = bitmap = BitmapFactory.decodeStream((InputStream)connection.getInputStream());
            if (bitmap2 == null) break block2;
            Bitmap it = bitmap2;
            boolean bl = false;
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Downloaded push notification image from url (" + url + ')'), (Object[])new Object[0]);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputStream bitmapToInputStream(Bitmap bitmap) {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)it);
            byte[] bitmapData = it.toByteArray();
            InputStream inputStream = new ByteArrayInputStream(bitmapData);
            return inputStream;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void cacheBitmapInputStream(CacheService cacheService, InputStream bitmapInputStream, String imageUrl) {
        block0: {
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Caching image downloaded from " + imageUrl + '.'), (Object[])new Object[0]);
            String string = this.getAssetCacheLocation$notificationbuilder_phoneRelease();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            CacheEntry cacheEntry = new CacheEntry(bitmapInputStream, CacheExpiry.after((long)PushTemplateConstants.DefaultValues.INSTANCE.getPUSH_NOTIFICATION_IMAGE_CACHE_EXPIRY_IN_MILLISECONDS$notificationbuilder_phoneRelease()), null);
            cacheService.set(it, imageUrl, cacheEntry);
        }
    }

    private final Bitmap scaleBitmap(Bitmap downloadedBitmap) {
        Matrix matrix = new Matrix();
        matrix.setRectToRect(new RectF(0.0f, 0.0f, (float)downloadedBitmap.getWidth(), (float)downloadedBitmap.getHeight()), new RectF(0.0f, 0.0f, 300.0f, 200.0f), Matrix.ScaleToFit.CENTER);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)downloadedBitmap, (int)0, (int)0, (int)downloadedBitmap.getWidth(), (int)downloadedBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n          \u2026           true\n        )");
        return bitmap;
    }

    @Nullable
    public final String getAssetCacheLocation$notificationbuilder_phoneRelease() {
        DeviceInforming deviceInforming = ServiceProvider.getInstance().getDeviceInfoService();
        if (deviceInforming == null) {
            return null;
        }
        DeviceInforming deviceInfoService = deviceInforming;
        File applicationCacheDir = deviceInfoService.getApplicationCacheDir();
        return applicationCacheDir == null ? null : applicationCacheDir.toString() + File.separator + "pushtemplates" + File.separator + "pushimagecache";
    }

    private static final void downloadImage$lambda$0(Function1 $completionCallback, HttpConnecting connection) {
        Intrinsics.checkNotNullParameter((Object)$completionCallback, (String)"$completionCallback");
        $completionCallback.invoke((Object)connection);
    }

    public static final /* synthetic */ Bitmap access$handleDownloadResponse(PushTemplateImageUtils $this, String url, HttpConnecting connection) {
        return $this.handleDownloadResponse(url, connection);
    }

    public static final /* synthetic */ void access$cacheBitmapInputStream(PushTemplateImageUtils $this, CacheService cacheService, InputStream bitmapInputStream, String imageUrl) {
        $this.cacheBitmapInputStream(cacheService, bitmapInputStream, imageUrl);
    }

    public static final /* synthetic */ Bitmap access$scaleBitmap(PushTemplateImageUtils $this, Bitmap downloadedBitmap) {
        return $this.scaleBitmap(downloadedBitmap);
    }

    public static final /* synthetic */ InputStream access$bitmapToInputStream(PushTemplateImageUtils $this, Bitmap bitmap) {
        return $this.bitmapToInputStream(bitmap);
    }
}

