/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.lifecycle.LifecycleTimerState;
import com.adobe.marketing.mobile.services.Log;

class LifecycleV2StateManager {
    private static final String SELF_LOG_TAG = "LifecycleV2StateManager";
    private final LifecycleTimerState updateTimer;
    private final Object stateUpdatesMutex = new Object();
    private State currentState;
    private AdobeCallback<Boolean> cancelableCallback;

    LifecycleV2StateManager() {
        this.updateTimer = new LifecycleTimerState("ADBLifecycleStateManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState(State newState, AdobeCallback<Boolean> callback) {
        if (callback == null || newState == null) {
            return;
        }
        Object object = this.stateUpdatesMutex;
        synchronized (object) {
            if (this.updateTimer.isTimerRunning()) {
                if (State.START.equals((Object)newState)) {
                    Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Consecutive pause-start state update detected, ignoring.", (Object[])new Object[0]);
                    this.cancelTimer();
                    callback.call((Object)false);
                } else if (State.PAUSE.equals((Object)newState)) {
                    Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"New pause state update received while waiting, restarting the count.", (Object[])new Object[0]);
                    this.restartTimer(newState, callback);
                }
                return;
            }
            if (this.currentState == newState) {
                Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Consecutive %s state update received, ignoring.", (Object[])new Object[]{this.currentState});
                callback.call((Object)false);
                return;
            }
            if (State.PAUSE.equals((Object)newState)) {
                Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"New pause state update received, waiting for %s (ms) before updating.", (Object[])new Object[]{500});
                this.startTimer(newState, callback);
            } else {
                Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"New start state update received.", (Object[])new Object[0]);
                this.currentState = newState;
                callback.call((Object)true);
            }
        }
    }

    private void startTimer(State newState, AdobeCallback<Boolean> callback) {
        this.cancelableCallback = callback;
        this.updateTimer.startTimer(500L, (AdobeCallback<Boolean>)((AdobeCallback)complete -> {
            Object object = this.stateUpdatesMutex;
            synchronized (object) {
                this.currentState = newState;
                this.updateTimer.cancel();
                callback.call((Object)true);
                this.cancelableCallback = null;
            }
        }));
    }

    private void restartTimer(State newState, AdobeCallback<Boolean> callback) {
        this.cancelTimer();
        this.startTimer(newState, callback);
    }

    private void cancelTimer() {
        if (this.cancelableCallback != null) {
            this.cancelableCallback.call((Object)false);
            this.cancelableCallback = null;
        }
        this.updateTimer.cancel();
    }

    static enum State {
        START("start"),
        PAUSE("pause");

        private final String value;

        private State(String value) {
            this.value = value;
        }
    }
}

