/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.lifecycle.LifecycleUtil;
import com.adobe.marketing.mobile.lifecycle.LifecycleV2DataStoreCache;
import com.adobe.marketing.mobile.lifecycle.LifecycleV2MetricsBuilder;
import com.adobe.marketing.mobile.lifecycle.LifecycleV2StateManager;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

class LifecycleV2Extension {
    private static final String SELF_LOG_TAG = "LifecycleV2Extension";
    private final LifecycleV2DataStoreCache dataStoreCache;
    private final LifecycleV2StateManager stateManager;
    private final LifecycleV2MetricsBuilder xdmMetricsBuilder;
    private final NamedCollection dataStore;
    private final DeviceInforming deviceInfoService;
    private final long BACKDATE_TIMESTAMP_OFFSET_MILLIS = 1000L;
    private final ExtensionApi extensionApi;

    LifecycleV2Extension(NamedCollection dataStore, DeviceInforming deviceInfoService, ExtensionApi extensionApi) {
        this(dataStore, deviceInfoService, null, extensionApi);
    }

    @VisibleForTesting
    LifecycleV2Extension(NamedCollection dataStore, DeviceInforming deviceInfoService, LifecycleV2MetricsBuilder metricsBuilder, ExtensionApi extensionApi) {
        this.dataStore = dataStore;
        this.deviceInfoService = deviceInfoService;
        this.extensionApi = extensionApi;
        this.stateManager = new LifecycleV2StateManager();
        this.dataStoreCache = new LifecycleV2DataStoreCache(dataStore);
        this.xdmMetricsBuilder = metricsBuilder != null ? metricsBuilder : new LifecycleV2MetricsBuilder(deviceInfoService);
    }

    void start(Event event, boolean isInstall) {
        this.stateManager.updateState(LifecycleV2StateManager.State.START, (AdobeCallback<Boolean>)((AdobeCallback)updated -> {
            if (!updated.booleanValue()) {
                return;
            }
            if (!isInstall && this.isCloseUnknown(this.dataStoreCache.getAppStartTimestampMillis(), this.dataStoreCache.getAppPauseTimestampMillis())) {
                Map<String, Object> appCloseXDMData = this.xdmMetricsBuilder.buildAppCloseXDMData(this.dataStoreCache.getAppStartTimestampMillis(), this.dataStoreCache.getCloseTimestampMillis(), event.getTimestamp() - 1000L, true);
                this.dispatchApplicationClose(appCloseXDMData, event);
            }
            long startTimestamp = event.getTimestamp();
            this.dataStoreCache.setAppStartTimestamp(startTimestamp);
            Map<String, Object> appLaunchXDMData = this.xdmMetricsBuilder.buildAppLaunchXDMData(startTimestamp, isInstall, this.isUpgrade());
            Map freeFormData = DataReader.optStringMap((Map)event.getEventData(), (String)"additionalcontextdata", null);
            this.dispatchApplicationLaunch(appLaunchXDMData, freeFormData, event);
            this.persistAppVersion();
        }));
    }

    void pause(Event event) {
        this.stateManager.updateState(LifecycleV2StateManager.State.PAUSE, (AdobeCallback<Boolean>)((AdobeCallback)updated -> {
            if (!updated.booleanValue()) {
                return;
            }
            long pauseTimestamp = event.getTimestamp();
            this.dataStoreCache.setAppPauseTimestamp(pauseTimestamp);
            Map<String, Object> appCloseXDMData = this.xdmMetricsBuilder.buildAppCloseXDMData(this.dataStoreCache.getAppStartTimestampMillis(), pauseTimestamp, pauseTimestamp, false);
            this.dispatchApplicationClose(appCloseXDMData, event);
        }));
    }

    void updateLastKnownTimestamp(Event event) {
        this.dataStoreCache.setLastKnownTimestamp(event.getTimestamp());
    }

    private boolean isCloseUnknown(long previousAppStart, long previousAppPause) {
        return previousAppStart <= 0L || previousAppStart > previousAppPause;
    }

    private boolean isUpgrade() {
        String previousAppVersion = "";
        if (this.dataStore != null) {
            previousAppVersion = this.dataStore.getString("v2LastAppVersion", "");
        }
        return this.deviceInfoService != null && !StringUtils.isNullOrEmpty((String)previousAppVersion) && !previousAppVersion.equalsIgnoreCase(LifecycleUtil.getV2AppVersion(this.deviceInfoService));
    }

    private void persistAppVersion() {
        if (this.dataStore != null && this.deviceInfoService != null) {
            this.dataStore.setString("v2LastAppVersion", LifecycleUtil.getV2AppVersion(this.deviceInfoService));
        }
    }

    private void dispatchApplicationLaunch(Map<String, Object> appLaunchXDMData, Map<String, String> freeFormData, @NonNull Event parentEvent) {
        if (appLaunchXDMData == null || appLaunchXDMData.isEmpty()) {
            Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Not dispatching application launch event as xdm data was null", (Object[])new Object[0]);
            return;
        }
        HashMap<String, Map<String, Object>> launchEventData = new HashMap<String, Map<String, Object>>();
        launchEventData.put("xdm", appLaunchXDMData);
        if (freeFormData != null && !freeFormData.isEmpty()) {
            launchEventData.put("data", freeFormData);
        }
        Event lifecycleLaunchEvent = new Event.Builder("Application Launch (Foreground)", "com.adobe.eventType.lifecycle", "com.adobe.eventSource.applicationLaunch").setEventData(launchEventData).chainToParentEvent(parentEvent).build();
        this.extensionApi.dispatch(lifecycleLaunchEvent);
    }

    private void dispatchApplicationClose(Map<String, Object> appCloseXDMData, @NonNull Event parentEvent) {
        if (appCloseXDMData == null || appCloseXDMData.isEmpty()) {
            Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Not dispatching application close event as xdm data was null", (Object[])new Object[0]);
            return;
        }
        HashMap<String, Map<String, Object>> closeEventData = new HashMap<String, Map<String, Object>>();
        closeEventData.put("xdm", appCloseXDMData);
        Event lifecycleCloseEvent = new Event.Builder("Application Close (Background)", "com.adobe.eventType.lifecycle", "com.adobe.eventSource.applicationClose").setEventData(closeEventData).chainToParentEvent(parentEvent).build();
        this.extensionApi.dispatch(lifecycleCloseEvent);
    }
}

