/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.lifecycle.LifecycleConstants;
import com.adobe.marketing.mobile.lifecycle.LifecycleSession;
import com.adobe.marketing.mobile.lifecycle.LifecycleState;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.util.DataReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class LifecycleV1Extension {
    private static final String SELF_LOG_TAG = "LifecycleV1Extension";
    private final NamedCollection dataStore;
    private final ExtensionApi extensionApi;
    private final LifecycleState lifecycleState;

    LifecycleV1Extension(NamedCollection dataStore, DeviceInforming deviceInfoService, ExtensionApi extensionApi) {
        this.dataStore = dataStore;
        this.extensionApi = extensionApi;
        this.lifecycleState = new LifecycleState(dataStore, deviceInfoService);
    }

    void start(Event startEvent, Map<String, Object> configurationSharedState, boolean isInstall) {
        Map eventData;
        Map additionalContextData;
        long startTimestampInSeconds = startEvent.getTimestampInSeconds();
        LifecycleSession.SessionInfo previousSessionInfo = this.lifecycleState.start(startTimestampInSeconds, additionalContextData = DataReader.optStringMap((Map)(eventData = startEvent.getEventData()), (String)"additionalcontextdata", null), this.getAdvertisingIdentifier(startEvent), this.getSessionTimeoutLength(configurationSharedState), isInstall);
        if (previousSessionInfo == null && this.dataStore != null) {
            long adjustedStartTimeInSeconds = this.dataStore.getLong("SessionStart", 0L);
            this.updateLifecycleSharedState(startEvent, adjustedStartTimeInSeconds, this.lifecycleState.getContextData());
            return;
        }
        this.updateLifecycleSharedState(startEvent, startTimestampInSeconds, this.lifecycleState.getContextData());
        if (previousSessionInfo != null) {
            this.dispatchSessionStart(startTimestampInSeconds, previousSessionInfo.getStartTimestampInSeconds(), previousSessionInfo.getPauseTimestampInSeconds(), startEvent);
        }
    }

    void pause(Event pauseEvent) {
        this.lifecycleState.pause(pauseEvent);
    }

    void onRegistered() {
        this.updateLifecycleSharedState(null, 0L, this.lifecycleState.computeBootData());
    }

    private String getAdvertisingIdentifier(Event event) {
        SharedStateResult identitySharedState = this.extensionApi.getSharedState("com.adobe.module.identity", event, false, SharedStateResolution.ANY);
        if (identitySharedState != null && identitySharedState.getStatus() == SharedStateStatus.SET) {
            return DataReader.optString((Map)identitySharedState.getValue(), (String)"advertisingidentifier", null);
        }
        return null;
    }

    private long getSessionTimeoutLength(Map<String, Object> configurationSharedState) {
        return DataReader.optLong(configurationSharedState, (String)"lifecycle.sessionTimeout", (long)300L);
    }

    private void updateLifecycleSharedState(Event event, long startTimestampInSeconds, Map<String, String> contextData) {
        HashMap<String, Object> lifecycleSharedState = new HashMap<String, Object>();
        lifecycleSharedState.put("maxsessionlength", LifecycleConstants.MAX_SESSION_LENGTH_SECONDS);
        lifecycleSharedState.put("lifecyclecontextdata", contextData);
        lifecycleSharedState.put("starttimestampmillis", TimeUnit.SECONDS.toMillis(startTimestampInSeconds));
        this.extensionApi.createSharedState(lifecycleSharedState, event);
    }

    private void dispatchSessionStart(long startTimestampInSeconds, long previousStartTimeInSeconds, long previousPauseTimeInSeconds, Event parentEvent) {
        HashMap<String, Object> eventDataMap = new HashMap<String, Object>();
        eventDataMap.put("lifecyclecontextdata", this.lifecycleState.getContextData());
        eventDataMap.put("sessionevent", "start");
        eventDataMap.put("maxsessionlength", LifecycleConstants.MAX_SESSION_LENGTH_SECONDS);
        eventDataMap.put("starttimestampmillis", TimeUnit.SECONDS.toMillis(startTimestampInSeconds));
        eventDataMap.put("previoussessionstarttimestampmillis", TimeUnit.SECONDS.toMillis(previousStartTimeInSeconds));
        eventDataMap.put("previoussessionpausetimestampmillis", TimeUnit.SECONDS.toMillis(previousPauseTimeInSeconds));
        Event startEvent = new Event.Builder("LifecycleStart", "com.adobe.eventType.lifecycle", "com.adobe.eventSource.responseContent").setEventData(eventDataMap).chainToParentEvent(parentEvent).build();
        this.extensionApi.dispatch(startEvent);
    }
}

