/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaignclassic.internal;

import android.app.Activity;
import android.app.RemoteInput;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.adobe.marketing.mobile.CampaignClassic;
import com.adobe.marketing.mobile.campaignclassic.internal.CampaignClassicPushBroadcastReceiver;
import com.adobe.marketing.mobile.notificationbuilder.NotificationBuilder;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0012\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/adobe/marketing/mobile/campaignclassic/internal/CampaignClassicPushTrackerActivity;", "Landroid/app/Activity;", "()V", "SELF_TAG", "", "executePushAction", "", "intent", "Landroid/content/Intent;", "getTrackInfo", "", "handleDismissed", "handleInputReceived", "handlePushClicked", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "openApplication", "intentExtras", "openUri", "uri", "campaignclassic_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nCampaignClassicPushTrackerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CampaignClassicPushTrackerActivity.kt\ncom/adobe/marketing/mobile/campaignclassic/internal/CampaignClassicPushTrackerActivity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n1#2:275\n*E\n"})
public final class CampaignClassicPushTrackerActivity
extends Activity {
    @NotNull
    private final String SELF_TAG;

    public CampaignClassicPushTrackerActivity() {
        this.SELF_TAG = "CampaignClassicPushTrackerActivity";
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null) {
            Log.warning((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)"Intent is null. Ignoring to track or take action on push notification interaction.", (Object[])new Object[0]);
            this.finish();
            return;
        }
        String action = this.getIntent().getAction();
        CharSequence charSequence = action;
        if (charSequence == null || charSequence.length() == 0) {
            Log.warning((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)"Intent action is null or empty. Ignoring to track or take action on push notification interaction.", (Object[])new Object[0]);
            this.finish();
            return;
        }
        switch (action) {
            case "Notification Clicked": {
                Intent intent = this.getIntent();
                Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
                this.handlePushClicked(intent);
                break;
            }
            case "Input Received": {
                Intent intent = this.getIntent();
                Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
                this.handleInputReceived(intent);
                break;
            }
            case "Notification Dismissed": {
                Intent intent = this.getIntent();
                Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
                this.handleDismissed(intent);
            }
        }
        this.finish();
    }

    private final void handleDismissed(Intent intent) {
        CampaignClassic.trackNotificationClick(this.getTrackInfo(intent));
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            return;
        }
        Context context2 = context;
        String tag = intent.getStringExtra("adb_tag");
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context2);
        Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(context)");
        NotificationManagerCompat notificationManager = notificationManagerCompat;
        CharSequence charSequence = tag;
        if (charSequence == null || charSequence.length() == 0) {
            Log.warning((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)("Unable to remove notification for " + this.getApplication().getPackageName() + ", the tag is null or empty,"), (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)("Removing notification with tag " + tag), (Object[])new Object[0]);
        notificationManager.cancel(tag.hashCode());
    }

    private final void handleInputReceived(Intent intent) {
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            return;
        }
        Context context2 = context;
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context2);
        Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(context)");
        NotificationManagerCompat notificationManager = notificationManagerCompat;
        Bundle bundle = intent.getExtras();
        String tag = bundle != null ? bundle.getString("adb_tag") : null;
        CharSequence charSequence = tag;
        if (charSequence == null || charSequence.length() == 0) {
            Log.warning((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)("Tag is null or empty for the notification with action " + intent.getAction() + ",default to removing all displayed notifications for " + this.getApplication().getPackageName()), (Object[])new Object[0]);
            return;
        }
        Bundle results = RemoteInput.getResultsFromIntent((Intent)intent);
        if (results != null) {
            String remoteInputResultKey = intent.getStringExtra("adb_input_receiver");
            CharSequence inputReplyResult = results.getCharSequence(remoteInputResultKey);
            Log.trace((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)("Input " + inputReplyResult + " received for notification with tag " + tag + '.'), (Object[])new Object[0]);
            Bundle intentExtra = new Bundle();
            intentExtra.putString(remoteInputResultKey, String.valueOf(inputReplyResult));
            this.openApplication(intentExtra);
        }
        Log.trace((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)("Recreating notification with tag " + tag + '.'), (Object[])new Object[0]);
        NotificationCompat.Builder builder = NotificationBuilder.constructNotificationBuilder((Intent)intent, CampaignClassicPushTrackerActivity.class, CampaignClassicPushBroadcastReceiver.class);
        notificationManager.notify(tag.hashCode(), builder.build());
    }

    private final void handlePushClicked(Intent intent) {
        CampaignClassic.trackNotificationClick(this.getTrackInfo(intent));
        this.executePushAction(intent);
    }

    private final Map<String, String> getTrackInfo(Intent intent) {
        Map trackInfo = new LinkedHashMap();
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return trackInfo;
        }
        Bundle extras = bundle;
        for (String key : extras.keySet()) {
            String value = extras.getString(key);
            if (value == null) continue;
            if (Intrinsics.areEqual((Object)key, (Object)"_mId")) {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                trackInfo.put(key, value);
                continue;
            }
            if (!Intrinsics.areEqual((Object)key, (Object)"_dId")) continue;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            trackInfo.put(key, value);
        }
        return trackInfo;
    }

    private final void executePushAction(Intent intent) {
        String actionUri = intent.getStringExtra("actionUri");
        CharSequence charSequence = actionUri;
        if (charSequence == null || charSequence.length() == 0) {
            this.openApplication(intent.getExtras());
        } else {
            this.openUri(actionUri, intent.getExtras());
        }
        String string = intent.getStringExtra("adb_sticky");
        boolean isStickyNotification = string != null ? Boolean.parseBoolean(string) : false;
        String tag = intent.getStringExtra("adb_tag");
        if (isStickyNotification) {
            Log.trace((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)("the sticky notification setting is true, will not remove the notification with tag " + tag + '.'), (Object[])new Object[0]);
            return;
        }
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        if (context == null) {
            return;
        }
        Context context2 = context;
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context2);
        Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(context)");
        NotificationManagerCompat notificationManager = notificationManagerCompat;
        CharSequence charSequence2 = tag;
        if (charSequence2 == null || charSequence2.length() == 0) {
            Log.warning((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)("the sticky notification setting is false but the tag is null or empty, default to removing all displayed notifications for " + this.getApplication().getPackageName()), (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)("the sticky notification setting is false, removing notification with tag " + tag), (Object[])new Object[0]);
        notificationManager.cancel(tag.hashCode());
    }

    private final void openApplication(Bundle intentExtras) {
        Intent launchIntent;
        Intent intent;
        Activity currentActivity = ServiceProvider.getInstance().getAppContextService().getCurrentActivity();
        if (currentActivity != null) {
            intent = new Intent((Context)currentActivity, currentActivity.getClass());
        } else {
            Log.debug((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)"There is no active activity. Starting the launcher Activity.", (Object[])new Object[0]);
            intent = launchIntent = this.getPackageManager().getLaunchIntentForPackage(this.getPackageName());
        }
        if (launchIntent != null) {
            launchIntent.setFlags(0x24000000);
            Bundle bundle = intentExtras;
            if (bundle != null) {
                Bundle it = bundle;
                boolean bl = false;
                launchIntent.putExtras(intentExtras);
            }
            this.startActivity(launchIntent);
        } else {
            Log.warning((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)"Unable to create an intent to open the application from the notification interaction.", (Object[])new Object[0]);
        }
    }

    private final void openUri(String uri, Bundle intentExtras) {
        try {
            Intent deeplinkIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
            deeplinkIntent.setFlags(0x24000000);
            Bundle bundle = intentExtras;
            if (bundle != null) {
                Bundle it = bundle;
                boolean bl = false;
                deeplinkIntent.putExtras(intentExtras);
            }
            this.startActivity(deeplinkIntent);
        }
        catch (ActivityNotFoundException e) {
            Log.warning((String)"CampaignClassicExtension", (String)this.SELF_TAG, (String)("Unable to open the URI from the notification interaction. URI: " + uri), (Object[])new Object[0]);
        }
    }
}

