/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaignclassic.internal;

import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;

class CampaignClassicMapSerializer {
    private CampaignClassicMapSerializer() {
    }

    public static String serializeMap(Map<String, Object> input) {
        HashMap validInput = input == null ? new HashMap() : input;
        StringBuilder sb = new StringBuilder();
        sb.append("<additionalParameters>");
        for (Map.Entry entry : validInput.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            sb.append(CampaignClassicMapSerializer.serializeObject(value, key));
        }
        sb.append("</additionalParameters>");
        return sb.toString();
    }

    private static String serializeObject(Object o, String key) {
        Boolean b;
        String value = o instanceof String ? (String)o : (o instanceof Integer ? String.valueOf((Integer)o) : (o instanceof Float ? String.valueOf((Float)o) : (o instanceof Double ? String.valueOf((Double)o) : (o instanceof Long ? String.valueOf((Long)o) : (o instanceof Byte ? String.valueOf((Byte)o) : (o instanceof Character ? String.valueOf((Object)((Character)o).charValue()) : (o instanceof Short ? String.valueOf((Short)o) : (o instanceof Boolean ? ((b = (Boolean)o) != false ? "true" : "false") : o.toString()))))))));
        return "<param name=\"" + CampaignClassicMapSerializer.escapeXMLAttrString(key) + "\" value=\"" + CampaignClassicMapSerializer.escapeXMLAttrString(value) + "\"/>";
    }

    private static String escapeXMLAttrString(String attributeString) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(attributeString);
        char c = iter.current();
        while (c != '\uffff') {
            result.append(CampaignClassicMapSerializer.escapeXMLAttrChar(c));
            c = iter.next();
        }
        return result.toString();
    }

    private static String escapeXMLAttrChar(char attributeChar) {
        switch (attributeChar) {
            case '\r': {
                return "";
            }
            case '\n': {
                return "";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return String.valueOf(attributeChar);
    }
}

